/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.junit;

import com.caucho.config.inject.InjectManager;
import com.caucho.junit.ResinBeanConfiguration;
import com.caucho.resin.BeanContainerRequest;
import com.caucho.resin.ResinBeanContainer;
import java.lang.annotation.Annotation;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResinBeanContainerRunner
extends BlockJUnit4ClassRunner {
    private Class<?> _testClass;
    private ResinBeanContainer _beanContainer;
    private ResinBeanConfiguration _beanConfiguration;

    public ResinBeanContainerRunner(Class<?> testClass) throws Throwable {
        super(testClass);
        this._testClass = testClass;
        this._beanConfiguration = testClass.getAnnotation(ResinBeanConfiguration.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        ResinBeanContainer beanContainer = this.getResinContext();
        BeanContainerRequest request = beanContainer.beginRequest();
        try {
            super.runChild(method, notifier);
        }
        finally {
            request.close();
        }
    }

    protected Object createTest() throws Exception {
        InjectManager manager = this.getResinContext().getInstance(InjectManager.class, new Annotation[0]);
        return manager.createTransientObject(this._testClass);
    }

    protected ResinBeanContainer getResinContext() {
        if (this._beanContainer == null) {
            this._beanContainer = new ResinBeanContainer();
            String userName = System.getProperty("user.name");
            String workDir = "file:/tmp/" + userName;
            this._beanContainer.setWorkDirectory(workDir);
            if (this._beanConfiguration != null) {
                for (String module : this._beanConfiguration.modules()) {
                    this._beanContainer.addModule(module);
                }
                for (String conf : this._beanConfiguration.beansXml()) {
                    this._beanContainer.addBeansXml(conf);
                }
            }
            this._beanContainer.start();
        }
        return this._beanContainer;
    }
}

