/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.lifecycle;

import com.caucho.lifecycle.LifecycleListener;
import com.caucho.lifecycle.LifecycleState;
import com.caucho.util.Alarm;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Lifecycle {
    private final Logger _log;
    private String _name;
    private Level _level = Level.FINE;
    private Level _lowLevel = Level.FINER;
    private final AtomicReference<LifecycleState> _state = new AtomicReference<LifecycleState>(LifecycleState.NEW);
    private long _activeCount;
    private long _failCount;
    private long _lastFailTime;
    private long _lastChangeTime;
    private ArrayList<WeakReference<LifecycleListener>> _listeners;

    public Lifecycle() {
        this._log = null;
    }

    public Lifecycle(Logger log) {
        this._log = log;
    }

    public Lifecycle(Logger log, String name) {
        this._log = log;
        this._name = name;
    }

    public Lifecycle(Logger log, String name, Level level) {
        this._log = log;
        this._name = name;
        this.setLevel(level);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public Level getLevel() {
        return this._level;
    }

    public void setLevel(Level level) {
        this._level = level;
        if (level.intValue() < this._lowLevel.intValue()) {
            this._lowLevel = level;
        }
    }

    public final LifecycleState getState() {
        return this._state.get();
    }

    public int getStateOrdinal() {
        return this._state.get().ordinal();
    }

    public String getStateName() {
        return this.getState().toString();
    }

    public long getLastChangeTime() {
        return this._lastChangeTime;
    }

    public long getLastFailTime() {
        return this._lastFailTime;
    }

    public long getActiveCount() {
        return this._activeCount;
    }

    public long getFailCount() {
        return this._failCount;
    }

    public boolean isInitializing() {
        return this.getState().isInitializing();
    }

    public boolean isInit() {
        return this.getState().isInit();
    }

    public boolean isBeforeInit() {
        return this.getState().isBeforeInit();
    }

    public boolean isAfterInit() {
        return this.getState().isAfterInit();
    }

    public boolean isIdle() {
        return this.getState().isIdle();
    }

    public boolean isStarting() {
        return this.getState().isStarting();
    }

    public boolean isWarmup() {
        return this.getState().isWarmup();
    }

    public boolean isBeforeActive() {
        return this.getState().isBeforeActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitForActive(long timeout) {
        LifecycleState state = this.getState();
        if (state.isActive()) {
            return true;
        }
        if (state.isAfterActive()) {
            return false;
        }
        long waitEnd = Alarm.getCurrentTime() + timeout;
        Lifecycle lifecycle = this;
        synchronized (lifecycle) {
            while ((state = this._state.get()).isBeforeActive()) {
                if (Alarm.getCurrentTime() >= waitEnd) return this._state.get().isActive();
                if (state.isActive()) {
                    return true;
                }
                if (state.isAfterActive()) {
                    return false;
                }
                if (Alarm.isTest()) {
                    return false;
                }
                try {
                    long delta = waitEnd - Alarm.getCurrentTime();
                    if (delta <= 0L) continue;
                    this.wait(delta);
                }
                catch (InterruptedException e) {}
            }
            return this._state.get().isActive();
        }
    }

    public boolean isActive() {
        return this.getState().isActive();
    }

    public boolean isRunnable() {
        return this.getState().isRunnable();
    }

    public boolean isAfterStopping() {
        return this.getState().isAfterStopping();
    }

    public boolean isError() {
        return this.getState().isError();
    }

    public boolean isFailed() {
        return this.getState().isError();
    }

    public boolean isStopping() {
        return this.getState().isStopping();
    }

    public boolean isStopped() {
        return this.getState().isStopped();
    }

    public boolean isDestroying() {
        return this.getState().isDestroying();
    }

    public boolean isDestroyed() {
        return this.getState().isDestroyed();
    }

    public boolean toInitializing() {
        return this.toNextState(LifecycleState.INITIALIZING);
    }

    public boolean toInit() {
        return this.toNextState(LifecycleState.INIT);
    }

    public boolean toPostInit() {
        if (this._state.compareAndSet(LifecycleState.STOPPED, LifecycleState.INIT)) {
            this._lastChangeTime = Alarm.getCurrentTime();
            this.notifyListeners(LifecycleState.STOPPED, LifecycleState.INIT);
            return true;
        }
        return this._state.get().isInit();
    }

    public boolean toStarting() {
        LifecycleState state;
        do {
            if (!(state = this._state.get()).isAfterStarting() || state.isStopped()) continue;
            return false;
        } while (!this._state.compareAndSet(state, LifecycleState.STARTING));
        this._lastChangeTime = Alarm.getCurrentTime();
        if (this._log != null && this._log.isLoggable(this._level) && this._log.isLoggable(Level.FINE)) {
            this._log.fine(this._name + " starting");
        }
        this.notifyListeners(state, LifecycleState.STARTING);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toActive() {
        LifecycleState state;
        do {
            if (!(state = this._state.get()).isAfterActive() || state.isStopped()) continue;
            return false;
        } while (!this._state.compareAndSet(state, LifecycleState.ACTIVE));
        this._lastChangeTime = Alarm.getCurrentTime();
        if (this._log != null && this._log.isLoggable(this._level)) {
            this._log.log(this._level, this._name + " active");
        }
        this.notifyListeners(state, LifecycleState.ACTIVE);
        Lifecycle lifecycle = this;
        synchronized (lifecycle) {
            this.notifyAll();
        }
        return true;
    }

    public boolean toError() {
        return this.toFail();
    }

    public boolean toFail() {
        LifecycleState state;
        do {
            if (!(state = this._state.get()).isAfterDestroying()) continue;
            return false;
        } while (!this._state.compareAndSet(state, LifecycleState.FAILED));
        this._lastChangeTime = Alarm.getCurrentTime();
        if (this._log != null && this._log.isLoggable(this._level)) {
            this._log.log(this._level, this._name + " fail");
        }
        this.notifyListeners(state, LifecycleState.FAILED);
        ++this._failCount;
        return true;
    }

    public boolean toStopping() {
        LifecycleState state;
        do {
            if (!(state = this._state.get()).isAfterStopping() && !state.isStarting()) continue;
            return false;
        } while (!this._state.compareAndSet(state, LifecycleState.STOPPING));
        this._lastChangeTime = Alarm.getCurrentTime();
        if (this._log != null && this._log.isLoggable(this._level)) {
            this._log.log(this._level, this._name + " stopping");
        }
        this.notifyListeners(state, LifecycleState.STOPPING);
        return true;
    }

    public boolean toIdle() {
        return this.toState(LifecycleState.STOPPED_IDLE);
    }

    public boolean toStop() {
        return this.toNextState(LifecycleState.STOPPED);
    }

    public boolean toDestroying() {
        return this.toNextState(LifecycleState.DESTROYING);
    }

    public boolean toDestroy() {
        return this.toNextState(LifecycleState.DESTROYED);
    }

    private boolean toNextState(LifecycleState newState) {
        LifecycleState state;
        do {
            state = this._state.get();
            if (newState.ordinal() > state.ordinal()) continue;
            return false;
        } while (!this._state.compareAndSet(state, newState));
        this._lastChangeTime = Alarm.getCurrentTime();
        if (this._log != null && this._log.isLoggable(this._lowLevel)) {
            this._log.log(this._lowLevel, this._name + " " + (Object)((Object)newState));
        }
        this.notifyListeners(state, newState);
        return true;
    }

    private boolean toState(LifecycleState newState) {
        LifecycleState state = this._state.getAndSet(newState);
        this._lastChangeTime = Alarm.getCurrentTime();
        if (this._log != null && this._log.isLoggable(this._lowLevel)) {
            this._log.log(this._lowLevel, this._name + " " + (Object)((Object)newState));
        }
        this.notifyListeners(state, newState);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(LifecycleListener listener) {
        Lifecycle lifecycle = this;
        synchronized (lifecycle) {
            if (this.isDestroyed()) {
                IllegalStateException e = new IllegalStateException("attempted to add listener to a destroyed lifecyle " + this);
                if (this._log != null) {
                    this._log.log(Level.WARNING, e.toString(), e);
                } else {
                    Logger.getLogger(Lifecycle.class.getName()).log(Level.WARNING, e.toString(), e);
                }
                return;
            }
            if (this._listeners == null) {
                this._listeners = new ArrayList();
            }
            for (int i = this._listeners.size() - 1; i >= 0; --i) {
                LifecycleListener oldListener = (LifecycleListener)this._listeners.get(i).get();
                if (listener == oldListener) {
                    return;
                }
                if (oldListener != null) continue;
                this._listeners.remove(i);
            }
            this._listeners.add(new WeakReference<LifecycleListener>(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(LifecycleListener listener) {
        Lifecycle lifecycle = this;
        synchronized (lifecycle) {
            if (this._listeners == null) {
                return;
            }
            for (int i = this._listeners.size() - 1; i >= 0; --i) {
                LifecycleListener oldListener = (LifecycleListener)this._listeners.get(i).get();
                if (listener == oldListener) {
                    this._listeners.remove(i);
                    return;
                }
                if (oldListener != null) continue;
                this._listeners.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(LifecycleState oldState, LifecycleState newState) {
        if (this._listeners == null) {
            return;
        }
        Lifecycle lifecycle = this;
        synchronized (lifecycle) {
            if (this._listeners != null) {
                for (int i = 0; i < this._listeners.size(); ++i) {
                    LifecycleListener listener = (LifecycleListener)this._listeners.get(i).get();
                    if (listener != null) {
                        listener.lifecycleEvent(oldState, newState);
                        continue;
                    }
                    this._listeners.remove(i);
                    --i;
                }
            }
        }
    }

    public void copyState(Lifecycle source) {
        this._state.set(source._state.get());
    }

    public String toString() {
        if (this._name != null) {
            return "Lifecycle[" + this._name + ", " + this.getStateName() + "]";
        }
        return "Lifecycle[" + this.getStateName() + "]";
    }
}

