/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.config.ConfigException;
import com.caucho.loader.ClassEntry;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Loader {
    protected static final Logger log = Logger.getLogger(Loader.class.getName());
    private DynamicClassLoader _loader;

    protected Loader() {
        this(Thread.currentThread().getContextClassLoader());
    }

    protected Loader(ClassLoader loader) {
        if (!(loader instanceof DynamicClassLoader)) {
            throw new IllegalStateException("'" + loader + "' must be created in a DynamicClassLoader context");
        }
        this._loader = (DynamicClassLoader)loader;
    }

    public void setLoader(DynamicClassLoader loader) {
        this._loader = loader;
    }

    public DynamicClassLoader getClassLoader() {
        return this._loader;
    }

    public void validate() throws ConfigException {
    }

    @PostConstruct
    public void init() {
        if (this._loader != null) {
            this._loader.addLoader(this);
        }
    }

    protected Class<?> loadClass(String name) {
        return null;
    }

    protected ClassEntry getClassEntry(String name, String pathName) throws ClassNotFoundException {
        Path path = this.getPath(pathName);
        if (path != null && path.getLength() > 0L) {
            return new ClassEntry(this._loader, name, path, path, this.getCodeSource(path));
        }
        return null;
    }

    public URL getResource(String name) {
        Path path = this.getPath(name);
        if (path != null && path.exists()) {
            try {
                return new URL(path.getURL());
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        return null;
    }

    public void getResources(Vector<URL> resources, String name) {
        Path path = this.getPath(name);
        if (path != null && path.canRead()) {
            try {
                resources.add(new URL(path.getURL()));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public InputStream getResourceAsStream(String name) {
        Path path = this.getPath(name);
        if (path != null && path.canRead()) {
            try {
                return path.openRead();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Path getPath(String name) {
        return null;
    }

    protected CodeSource getCodeSource(Path path) {
        try {
            if (path instanceof JarPath) {
                JarPath jarPath = (JarPath)path;
                path = jarPath.getContainer();
            }
            return new CodeSource(new URL(path.getURL()), path.getCertificates());
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    protected void buildClassPath(ArrayList<String> pathList) {
    }

    protected void buildSourcePath(ArrayList<String> pathList) {
        this.buildClassPath(pathList);
    }

    protected void destroy() {
    }
}

