/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.config.ConfigException;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.module.ArtifactDependency;
import com.caucho.loader.module.ArtifactRepository;
import com.caucho.loader.module.ArtifactVersionRange;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

public class ModuleConfig {
    private static final L10N L = new L10N(ModuleConfig.class);
    private static final Logger log = Logger.getLogger(ModuleConfig.class.getName());
    private Path _path;
    private String _org;
    private String _name;
    private ArtifactVersionRange _version;
    private String _module;

    public void setPath(Path path) {
        if (!path.getTail().endsWith(".jar")) {
            throw new ConfigException(L.l("module path='{0}' must be a jar file.", path));
        }
        this._path = path;
    }

    public void setOrg(String org) {
        this._org = org;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setModule(String module) {
        this._module = module;
    }

    public void setRev(String rev) {
        this.setVersion(rev);
    }

    public void setVersion(String version) {
        this._version = ArtifactVersionRange.create(version);
    }

    public void setStart(boolean isStart) {
    }

    @PostConstruct
    public void init() {
        if (this._path == null && this._name == null) {
            throw new ConfigException(L.l("module requires either a 'path' or a 'name' attribute"));
        }
        Path path = null;
        if (this._path == null) {
            ArtifactRepository repository = ArtifactRepository.getCurrent();
            if (repository == null) {
                throw new IllegalStateException(L.l("Cannot find dependency because no repositories are configured."));
            }
            ArtifactDependency dependency = new ArtifactDependency(this._org, null, this._name, this._version);
            EnvironmentClassLoader loader = Environment.getEnvironmentClassLoader();
            loader.createArtifactManager().addDependency(dependency);
            return;
        }
        path = this._path;
        if (path == null) {
            throw new ConfigException(L.l("Can't find artifact '{0}'", this._name));
        }
        EnvironmentClassLoader loader = Environment.getEnvironmentClassLoader();
        loader.addJar(path);
    }
}

