/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.config.Config;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.server.util.CauchoSystem;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

public class SystemClassLoader
extends EnvironmentClassLoader
implements EnvironmentBean {
    private AtomicBoolean _isInit = new AtomicBoolean();
    private boolean _hasBootClassPath;
    private Path _libexec;

    public SystemClassLoader(ClassLoader parent) {
        super(parent, "system");
        String smallmem;
        String preScan = System.getProperty("caucho.jar.prescan");
        preScan = "false";
        if (preScan == null || !"false".equals(preScan)) {
            DynamicClassLoader.setJarCacheEnabled(true);
        }
        if ((smallmem = System.getProperty("caucho.smallmem")) != null && !"false".equals(smallmem)) {
            DynamicClassLoader.setJarCacheEnabled(false);
        }
    }

    public boolean isJarCacheEnabled() {
        return DynamicClassLoader.isJarCacheEnabledDefault();
    }

    public ClassLoader getClassLoader() {
        return this;
    }

    public void init() {
        if (this._isInit.getAndSet(true)) {
            return;
        }
        this.initClasspath();
        super.init();
        String systemConf = System.getProperty("system.conf");
        if (systemConf != null) {
            try {
                Path path = Vfs.lookup(systemConf);
                Config config = new Config();
                config.configure((Object)this, path, this.getSchema());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initClasspath() {
        boolean isValid = false;
        try {
            try {
                String boot = System.getProperty("sun.boot.class.path");
                if (boot != null) {
                    this.initClasspath(boot);
                    this._hasBootClassPath = true;
                    this.initExtDirs("java.ext.dirs");
                    this.initExtDirs("java.endorsed.dirs");
                }
                this.initClasspath(System.getProperty("java.class.path"));
                isValid = true;
            }
            catch (IOException e) {
                e.printStackTrace();
                Object var4_5 = null;
                if (!isValid) {
                    this._hasBootClassPath = false;
                }
            }
            Object var4_4 = null;
            if (!isValid) {
                this._hasBootClassPath = false;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (!isValid) {
                this._hasBootClassPath = false;
            }
            throw throwable;
        }
    }

    private void initExtDirs(String prop) throws IOException {
        String extDirPath = System.getProperty(prop);
        if (extDirPath == null) {
            return;
        }
        for (String extDir : extDirPath.split(File.pathSeparator, 512)) {
            Path dir = Vfs.lookup(extDir);
            for (String fileName : dir.list()) {
                Path root = dir.lookup(fileName);
                try {
                    if (!root.isDirectory() && (!root.isFile() || !root.getPath().endsWith(".jar") && !root.getPath().endsWith(".zip"))) continue;
                    this.addRoot(root);
                }
                catch (Throwable e) {
                    this._hasBootClassPath = false;
                    e.printStackTrace();
                }
            }
        }
    }

    private void initClasspath(String classpath) {
        String[] classpathElements;
        for (String classpathElement : classpathElements = classpath.split(File.pathSeparator, 512)) {
            Path root = Vfs.lookup(classpathElement);
            try {
                if (!root.exists()) continue;
                this.addRoot(root);
            }
            catch (Throwable e) {
                this._hasBootClassPath = false;
                e.printStackTrace();
            }
        }
    }

    protected void initEnvironment() {
    }

    public Class loadClassImpl(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cl = this.findLoadedClass(name);
        if (cl != null) {
            if (resolve) {
                this.resolveClass(cl);
            }
            return cl;
        }
        return super.loadClassImpl(name, resolve);
    }

    protected String getSchema() {
        return "com/caucho/loader/system.rnc";
    }

    private Path getLibexec() {
        if (this._libexec == null) {
            this._libexec = CauchoSystem.isWindows() ? (CauchoSystem.is64Bit() ? CauchoSystem.getResinHome().lookup("win64") : CauchoSystem.getResinHome().lookup("win32")) : (CauchoSystem.is64Bit() ? CauchoSystem.getResinHome().lookup("libexec") : CauchoSystem.getResinHome().lookup("libexec64"));
        }
        return this._libexec;
    }

    public String findLibrary(String name) {
        Path path = this.getLibexec().lookup("lib" + name + ".so");
        if (path.canRead()) {
            return path.getNativePath();
        }
        path = this.getLibexec().lookup("lib" + name + ".jnilib");
        if (path.canRead()) {
            return path.getNativePath();
        }
        path = this.getLibexec().lookup(name + ".dll");
        return super.findLibrary(name);
    }
}

