/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader.enhancer;

import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JavaClass;
import com.caucho.config.ConfigException;
import com.caucho.java.gen.GenClass;
import com.caucho.loader.enhancer.ClassEnhancer;
import com.caucho.loader.enhancer.EnhancerManager;
import com.caucho.util.L10N;
import java.util.logging.Logger;

public class ClassEnhancerConfig
implements ClassEnhancer {
    private static final L10N L = new L10N(ClassEnhancerConfig.class);
    private static final Logger log = Logger.getLogger(ClassEnhancerConfig.class.getName());
    private EnhancerManager _manager;
    private Class _annotation;
    private Class _type;
    private boolean _isStatic = true;
    private ClassEnhancer _enhancer;

    public void setEnhancerManager(EnhancerManager manager) {
        this._manager = manager;
    }

    public void setAnnotation(Class ann) {
        this._annotation = ann;
    }

    public Class getAnnotation() {
        return this._annotation;
    }

    public void setType(Class type) throws Exception {
        this._type = type;
        if (!ClassEnhancer.class.isAssignableFrom(type)) {
            throw new ConfigException(L.l("'{0}' is an unsupported class enhancer type.  ClassEnhancer is required.", type.getName()));
        }
        this._enhancer = (ClassEnhancer)type.newInstance();
    }

    public void setStatic(boolean isStatic) {
        this._isStatic = isStatic;
    }

    public Object createInit() {
        return this._enhancer;
    }

    public void init() throws ConfigException {
    }

    public boolean shouldEnhance(String className) {
        return this._enhancer.shouldEnhance(className);
    }

    public void preEnhance(JavaClass baseClass) throws Exception {
        this._enhancer.preEnhance(baseClass);
    }

    public void enhance(GenClass genClass, JClass baseClass, String extClassName) throws Exception {
        this._enhancer.enhance(genClass, baseClass, extClassName);
    }

    public void postEnhance(JavaClass extClass) throws Exception {
        this._enhancer.postEnhance(extClass);
    }
}

