/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader.module;

import com.caucho.util.L10N;

public class ArtifactVersion {
    private static final L10N L = new L10N(ArtifactVersion.class);
    private final int _major;
    private final int _minor;
    private final int _micro;
    private final String _qualifier;

    public ArtifactVersion(int major, int minor, int micro, String qualifier) {
        this._major = major;
        this._minor = minor;
        this._micro = micro;
        this._qualifier = qualifier;
        if ("".equals(qualifier)) {
            throw new IllegalArgumentException(L.l("qualifier may not be the empty string"));
        }
    }

    public static ArtifactVersion create(String value) {
        int i;
        int major = 0;
        int minor = 0;
        int micro = 0;
        String qualifier = null;
        int length = value.length();
        char ch = '\u0000';
        for (i = 0; i < length && '0' <= (ch = value.charAt(i)) && ch <= '9'; ++i) {
            major = 10 * major + ch - 48;
        }
        if (i < length && ch == '.') {
            ++i;
        }
        while (i < length && '0' <= (ch = value.charAt(i)) && ch <= '9') {
            minor = 10 * minor + ch - 48;
            ++i;
        }
        if (i < length && ch == '.') {
            ++i;
        }
        while (i < length && '0' <= (ch = value.charAt(i)) && ch <= '9') {
            micro = 10 * micro + ch - 48;
            ++i;
        }
        if (i < length && (ch == '-' || ch == '_' || ch == '.')) {
            ++i;
        }
        if (i < length) {
            qualifier = value.substring(i);
        }
        return new ArtifactVersion(major, minor, micro, qualifier);
    }

    public int compareTo(ArtifactVersion version) {
        if (this._major < version._major) {
            return -1;
        }
        if (version._major < this._major) {
            return 1;
        }
        if (this._minor < version._minor) {
            return -1;
        }
        if (version._minor < this._minor) {
            return 1;
        }
        if (this._micro < version._micro) {
            return -1;
        }
        if (version._micro < this._micro) {
            return 1;
        }
        if (this._qualifier == null && version._qualifier != null) {
            return -1;
        }
        if (this._qualifier != null && version._qualifier == null) {
            return 1;
        }
        if (this._qualifier == null && version._qualifier == null) {
            return 0;
        }
        return this._qualifier.compareTo(version._qualifier);
    }

    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._major);
        sb.append(".").append(this._minor);
        sb.append(".").append(this._micro);
        if (this._qualifier != null) {
            sb.append("-").append(this._qualifier);
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[").append(this._major);
        sb.append(".").append(this._minor);
        sb.append(".").append(this._micro);
        if (this._qualifier != null) {
            sb.append("-").append(this._qualifier);
        }
        sb.append("]");
        return sb.toString();
    }
}

