/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import com.caucho.config.ConfigException;
import com.caucho.config.types.Bytes;
import com.caucho.config.types.CronType;
import com.caucho.config.types.Period;
import com.caucho.env.thread.TaskWorker;
import com.caucho.log.EnvironmentStream;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipOutputStream;

public class AbstractRolloverLog {
    protected static final L10N L = new L10N(AbstractRolloverLog.class);
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private static final long DEFAULT_ROLLOVER_SIZE = 0x3FFFFFFFFFFFFFFFL;
    private static final long DEFAULT_ROLLOVER_CHECK_PERIOD = 600000L;
    private static final long ROLLOVER_OVERFLOW_MAX = 0x4000000L;
    private String _rolloverPrefix;
    private String _archiveFormat;
    private String _archiveSuffix = "";
    private CronType _rolloverCron;
    private long _rolloverPeriod = 4611686018427387000L;
    private long _rolloverSize = 0x3FFFFFFFFFFFFFFFL;
    private long _rolloverCheckPeriod = 120000L;
    private int _rolloverCount;
    private QDate _calendar = QDate.createLocal();
    private Path _pwd = Vfs.lookup();
    protected Path _path;
    protected String _pathFormat;
    private String _format;
    private long _nextPeriodEnd = -1L;
    private long _nextRolloverCheckTime = -1L;
    private long _lastTime;
    private final RolloverWorker _rolloverWorker = new RolloverWorker();
    private final Object _logLock = new Object();
    private volatile boolean _isRollingOver;
    private TempStream _tempStream;
    private long _tempStreamSize;
    private WriteStream _os;
    private WriteStream _zipOut;

    public Path getPath() {
        return this._path;
    }

    public void setPath(Path path) {
        this._path = path;
    }

    public Path getPwd() {
        return this._pwd;
    }

    public String getPathFormat() {
        return this._pathFormat;
    }

    public void setPathFormat(String pathFormat) throws ConfigException {
        this._pathFormat = pathFormat;
        if (pathFormat.endsWith(".zip")) {
            throw new ConfigException(L.l(".zip extension to path-format is not supported."));
        }
    }

    public void setArchiveFormat(String format) {
        if (format.endsWith(".gz")) {
            this._archiveFormat = format.substring(0, format.length() - ".gz".length());
            this._archiveSuffix = ".gz";
        } else if (format.endsWith(".zip")) {
            this._archiveFormat = format.substring(0, format.length() - ".zip".length());
            this._archiveSuffix = ".zip";
        } else {
            this._archiveFormat = format;
            this._archiveSuffix = "";
        }
    }

    public String getArchiveFormat() {
        if (this._archiveFormat == null) {
            return this._rolloverPrefix + ".%Y%m%d.%H%M";
        }
        return this._archiveFormat;
    }

    public void setRolloverCron(CronType cron) {
        this._rolloverCron = cron;
    }

    public void setRolloverPeriod(Period period) {
        this._rolloverPeriod = period.getPeriod();
        if (this._rolloverPeriod > 0L) {
            this._rolloverPeriod += 3599999L;
            this._rolloverPeriod -= this._rolloverPeriod % 3600000L;
        } else {
            this._rolloverPeriod = 4611686018427387000L;
        }
    }

    public long getRolloverPeriod() {
        return this._rolloverPeriod;
    }

    public void setRolloverSize(Bytes bytes) {
        this.setRolloverSizeBytes(bytes.getBytes());
    }

    public void setRolloverSizeBytes(long size) {
        this._rolloverSize = size < 0L ? 0x3FFFFFFFFFFFFFFFL : size;
    }

    public long getRolloverSize() {
        return this._rolloverSize;
    }

    public void setRolloverCheckPeriod(long period) {
        if (period > 1000L) {
            this._rolloverCheckPeriod = period;
        } else if (period > 0L) {
            this._rolloverCheckPeriod = 1000L;
        }
    }

    public long getRolloverCheckPeriod() {
        return this._rolloverCheckPeriod;
    }

    public void setRolloverCount(int count) {
        this._rolloverCount = count;
    }

    public void setLastTime(long lastTime) {
        this._lastTime = lastTime;
    }

    public void init() throws IOException {
        long now = Alarm.getExactTime();
        Path path = this.getPath();
        if (path != null) {
            path.getParent().mkdirs();
            this._rolloverPrefix = path.getTail();
            long lastModified = path.getLastModified();
            if (lastModified <= 0L || now < lastModified) {
                lastModified = now;
            }
            this._calendar.setGMTTime(lastModified);
            this._nextPeriodEnd = this._rolloverCron != null ? this._rolloverCron.nextTime(lastModified) : Period.periodEnd(lastModified, this.getRolloverPeriod());
        } else {
            this._nextPeriodEnd = this._rolloverCron != null ? this._rolloverCron.nextTime(now) : Period.periodEnd(now, this.getRolloverPeriod());
        }
        if (this._nextPeriodEnd < this._nextRolloverCheckTime && this._nextPeriodEnd > 0L) {
            this._nextRolloverCheckTime = this._nextPeriodEnd;
        }
        if (this._archiveFormat == null && this.getRolloverPeriod() > 0L) {
            this._archiveFormat = this._rolloverCron != null ? this._rolloverPrefix + ".%Y%m%d.%H" : (this.getRolloverPeriod() % 86400000L == 0L ? this._rolloverPrefix + ".%Y%m%d" : (this.getRolloverPeriod() % 3600000L == 0L ? this._rolloverPrefix + ".%Y%m%d.%H" : this._rolloverPrefix + ".%Y%m%d.%H%M"));
        }
        this.rolloverLog();
    }

    public long getNextRolloverCheckTime() {
        if (this._nextPeriodEnd < this._nextRolloverCheckTime) {
            return this._nextPeriodEnd;
        }
        return this._nextRolloverCheckTime;
    }

    public boolean isRollover() {
        long now = Alarm.getCurrentTime();
        return this._nextPeriodEnd <= now || this._nextRolloverCheckTime <= now;
    }

    public boolean rollover() {
        long now = Alarm.getCurrentTime();
        if (this._nextPeriodEnd <= now || this._nextRolloverCheckTime <= now) {
            this.rolloverLog();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(byte[] buffer, int offset, int length) throws IOException {
        Object object = this._logLock;
        synchronized (object) {
            if (this._isRollingOver && 0x4000000L < this._tempStreamSize) {
                try {
                    this._logLock.wait();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!this._isRollingOver) {
                if (this._os == null) {
                    this.openLog();
                }
                if (this._os != null) {
                    this._os.write(buffer, offset, length);
                }
            } else {
                if (this._tempStream == null) {
                    this._tempStream = new TempStream();
                    this._tempStreamSize = 0L;
                }
                this._tempStreamSize += (long)length;
                this._tempStream.write(buffer, offset, length, false);
            }
        }
    }

    protected void flush() throws IOException {
        this.flushStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushStream() throws IOException {
        Object object = this._logLock;
        synchronized (object) {
            if (this._os != null) {
                this._os.flush();
            }
            if (this._zipOut != null) {
                this._zipOut.flush();
            }
        }
    }

    protected void rolloverLog() {
        long now = Alarm.getCurrentTime();
        if (this._nextRolloverCheckTime < now) {
            this._nextRolloverCheckTime = now + this._rolloverCheckPeriod;
            this._rolloverWorker.wake();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rolloverLogImpl() {
        Object object;
        try {
            this._isRollingOver = true;
            Path savedPath = null;
            long lastPeriodEnd = this._nextPeriodEnd;
            long now = Alarm.getCurrentTime();
            this._nextPeriodEnd = this._rolloverCron != null ? this._rolloverCron.nextTime(now) : Period.periodEnd(now, this.getRolloverPeriod());
            Path path = this.getPath();
            Object object2 = this._logLock;
            synchronized (object2) {
                if (lastPeriodEnd < now) {
                    this.closeLogStream();
                    if (this.getPathFormat() == null) {
                        savedPath = this.getArchivePath(lastPeriodEnd - 1L);
                    }
                } else if (path != null && this.getRolloverSize() <= path.getLength()) {
                    this.closeLogStream();
                    if (this.getPathFormat() == null) {
                        savedPath = this.getArchivePath(now);
                    }
                }
                long nextPeriodEnd = this._nextPeriodEnd;
                if (this._nextPeriodEnd < this._nextRolloverCheckTime && this._nextPeriodEnd > 0L) {
                    this._nextRolloverCheckTime = this._nextPeriodEnd;
                }
            }
            if (savedPath != null) {
                this.movePathToArchive(savedPath);
            }
            Object var12_8 = null;
            object = this._logLock;
        }
        catch (Throwable throwable) {
            Object var12_9 = null;
            Object object3 = this._logLock;
            synchronized (object3) {
                this._isRollingOver = false;
                this.flushTempStream();
            }
            throw throwable;
        }
        synchronized (object) {
            this._isRollingOver = false;
            this.flushTempStream();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openLog() {
        Exception exn;
        Path path;
        block16: {
            this.closeLogStream();
            try {
                WriteStream os = this._os;
                this._os = null;
                if (os != null) {
                    os.close();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            path = this.getPath();
            if (path == null) {
                path = this.getPath(Alarm.getCurrentTime());
            }
            Path parent = path.getParent();
            try {
                if (!parent.isDirectory() && parent.mkdirs()) {
                    // empty if block
                }
            }
            catch (Throwable e) {
                this.logWarning(L.l("Can't create log directory {0}.\n  Exception={1}", (Object)parent, e), e);
            }
            exn = null;
            for (int i = 0; i < 3 && this._os == null; ++i) {
                try {
                    this._os = path.openAppend();
                    continue;
                }
                catch (IOException e) {
                    exn = e;
                }
            }
            String pathName = path.getPath();
            try {
                if (pathName.endsWith(".gz")) {
                    this._zipOut = this._os;
                    this._os = Vfs.openWrite(new GZIPOutputStream(this._zipOut));
                } else if (pathName.endsWith(".zip")) {
                    throw new ConfigException("Can't support .zip in path-format");
                }
            }
            catch (Exception e) {
                if (exn != null) break block16;
                exn = e;
            }
        }
        if (exn != null) {
            this.logWarning(L.l("Can't create log for {0}.\n  User={1} Exception={2}", path, System.getProperty("user.name"), exn), exn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void movePathToArchive(Path savedPath) {
        Path path;
        block26: {
            if (savedPath == null) {
                return;
            }
            Object object = this._logLock;
            synchronized (object) {
                this.closeLogStream();
            }
            path = this.getPath();
            String savedName = savedPath.getTail();
            try {
                if (!savedPath.getParent().isDirectory()) {
                    savedPath.getParent().mkdirs();
                }
            }
            catch (Exception e) {
                this.logWarning(L.l("Can't open archive directory {0}", savedPath.getParent()), e);
            }
            try {
                if (!path.exists()) break block26;
                WriteStream os = null;
                DeflaterOutputStream out = null;
                if (savedName.endsWith(".gz")) {
                    os = savedPath.openWrite();
                    out = new GZIPOutputStream(os);
                } else if (savedName.endsWith(".zip")) {
                    os = savedPath.openWrite();
                    out = new ZipOutputStream(os);
                } else {
                    path.renameTo(savedPath);
                }
                if (out == null) break block26;
                try {
                    path.writeToStream(out);
                    Object var7_10 = null;
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        if (out != os) {
                            os.close();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    ((OutputStream)out).close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (out != os) {
                        os.close();
                    }
                }
                catch (Exception e) {}
            }
            catch (Exception e) {
                this.logWarning(L.l("Error rotating logs: {0}", e.toString()), e);
            }
        }
        try {
            path.remove();
        }
        catch (Exception e) {
            this.logWarning(L.l("Error truncating logs"), e);
        }
        if (this._rolloverCount > 0) {
            this.removeOldLogs();
        }
    }

    private void removeOldLogs() {
        try {
            int i;
            Path path = this.getPath();
            Path parent = path.getParent();
            String[] list = parent.list();
            ArrayList<String> matchList = new ArrayList<String>();
            Pattern archiveRegexp = this.getArchiveRegexp();
            for (i = 0; i < list.length; ++i) {
                Matcher matcher = archiveRegexp.matcher(list[i]);
                if (!matcher.matches()) continue;
                matchList.add(list[i]);
            }
            Collections.sort(matchList);
            if (this._rolloverCount <= 0 || matchList.size() < this._rolloverCount) {
                return;
            }
            i = 0;
            while (i + this._rolloverCount < matchList.size()) {
                try {
                    parent.lookup((String)matchList.get(i)).remove();
                }
                catch (Throwable e) {
                    // empty catch block
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Pattern getArchiveRegexp() {
        StringBuilder sb = new StringBuilder();
        String archiveFormat = this.getArchiveFormat();
        block4: for (int i = 0; i < archiveFormat.length(); ++i) {
            char ch = archiveFormat.charAt(i);
            switch (ch) {
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '\\': 
                case '{': 
                case '|': 
                case '}': {
                    sb.append("\\");
                    sb.append(ch);
                    continue block4;
                }
                case '%': {
                    sb.append(".+");
                    ++i;
                    continue block4;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return Pattern.compile(sb.toString());
    }

    protected Path getPath(long time) {
        String formatString = this.getPathFormat();
        if (formatString == null) {
            throw new IllegalStateException(L.l("getPath requires a format path"));
        }
        String pathString = this.getFormatName(formatString, time);
        return this.getPwd().lookup(pathString);
    }

    protected Path getArchivePath(long time) {
        Path path = this.getPath();
        String archiveFormat = this.getArchiveFormat();
        String name = this.getFormatName(archiveFormat + this._archiveSuffix, time);
        Path newPath = path.getParent().lookup(name);
        if (newPath.exists()) {
            if (archiveFormat.indexOf("%H") < 0) {
                archiveFormat = archiveFormat + ".%H%M";
            } else if (archiveFormat.indexOf("%M") < 0) {
                archiveFormat = archiveFormat + ".%M";
            }
            for (int i = 0; i < 100; ++i) {
                String suffix = i == 0 ? this._archiveSuffix : "." + i + this._archiveSuffix;
                name = this.getFormatName(archiveFormat + suffix, time);
                newPath = path.getParent().lookup(name);
                if (!newPath.exists()) break;
            }
        }
        return newPath;
    }

    protected String getFormatName(String format, long time) {
        if (time <= 0L) {
            time = Alarm.getCurrentTime();
        }
        if (format != null) {
            return QDate.formatLocal(time, format);
        }
        if (this._rolloverCron != null) {
            return this._rolloverPrefix + "." + QDate.formatLocal(time, "%Y%m%d.%H");
        }
        if (this.getRolloverPeriod() % 86400000L == 0L) {
            return this._rolloverPrefix + "." + QDate.formatLocal(time, "%Y%m%d");
        }
        return this._rolloverPrefix + "." + QDate.formatLocal(time, "%Y%m%d.%H");
    }

    private void logInfo(String msg) {
        EnvironmentStream.logStderr(msg);
    }

    private void logWarning(String msg, Throwable e) {
        EnvironmentStream.logStderr(msg, e);
    }

    private void logWarning(String msg) {
        EnvironmentStream.logStderr(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this._rolloverWorker.destroy();
        Object object = this._logLock;
        synchronized (object) {
            this.closeLogStream();
        }
    }

    private void closeLogStream() {
        try {
            WriteStream os = this._os;
            this._os = null;
            if (os != null) {
                os.close();
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            WriteStream zipOut = this._zipOut;
            this._zipOut = null;
            if (zipOut != null) {
                zipOut.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushTempStream() {
        TempStream ts = this._tempStream;
        this._tempStream = null;
        this._tempStreamSize = 0L;
        try {
            if (ts != null) {
                if (this._os == null) {
                    this.openLog();
                }
                try {
                    ReadStream is = ts.openRead();
                    try {
                        is.writeToStream(this._os);
                        Object var4_4 = null;
                        is.close();
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        is.close();
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Object var6_7 = null;
            this._logLock.notifyAll();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this._logLock.notifyAll();
            throw throwable;
        }
    }

    class RolloverWorker
    extends TaskWorker {
        RolloverWorker() {
        }

        public long runTask() {
            AbstractRolloverLog.this.rolloverLogImpl();
            return -1L;
        }
    }
}

