/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import com.caucho.config.ConfigException;
import com.caucho.config.types.RawString;
import com.caucho.jmx.Jmx;
import com.caucho.loader.CloseListener;
import com.caucho.loader.Environment;
import com.caucho.log.ELFormatter;
import com.caucho.log.EnvironmentLogger;
import com.caucho.log.LoggerConfig;
import com.caucho.log.RotateLog;
import com.caucho.log.StreamHandler;
import com.caucho.log.SubHandler;
import com.caucho.log.TimestampFilter;
import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.LoggerMXBean;
import com.caucho.util.L10N;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.management.ObjectName;

public class LogConfig
extends RotateLog {
    private static final Logger log = Logger.getLogger(LogConfig.class.getName());
    private static final L10N L = new L10N(LogConfig.class);
    private ArrayList<Handler> _handlers;
    private Formatter _formatter;
    private String _timestamp;
    private ArrayList<SubLogger> _subLoggers = new ArrayList();
    private SubLogger _subLogger;
    private String _mbeanName;
    private boolean _isInit;

    public LogConfig() {
        this.setTimestamp("[%Y/%m/%d %H:%M:%S.%s] ");
    }

    public void setId(String name) {
        if (name.equals("/")) {
            name = "";
        }
        this.setName(name);
    }

    public void setName(String name) {
        this.getSubLogger().setName(name);
    }

    public String getName() {
        return this.getSubLogger().getName();
    }

    public void setMbeanName(String name) {
        this._mbeanName = name;
    }

    public void setUseParentHandlers(boolean useParentHandlers) throws ConfigException {
        this.getSubLogger().setUseParentHandlers(useParentHandlers);
    }

    public void setLevel(String level) throws ConfigException {
        this.getSubLogger().setLevel(level);
        if (this._isInit && this._handlers != null) {
            for (Handler handler : this._handlers) {
                handler.setLevel(this.getSubLogger().getLevel());
            }
        }
    }

    public String getLevel() {
        Level level = this.getSubLogger().getLevel();
        if (level != null) {
            return level.getName();
        }
        return Level.INFO.getName();
    }

    private SubLogger getSubLogger() {
        if (this._subLogger == null) {
            this._subLogger = new SubLogger();
            this._subLoggers.add(this._subLogger);
        }
        return this._subLogger;
    }

    public void setTimestamp(String timestamp) {
        this._timestamp = timestamp;
    }

    public void setFormat(RawString format) {
        if (this._formatter == null) {
            this._formatter = new ELFormatter();
        }
        if (this._formatter instanceof ELFormatter) {
            ((ELFormatter)this._formatter).setFormat(format);
        }
    }

    public String getFormat() {
        if (this._formatter != null && this._formatter instanceof ELFormatter) {
            return ((ELFormatter)this._formatter).getFormat();
        }
        return null;
    }

    public void setFormatter(Formatter formatter) {
        this._formatter = formatter;
    }

    public void addHandler(Handler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        if (this._handlers == null) {
            this._handlers = new ArrayList();
        }
        this._handlers.add(handler);
    }

    public String getTagName() {
        return "log";
    }

    public void addLogger(LoggerConfig logger) {
    }

    @PostConstruct
    public void init() throws ConfigException, IOException {
        this._isInit = true;
        if (this._handlers == null) {
            super.init();
        }
        if (this._subLoggers.size() == 0) {
            this.getSubLogger();
        }
        if (this._subLogger != null) {
            this._subLogger.init();
        }
        if (this._formatter instanceof ELFormatter) {
            ((ELFormatter)this._formatter).init();
        }
        WriteStream os = null;
        if (this._handlers == null) {
            String encoding;
            os = this.getRotateStream().getStream();
            if (this._timestamp != null) {
                TimestampFilter filter = new TimestampFilter();
                filter.setTimestamp(this._timestamp);
                filter.setStream(os);
                filter.setNullDelimited(true);
                os = new WriteStream(filter);
            }
            if ((encoding = System.getProperty("file.encoding")) != null) {
                os.setEncoding(encoding);
            }
            os.setDisableClose(true);
        }
        boolean hasCloseListener = false;
        for (int i = 0; i < this._subLoggers.size(); ++i) {
            SubLogger subLogger = this._subLoggers.get(i);
            Logger logger = subLogger.getLogger();
            Level subLevel = subLogger.getLevel();
            Level level = logger.getLevel();
            if (subLevel != null && (level == null && subLevel.intValue() < Level.INFO.intValue() || level != null && subLevel.intValue() < level.intValue())) {
                logger.setLevel(subLogger.getLevel());
            }
            if (this._handlers == null) {
                StreamHandler handler = new StreamHandler(os);
                handler.setFormatter(this._formatter);
                handler.setNullDelimited(true);
                this._handlers = new ArrayList();
                this._handlers.add(handler);
            }
            for (int j = 0; j < this._handlers.size(); ++j) {
                SubHandler subHandler = new SubHandler(this._handlers.get(j));
                if (subLogger.getLevel() != null) {
                    subHandler.setLevel(subLogger.getLevel());
                }
                if (!(logger instanceof EnvironmentLogger)) {
                    CloseListener listener = new CloseListener(subHandler);
                    Environment.addClassLoaderListener(listener);
                }
                logger.addHandler(subHandler);
            }
        }
        if (this._mbeanName != null) {
            try {
                ObjectName objectName = Jmx.getObjectName(this._mbeanName);
                Jmx.register((Object)new LogAdmin(), objectName, LoggerMXBean.class);
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    static Level toLevel(String level) throws ConfigException {
        if (level.equals("off")) {
            return Level.OFF;
        }
        if (level.equals("severe")) {
            return Level.SEVERE;
        }
        if (level.equals("warning")) {
            return Level.WARNING;
        }
        if (level.equals("info")) {
            return Level.INFO;
        }
        if (level.equals("config")) {
            return Level.CONFIG;
        }
        if (level.equals("fine")) {
            return Level.FINE;
        }
        if (level.equals("finer")) {
            return Level.FINER;
        }
        if (level.equals("finest")) {
            return Level.FINEST;
        }
        if (level.equals("all")) {
            return Level.ALL;
        }
        throw new ConfigException(L.l("`{0}' is an unknown log level.  Log levels are:\noff - disable logging\nsevere - severe errors only\nwarning - warnings\ninfo - information\nconfig - configuration\nfine - fine debugging\nfiner - finer debugging\nfinest - finest debugging\nall - all debugging", level));
    }

    class LogAdmin
    extends AbstractManagedObject
    implements LoggerMXBean {
        LogAdmin() {
        }

        public String getType() {
            return "Logger";
        }

        public String getName() {
            return LogConfig.this.getName();
        }

        public String getLevel() {
            return LogConfig.this.getLevel();
        }

        public void setLevel(String level) {
            if (LogConfig.this._subLogger != null) {
                LogConfig.this._subLogger.setLevel(level);
                LogConfig.this._subLogger.getLogger().setLevel(LogConfig.this._subLogger.getLevel());
            }
            for (int i = 0; i < LogConfig.this._subLoggers.size(); ++i) {
                SubLogger subLogger = (SubLogger)LogConfig.this._subLoggers.get(i);
                subLogger.setLevel(level);
                subLogger.getLogger().setLevel(LogConfig.this._subLogger.getLevel());
            }
        }
    }

    public static class SubLogger {
        private Logger _logger;
        private String _name = "";
        private Level _level;
        private boolean _useParentHandlers = true;
        private Handler _handler;

        public void setId(String name) {
            if (name.equals("/")) {
                name = "";
            }
            this.setName(name);
        }

        public void setName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void setUseParentHandlers(boolean useParentHandlers) throws ConfigException {
            this._logger = Logger.getLogger(this._name);
            this._logger.setUseParentHandlers(useParentHandlers);
            this._useParentHandlers = useParentHandlers;
        }

        public Logger getLogger() {
            return Logger.getLogger(this._name);
        }

        public Level getLevel() {
            return this._level;
        }

        public void setLevel(String level) throws ConfigException {
            if (level.equals("off")) {
                this._level = Level.OFF;
            } else if (level.equals("severe")) {
                this._level = Level.SEVERE;
            } else if (level.equals("warning")) {
                this._level = Level.WARNING;
            } else if (level.equals("info")) {
                this._level = Level.INFO;
            } else if (level.equals("config")) {
                this._level = Level.CONFIG;
            } else if (level.equals("fine")) {
                this._level = Level.FINE;
            } else if (level.equals("finer")) {
                this._level = Level.FINER;
            } else if (level.equals("finest")) {
                this._level = Level.FINEST;
            } else if (level.equals("all")) {
                this._level = Level.ALL;
            } else {
                throw new ConfigException(L.l("`{0}' is an unknown log level.  Log levels are:\noff - disable logging\nsevere - severe errors only\nwarning - warnings\ninfo - information\nconfig - configuration\nfine - fine debugging\nfiner - finer debugging\nfinest - finest debugging\nall - all debugging", level));
            }
        }

        public void setHandler(Handler handler) {
            this._handler = handler;
        }

        public Handler getHandler() {
            return this._handler;
        }

        @PostConstruct
        public void init() throws ConfigException {
            if (this._name == null) {
                throw new ConfigException(L.l("`name' is a required attribute..  Each logger must configure the log name, e.g. com.caucho.server.webapp."));
            }
        }
    }
}

