/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.types.Bytes;
import com.caucho.config.types.Period;
import com.caucho.log.RotateLog;
import com.caucho.log.TimestampFilter;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import javax.annotation.PostConstruct;

@Configurable
public class PathHandler
extends Handler {
    private RotateLog _pathLog = new RotateLog();
    private Formatter _formatter;
    private String _timestamp = "[%Y/%m/%d %H:%M:%S.%s] ";
    private Filter _filter;
    private WriteStream _os;

    public PathHandler() {
    }

    public PathHandler(Path path) {
        this();
        this.setPath(path);
        this.init();
    }

    public PathHandler(String path) {
        this(Vfs.lookup(path));
    }

    public void setPath(Path path) {
        this._pathLog.setPath(path);
    }

    public void setPathFormat(String pathFormat) {
        this._pathLog.setPathFormat(pathFormat);
    }

    public void setArchiveFormat(String archiveFormat) {
        this._pathLog.setArchiveFormat(archiveFormat);
    }

    public void setRolloverPeriod(Period rolloverPeriod) {
        this._pathLog.setRolloverPeriod(rolloverPeriod);
    }

    public void setRolloverSize(Bytes size) {
        this._pathLog.setRolloverSize(size);
    }

    public void setRolloverCount(int count) {
        this._pathLog.setRolloverCount(count);
    }

    public void setTimestamp(String timestamp) {
        this._timestamp = timestamp;
    }

    public void setFormatter(Formatter formatter) {
        this._formatter = formatter;
    }

    public void setFilter(Filter filter) {
        this._filter = filter;
    }

    @PostConstruct
    public void init() throws ConfigException {
        try {
            String encoding;
            this._pathLog.init();
            WriteStream os = this._pathLog.getRotateStream().getStream();
            if (this._timestamp != null) {
                TimestampFilter filter = new TimestampFilter();
                filter.setTimestamp(this._timestamp);
                filter.setStream(os);
                os = new WriteStream(filter);
            }
            if ((encoding = System.getProperty("file.encoding")) != null) {
                os.setEncoding(encoding);
            }
            os.setDisableClose(true);
            this._os = os;
        }
        catch (IOException e) {
            throw ConfigException.create(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        if (this._filter != null && !this._filter.isLoggable(record)) {
            return;
        }
        try {
            if (record == null) {
                WriteStream writeStream = this._os;
                synchronized (writeStream) {
                    this._os.println("no record");
                    this._os.flush();
                }
                return;
            }
            if (this._formatter != null) {
                String value = this._formatter.format(record);
                WriteStream writeStream = this._os;
                synchronized (writeStream) {
                    this._os.println(value);
                    this._os.flush();
                }
                return;
            }
            String message = record.getMessage();
            Throwable thrown = record.getThrown();
            WriteStream writeStream = this._os;
            synchronized (writeStream) {
                if (thrown != null) {
                    if (message != null && !message.equals(thrown.toString()) && !message.equals(thrown.getMessage())) {
                        this._os.println(message);
                    }
                    record.getThrown().printStackTrace(this._os.getPrintWriter());
                } else {
                    this._os.println(record.getMessage());
                }
                this._os.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void flush() {
    }

    public void close() {
    }

    public int hashCode() {
        if (this._os == null || this._os.getPath() == null) {
            return super.hashCode();
        }
        return this._os.getPath().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        PathHandler handler = (PathHandler)o;
        if (this._os == null || handler._os == null) {
            return false;
        }
        return this._os.getPath().equals(handler._os.getPath());
    }

    public String toString() {
        if (this._os == null) {
            return this.getClass().getSimpleName() + "[" + this._pathLog + "]";
        }
        return this.getClass().getSimpleName() + "[" + this._os.getPath() + "]";
    }
}

