/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import com.caucho.util.L10N;
import com.caucho.vfs.WriteStream;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class StreamHandler
extends Handler {
    private static final L10N L = new L10N(StreamHandler.class);
    private WriteStream _os;
    private Formatter _formatter;
    private String _timestamp;
    private boolean _isNullDelimited;

    public StreamHandler() {
    }

    public StreamHandler(WriteStream os) {
        this._os = os;
    }

    public void setTimestamp(String timestamp) {
        this._timestamp = timestamp;
    }

    public void setFormatter(Formatter formatter) {
        this._formatter = formatter;
    }

    public void setNullDelimited(boolean isNullDelimited) {
        this._isNullDelimited = isNullDelimited;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        try {
            if (record == null) {
                WriteStream writeStream = this._os;
                synchronized (writeStream) {
                    this._os.println("no record");
                    if (this._isNullDelimited) {
                        this._os.write(0);
                    }
                    this._os.flush();
                }
                return;
            }
            if (this._formatter != null) {
                String value = this._formatter.format(record);
                WriteStream writeStream = this._os;
                synchronized (writeStream) {
                    this._os.println(value);
                    if (this._isNullDelimited) {
                        this._os.write(0);
                    }
                    this._os.flush();
                }
                return;
            }
            String message = record.getMessage();
            Throwable thrown = record.getThrown();
            WriteStream writeStream = this._os;
            synchronized (writeStream) {
                if (this._timestamp != null) {
                    this._os.print(this._timestamp);
                }
                if (thrown != null) {
                    if (message != null && !message.equals(thrown.toString()) && !message.equals(thrown.getMessage())) {
                        this._os.println(message);
                    }
                    record.getThrown().printStackTrace(this._os.getPrintWriter());
                } else {
                    this._os.println(record.getMessage());
                }
                if (this._isNullDelimited) {
                    this._os.write(0);
                }
                this._os.flush();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void flush() {
    }

    public void close() {
    }

    public int hashCode() {
        if (this._os == null || this._os.getPath() == null) {
            return super.hashCode();
        }
        return this._os.getPath().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        StreamHandler handler = (StreamHandler)o;
        if (this._os == null || handler._os == null) {
            return false;
        }
        return this._os.getPath().equals(handler._os.getPath());
    }

    public String toString() {
        if (this._os == null) {
            return "StreamHandler@" + System.identityHashCode(this) + "[]";
        }
        return "StreamHandler@" + System.identityHashCode(this) + "[" + this._os.getPath() + "]";
    }
}

