/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.management.server;

import com.caucho.management.server.AbstractManagedObject;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

public abstract class AbstractEmitterObject
extends AbstractManagedObject
implements NotificationEmitter {
    private static final Logger log = Logger.getLogger(AbstractEmitterObject.class.getName());
    private ArrayList<Listener> _listeners;
    private Listener[] _listenerArray;

    protected AbstractEmitterObject() {
    }

    protected AbstractEmitterObject(ClassLoader loader) {
        super(loader);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        ArrayList<Listener> arrayList = this._listeners;
        synchronized (arrayList) {
            this._listeners.add(new Listener(listener, filter, handback));
            this._listenerArray = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(NotificationListener listener) {
        if (this._listeners != null) {
            ArrayList<Listener> arrayList = this._listeners;
            synchronized (arrayList) {
                for (int i = this._listeners.size() - 1; i >= 0; --i) {
                    Listener item = this._listeners.get(i);
                    if (item.getListener() != listener) continue;
                    this._listeners.remove(i);
                }
                this._listenerArray = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        if (this._listeners != null) {
            ArrayList<Listener> arrayList = this._listeners;
            synchronized (arrayList) {
                for (int i = this._listeners.size() - 1; i >= 0; --i) {
                    Listener item = this._listeners.get(i);
                    if (item.getListener() != listener || item.getFilter() != filter || item.getHandback() != handback) continue;
                    this._listeners.remove(i);
                }
                this._listenerArray = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleNotification(Notification notification) {
        Object listeners = null;
        if (this._listeners != null) {
            ArrayList<Listener> arrayList = this._listeners;
            synchronized (arrayList) {
                if (this._listenerArray == null && this._listeners.size() > 0) {
                    this._listenerArray = new Listener[this._listeners.size()];
                    this._listeners.toArray(this._listenerArray);
                }
            }
        }
        if (listeners != null) {
            for (int i = 0; i < (listeners).length; ++i) {
                listeners[i].handleNotification(notification);
            }
        }
    }

    static class Listener {
        private final NotificationListener _listener;
        private final NotificationFilter _filter;
        private final Object _handback;

        Listener(NotificationListener listener, NotificationFilter filter, Object handback) {
            this._listener = listener;
            this._filter = filter;
            this._handback = handback;
        }

        NotificationListener getListener() {
            return this._listener;
        }

        NotificationFilter getFilter() {
            return this._filter;
        }

        Object getHandback() {
            return this._handback;
        }

        void handleNotification(Notification notification) {
            if (this._filter == null || this._filter.isNotificationEnabled(notification)) {
                this._listener.handleNotification(notification, this._handback);
            }
        }
    }
}

