/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.management.server;

import com.caucho.management.server.AbstractManagedObject;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

public abstract class AbstractNotificationObject
extends AbstractManagedObject
implements NotificationEmitter {
    private static final Logger log = Logger.getLogger(AbstractNotificationObject.class.getName());
    private ArrayList<Notif> _notifList = new ArrayList();

    protected AbstractNotificationObject() {
    }

    protected AbstractNotificationObject(ClassLoader loader) {
        super(loader);
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this._notifList.add(new Notif(listener, filter, handback));
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        boolean isMatch = false;
        for (int i = this._notifList.size() - 1; i >= 0; --i) {
            Notif notif = this._notifList.get(i);
            if (listener != notif.getListener()) continue;
            isMatch = true;
            this._notifList.remove(i);
        }
        if (!isMatch) {
            throw new ListenerNotFoundException(String.valueOf(listener));
        }
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        boolean isMatch = false;
        for (int i = this._notifList.size() - 1; i >= 0; --i) {
            Notif notif = this._notifList.get(i);
            if (listener != notif.getListener() || filter != notif.getFilter() || handback != notif.getHandback()) continue;
            isMatch = true;
            this._notifList.remove(i);
        }
        if (!isMatch) {
            throw new ListenerNotFoundException(String.valueOf(listener));
        }
    }

    protected void handleNotification(NotificationListener listener, Notification notif, Object handback) {
        listener.handleNotification(notif, handback);
    }

    public void sendNotification(Notification notification) {
        for (int i = 0; i < this._notifList.size(); ++i) {
            Notif notif = this._notifList.get(i);
            if (notif.getFilter() != null && !notif.getFilter().isNotificationEnabled(notification)) continue;
            this.handleNotification(notif.getListener(), notification, notif.getHandback());
        }
    }

    static class Notif {
        private final NotificationListener _listener;
        private final NotificationFilter _filter;
        private final Object _handback;

        Notif(NotificationListener listener, NotificationFilter filter, Object handback) {
            this._listener = listener;
            this._filter = filter;
            this._handback = handback;
        }

        NotificationListener getListener() {
            return this._listener;
        }

        NotificationFilter getFilter() {
            return this._filter;
        }

        Object getHandback() {
            return this._handback;
        }
    }
}

