/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.management.server;

import com.caucho.jmx.Description;
import com.caucho.jmx.Units;
import com.caucho.management.server.ClusterMXBean;
import com.caucho.management.server.ClusterServerMXBean;
import com.caucho.management.server.EnvironmentMXBean;
import com.caucho.management.server.ManagedObjectMXBean;
import com.caucho.management.server.PortMXBean;
import com.caucho.management.server.TcpConnectionMXBean;
import com.caucho.management.server.ThreadPoolMXBean;
import java.util.Date;

@Description(value="The Resin Server running on this JVM instance")
public interface ServerMXBean
extends ManagedObjectMXBean {
    @Description(value="The server id used when starting this instance of Resin, the value of '-server'")
    public String getId();

    @Description(value="The server index in the cluster triad")
    public int getServerIndex();

    @Description(value="The ClusterServer for this server")
    public ClusterServerMXBean getSelfServer();

    @Description(value="The cluster contains the peer servers")
    public ClusterMXBean getCluster();

    @Description(value="Ports accept socket connections")
    public PortMXBean[] getPorts();

    @Description(value="The thread pool for the server")
    public ThreadPoolMXBean getThreadPool();

    @Description(value="The cluster port handles management and cluster messages")
    public PortMXBean getClusterPort();

    @Description(value="The environment is a classloader and its resources")
    public EnvironmentMXBean getEnvironment();

    @Description(value="Ports may be bound after startup completes")
    public boolean isBindPortsAfterStart();

    @Description(value="Detailed statistics causes various parts of Resin to keep more detailed statistics at the possible expense of some performance")
    public boolean isDetailedStatistics();

    @Description(value="Detailed error pages for development")
    public boolean isDevelopmentModeErrorPage();

    @Description(value="The minimum free heap memory for GC and restart")
    public long getMemoryFreeMin();

    @Description(value="The perm-gen free heap memory for GC and restart")
    public long getPermGenFreeMin();

    @Description(value="The maximum time to spend waiting for the server to stop gracefully")
    public long getShutdownWaitMax();

    @Description(value="A SelectManager handles keepalive without requiring a thread")
    public boolean isSelectManagerEnabled();

    @Description(value="The HTTP Server: header")
    public String getServerHeader();

    @Description(value="The deployment repository stage")
    public String getStage();

    @Description(value="The HTTP maximum URL length")
    public int getUrlLengthMax();

    @Description(value="The current lifecycle state")
    public String getState();

    @Description(value="The current time")
    public Date getCurrentTime();

    @Description(value="The time that this instance was last started or restarted")
    public Date getStartTime();

    @Description(value="The time in milliseconds since the last start")
    public long getUptime();

    @Description(value="The current number of threads that are servicing requests")
    public int getThreadActiveCount();

    @Description(value="The current number of connections that are in the keepalive state and are using a thread to maintain the connection")
    public int getThreadKeepaliveCount();

    @Description(value="The current number of connections that are in the keepalive state and are using select to maintain the connection")
    public int getSelectKeepaliveCount();

    @Description(value="The total number of requests serviced by the server since it started")
    public long getRequestCountTotal();

    @Description(value="The total number of requests that have ended up in the keepalive state")
    public long getKeepaliveCountTotal();

    @Description(value="The total number of connections that have terminated with a client disconnect")
    public long getClientDisconnectCountTotal();

    @Description(value="The total duration in milliseconds that requests serviced by this service have taken")
    @Units(value="milliseconds")
    public long getRequestTimeTotal();

    @Description(value="The total number of bytes that requests serviced by this server have read")
    @Units(value="bytes")
    public long getRequestReadBytesTotal();

    @Description(value="The total number of bytes that requests serviced by this server have written")
    @Units(value="bytes")
    public long getRequestWriteBytesTotal();

    @Description(value="The invocation cache is an internal cache used by Resin to optimize the handling of urls")
    public long getInvocationCacheHitCountTotal();

    @Description(value="The invocation cache is an internal cache used by Resin to optimize the handling of urls")
    public long getInvocationCacheMissCountTotal();

    @Description(value="The current total amount of memory available for the JVM, in bytes")
    @Units(value="bytes")
    public long getRuntimeMemory();

    @Description(value="The current free amount of memory available for the JVM, in bytes")
    @Units(value="bytes")
    public long getRuntimeMemoryFree();

    @Description(value="The current CPU load average")
    public double getCpuLoadAvg();

    @Description(value="Exit this instance cleanly and allow the watchdog to start a new JVM")
    public void restart();

    @Description(value="Finds the ConnectionMXBean for a given thread id")
    public TcpConnectionMXBean findConnectionByThreadId(long var1);
}

