/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.network.listen;

import com.caucho.network.listen.AsyncController;
import com.caucho.network.listen.CometHandler;
import com.caucho.network.listen.SocketLink;
import com.caucho.network.listen.SocketLinkState;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.net.InetAddress;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public abstract class AbstractSocketLink
implements SocketLink {
    private final ReadStream _readStream = new ReadStream();
    private final WriteStream _writeStream;

    public AbstractSocketLink() {
        this._readStream.setReuseBuffer(true);
        this._writeStream = new WriteStream();
        this._writeStream.setReuseBuffer(true);
    }

    public abstract int getId();

    public final ReadStream getReadStream() {
        return this._readStream;
    }

    public final WriteStream getWriteStream() {
        return this._writeStream;
    }

    public boolean isSecure() {
        return false;
    }

    public String getVirtualHost() {
        return null;
    }

    public abstract InetAddress getLocalAddress();

    public String getLocalHost() {
        InetAddress localAddress = this.getLocalAddress();
        if (localAddress != null) {
            return localAddress.getHostAddress();
        }
        return null;
    }

    public abstract int getLocalPort();

    public abstract InetAddress getRemoteAddress();

    public String getRemoteHost() {
        InetAddress remoteAddress = this.getRemoteAddress();
        if (remoteAddress != null) {
            return remoteAddress.getHostAddress();
        }
        return null;
    }

    public int getRemoteAddress(byte[] buffer, int offset, int length) {
        InetAddress remote = this.getRemoteAddress();
        String name = remote.getHostAddress();
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            buffer[offset + i] = (byte)name.charAt(i);
        }
        return len;
    }

    public abstract int getRemotePort();

    public String getCipherSuite() {
        return null;
    }

    public int getKeySize() {
        return 0;
    }

    public X509Certificate[] getClientCertificates() throws CertificateException {
        return null;
    }

    public boolean isKeepaliveAllocated() {
        return false;
    }

    public void killKeepalive() {
    }

    public void requestShutdownBegin() {
    }

    public void requestShutdownEnd() {
    }

    public SocketLinkState getState() {
        return SocketLinkState.REQUEST_ACTIVE_KA;
    }

    public boolean isCometActive() {
        return false;
    }

    public boolean isCometSuspend() {
        return false;
    }

    public boolean isCometComplete() {
        return false;
    }

    public boolean isDuplex() {
        return false;
    }

    public boolean wake() {
        return false;
    }

    public AsyncController toComet(CometHandler cometHandler) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }
}

