/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.protocols.flash;

import com.caucho.config.ConfigException;
import com.caucho.network.listen.ProtocolConnection;
import com.caucho.network.listen.SocketLink;
import com.caucho.protocols.flash.SocketPolicyRequest;
import com.caucho.server.http.AbstractHttpProtocol;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import javax.annotation.PostConstruct;

public class SocketPolicyProtocol
extends AbstractHttpProtocol {
    private static final L10N L = new L10N(SocketPolicyRequest.class);
    private Path _policy;

    public SocketPolicyProtocol() {
        this.setProtocolName("http");
    }

    public void setSocketPolicyFile(Path path) {
        this.setPolicyFile(path);
    }

    public void setPolicyFile(Path path) {
        this._policy = path;
    }

    @PostConstruct
    public void init() {
        if (this._policy == null) {
            throw new ConfigException(L.l("flash requires a policy-file"));
        }
    }

    public ProtocolConnection createConnection(SocketLink conn) {
        return new SocketPolicyRequest(this.getServer(), conn, this._policy);
    }
}

