/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus;

import java.util.concurrent.locks.LockSupport;
import java.util.logging.Logger;

public class QuercusTimer {
    private static final Logger log = Logger.getLogger(QuercusTimer.class.getName());
    private TimerThread _timerThread;
    private volatile long _currentTime = System.currentTimeMillis();
    private volatile boolean _isCurrentTimeUsed;
    private volatile boolean _isSlowTime;
    private volatile boolean _isRunnable = true;

    public QuercusTimer() {
        TimerThread timerThread = null;
        try {
            timerThread = new TimerThread();
            timerThread.start();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this._timerThread = timerThread;
    }

    public long getCurrentTime() {
        if (!this._isCurrentTimeUsed) {
            if (this._timerThread == null) {
                return System.currentTimeMillis();
            }
            if (this._isSlowTime) {
                return System.currentTimeMillis();
            }
            this._isCurrentTimeUsed = true;
        }
        return this._currentTime;
    }

    public long getExactTime() {
        return System.currentTimeMillis();
    }

    public long getExactTimeNanoseconds() {
        return System.nanoTime();
    }

    public void shutdown() {
        this._isRunnable = false;
    }

    class TimerThread
    extends Thread {
        TimerThread() {
            super("quercus-timer");
            this.setDaemon(true);
            this.setPriority(10);
        }

        public void run() {
            int idleCount = 0;
            while (QuercusTimer.this._isRunnable) {
                try {
                    long now = System.currentTimeMillis();
                    QuercusTimer.this._currentTime = now;
                    boolean isCurrentTimeUsed = QuercusTimer.this._isCurrentTimeUsed;
                    QuercusTimer.this._isCurrentTimeUsed = false;
                    if (isCurrentTimeUsed) {
                        QuercusTimer.this._isSlowTime = false;
                    } else if (++idleCount == 10) {
                        QuercusTimer.this._isSlowTime = true;
                    }
                    long sleepTime = QuercusTimer.this._isSlowTime ? 1000L : 5L;
                    LockSupport.parkNanos(sleepTime * 1000000L);
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

