/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.Callable;
import com.caucho.quercus.env.Callback;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.MethodIntern;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.program.Arg;
import com.caucho.quercus.program.Function;

public class Closure
extends Callback {
    private static final Value[] NULL_ARGS = new Value[0];
    private static final StringValue INVOKE = MethodIntern.intern("__invoke");
    private Function _fun;
    private Value[] _args;

    public Closure(Env env, Function fun) {
        this._fun = fun;
        Arg[] args = fun.getClosureUseArgs();
        if (args != null && args.length > 0) {
            this._args = new Value[args.length];
            for (int i = 0; i < args.length; ++i) {
                Arg arg = args[i];
                this._args[i] = arg.isReference() ? env.getRef(arg.getName()) : env.getValue(arg.getName());
            }
        }
    }

    public boolean isCallable(Env env, boolean isSyntax) {
        return true;
    }

    public Callable toCallable(Env env) {
        return this;
    }

    public boolean isObject() {
        return true;
    }

    public String getType() {
        return "object";
    }

    public Value call(Env env, Value[] args) {
        return this._fun.callImpl(env, args, false, this._fun.getClosureUseArgs(), this._args);
    }

    public String getCallbackName() {
        return this._fun.getName();
    }

    public boolean isInternal(Env env) {
        return false;
    }

    public boolean isValid(Env env) {
        return true;
    }

    public Value callMethod(Env env, StringValue methodName, int hash, Value[] args) {
        if (methodName == INVOKE || INVOKE.equals(methodName)) {
            return this.call(env, args);
        }
        return super.callMethod(env, methodName, hash, args);
    }

    public String toString() {
        return "Closure[" + this._fun.getName() + "]";
    }
}

