/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.ConstStringValue;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.ValueType;

public final class CompiledConstStringValue
extends ConstStringValue {
    private final int _compiledHashCode;

    public CompiledConstStringValue(StringValue s) {
        super(s);
        this._longValue = s.toLongValue();
        this._doubleValue = s.toDoubleValue();
        this._string = s.toString();
        this._valueType = s.getValueType();
        this._compiledHashCode = s.hashCode();
        this._key = s.toKey();
    }

    public CompiledConstStringValue(String s) {
        super(s);
        this._longValue = super.toLongValue();
        this._doubleValue = super.toDoubleValue();
        this._string = s;
        this._valueType = super.getValueType();
        this._compiledHashCode = super.hashCode();
        this._key = super.toKey();
    }

    public CompiledConstStringValue(char ch, LongValue longValue, DoubleValue doubleValue, ValueType valueType, Value key, int hashCode) {
        super(ch);
        this._string = String.valueOf(ch);
        this._longValue = longValue;
        this._doubleValue = doubleValue;
        this._valueType = valueType;
        this._key = key;
        this._compiledHashCode = hashCode;
    }

    public CompiledConstStringValue(char ch, LongValue longValue, DoubleValue doubleValue, ValueType valueType, int hashCode) {
        super(ch);
        this._string = String.valueOf(ch);
        this._longValue = longValue;
        this._doubleValue = doubleValue;
        this._valueType = valueType;
        this._key = super.toKey();
        this._compiledHashCode = hashCode;
    }

    public CompiledConstStringValue(String s, LongValue longValue, DoubleValue doubleValue, ValueType valueType, Value key, int hashCode) {
        super(s);
        this._string = s;
        this._longValue = longValue;
        this._doubleValue = doubleValue;
        this._valueType = valueType;
        this._key = key;
        this._compiledHashCode = hashCode;
    }

    public CompiledConstStringValue(String s, LongValue longValue, DoubleValue doubleValue, ValueType valueType, int hashCode) {
        super(s);
        this._string = s;
        this._longValue = longValue;
        this._doubleValue = doubleValue;
        this._valueType = valueType;
        this._key = super.toKey();
        this._compiledHashCode = hashCode;
    }

    public boolean isStatic() {
        return true;
    }

    public LongValue toLongValue() {
        return this._longValue;
    }

    public DoubleValue toDoubleValue() {
        return this._doubleValue;
    }

    public long toLong() {
        return this.toLongValue().toLong();
    }

    public double toDouble() {
        return this.toDoubleValue().toDouble();
    }

    public ValueType getValueType() {
        return this._valueType;
    }

    public final Value toKey() {
        return this._key;
    }

    public final int hashCode() {
        return this._compiledHashCode;
    }

    public final String toString() {
        return this._string;
    }
}

