/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.AbstractJavaMethod;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.util.L10N;

public class JavaOverloadMethod
extends AbstractJavaMethod {
    private static final L10N L = new L10N(JavaOverloadMethod.class);
    private AbstractJavaMethod[][] _methodTable = new AbstractJavaMethod[0][];
    private AbstractJavaMethod[][] _restMethodTable = new AbstractJavaMethod[0][];

    public JavaOverloadMethod(AbstractJavaMethod fun) {
        this.overload(fun);
    }

    public int getMaxArgLength() {
        throw new UnsupportedOperationException();
    }

    public int getMinArgLength() {
        throw new UnsupportedOperationException();
    }

    public boolean getHasRestArgs() {
        throw new UnsupportedOperationException();
    }

    public AbstractJavaMethod overload(AbstractJavaMethod fun) {
        if (fun.getHasRestArgs()) {
            AbstractJavaMethod[] methods;
            int len = fun.getMinArgLength();
            if (this._restMethodTable.length <= len) {
                AbstractJavaMethod[][] restMethodTable = new AbstractJavaMethod[len + 1][];
                System.arraycopy(this._restMethodTable, 0, restMethodTable, 0, this._restMethodTable.length);
                this._restMethodTable = restMethodTable;
            }
            if ((methods = this._restMethodTable[len]) == null) {
                this._restMethodTable[len] = new AbstractJavaMethod[]{fun};
            } else {
                AbstractJavaMethod[] newMethods = new AbstractJavaMethod[methods.length + 1];
                System.arraycopy(methods, 0, newMethods, 0, methods.length);
                newMethods[methods.length] = fun;
                this._restMethodTable[len] = newMethods;
            }
        } else {
            int maxLen = fun.getMaxArgLength();
            if (this._methodTable.length <= maxLen) {
                AbstractJavaMethod[][] methodTable = new AbstractJavaMethod[maxLen + 1][];
                System.arraycopy(this._methodTable, 0, methodTable, 0, this._methodTable.length);
                this._methodTable = methodTable;
            }
            for (int len = fun.getMinArgLength(); len <= maxLen; ++len) {
                AbstractJavaMethod[] methods = this._methodTable[len];
                if (methods == null) {
                    this._methodTable[len] = new AbstractJavaMethod[]{fun};
                    continue;
                }
                AbstractJavaMethod[] newMethods = new AbstractJavaMethod[methods.length + 1];
                System.arraycopy(methods, 0, newMethods, 0, methods.length);
                newMethods[methods.length] = fun;
                this._methodTable[len] = newMethods;
            }
        }
        return this;
    }

    public AbstractFunction getActualFunction(Expr[] args) {
        if (args.length <= this._methodTable.length) {
            AbstractJavaMethod[] methods = this._methodTable[args.length];
            if (methods != null) {
                if (methods.length == 1) {
                    return methods[0];
                }
                return this.getBestFitJavaMethod(methods, this._restMethodTable, args);
            }
            if (this._restMethodTable.length == 0) {
                return this;
            }
            return this.getBestFitJavaMethod(methods, this._restMethodTable, args);
        }
        if (this._restMethodTable.length == 0) {
            return this;
        }
        return this.getBestFitJavaMethod(null, this._restMethodTable, args);
    }

    public Value callMethod(Env env, QuercusClass qClass, Value qThis, Value[] args) {
        if (args.length < this._methodTable.length) {
            AbstractJavaMethod[] methods = this._methodTable[args.length];
            if (methods != null) {
                if (methods.length == 1) {
                    return methods[0].callMethod(env, qClass, qThis, args);
                }
                AbstractJavaMethod method = this.getBestFitJavaMethod(methods, this._restMethodTable, args);
                return method.callMethod(env, qClass, qThis, args);
            }
            if (this._restMethodTable.length == 0) {
                env.warning(L.l("'{0}' overloaded method call with {1} arguments does not match any overloaded method", (Object)this.getName(), args.length));
                return NullValue.NULL;
            }
            AbstractJavaMethod method = this.getBestFitJavaMethod(methods, this._restMethodTable, args);
            return method.callMethod(env, qClass, qThis, args);
        }
        if (this._restMethodTable.length == 0) {
            env.warning(L.l("'{0}' overloaded method call with {1} arguments has too many arguments", (Object)this.getName(), args.length));
            return NullValue.NULL;
        }
        AbstractJavaMethod method = this.getBestFitJavaMethod(null, this._restMethodTable, args);
        return method.callMethod(env, qClass, qThis, args);
    }

    private AbstractJavaMethod getBestFitJavaMethod(AbstractJavaMethod[] methods, AbstractJavaMethod[][] restMethodTable, Value[] args) {
        int i;
        AbstractJavaMethod minCostJavaMethod = null;
        int minCost = Integer.MAX_VALUE;
        if (methods != null) {
            for (i = 0; i < methods.length; ++i) {
                AbstractJavaMethod javaMethod = methods[i];
                int cost = javaMethod.getMarshalingCost(args);
                if (cost == 0) {
                    return javaMethod;
                }
                if (cost > minCost) continue;
                minCost = cost;
                minCostJavaMethod = javaMethod;
            }
        }
        for (i = Math.min(args.length, restMethodTable.length) - 1; i >= 0; --i) {
            if (restMethodTable[i] == null) continue;
            for (int j = 0; j < restMethodTable[i].length; ++j) {
                AbstractJavaMethod javaMethod = restMethodTable[i][j];
                int cost = javaMethod.getMarshalingCost(args);
                if (cost == 0) {
                    return javaMethod;
                }
                if (cost > minCost) continue;
                minCost = cost;
                minCostJavaMethod = javaMethod;
            }
        }
        return minCostJavaMethod;
    }

    private AbstractJavaMethod getBestFitJavaMethod(AbstractJavaMethod[] methods, AbstractJavaMethod[][] restMethodTable, Expr[] args) {
        int i;
        AbstractJavaMethod minCostJavaMethod = null;
        int minCost = Integer.MAX_VALUE;
        if (methods != null) {
            for (i = 0; i < methods.length; ++i) {
                AbstractJavaMethod javaMethod = methods[i];
                int cost = javaMethod.getMarshalingCost(args);
                if (cost == 0) {
                    return javaMethod;
                }
                if (cost > minCost) continue;
                minCost = cost;
                minCostJavaMethod = javaMethod;
            }
        }
        for (i = Math.min(args.length, restMethodTable.length) - 1; i >= 0; --i) {
            if (restMethodTable[i] == null) continue;
            for (int j = 0; j < restMethodTable[i].length; ++j) {
                AbstractJavaMethod javaMethod = restMethodTable[i][j];
                int cost = javaMethod.getMarshalingCost(args);
                if (cost == 0) {
                    return javaMethod;
                }
                if (cost > minCost) continue;
                minCost = cost;
                minCostJavaMethod = javaMethod;
            }
        }
        return minCostJavaMethod;
    }

    public int getMarshalingCost(Value[] args) {
        AbstractJavaMethod[] methods = null;
        if (args.length < this._methodTable.length) {
            methods = this._methodTable[args.length];
        }
        AbstractJavaMethod bestFitMethod = this.getBestFitJavaMethod(methods, this._restMethodTable, args);
        return bestFitMethod.getMarshalingCost(args);
    }

    public int getMarshalingCost(Expr[] args) {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        for (int i = 0; i < this._methodTable.length; ++i) {
            if (this._methodTable[i] == null) continue;
            return this._methodTable[i][0].getName();
        }
        return "unknown";
    }

    public String toString() {
        return "JavaOverloadMethod[" + this.getName() + "]";
    }
}

