/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.ArgGetFieldValue;
import com.caucho.quercus.env.ArgRef;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BinaryBuilderValue;
import com.caucho.quercus.env.CopyObjectExtValue;
import com.caucho.quercus.env.CopyRoot;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.FieldVisibility;
import com.caucho.quercus.env.LargeStringBuilderValue;
import com.caucho.quercus.env.MethodMap;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.SerializeMap;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.TraversableDelegate;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.util.Alarm;
import com.caucho.util.Primes;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectExtValue
extends ObjectValue
implements Serializable {
    private static final int DEFAULT_SIZE = 16;
    private static final int DEFAULT_PRIME = Primes.getBiggestPrime(16);
    private MethodMap<AbstractFunction> _methodMap;
    private Entry[] _entries;
    private int _prime;
    private int _size;
    private boolean _isFieldInit;

    public ObjectExtValue(QuercusClass cl) {
        super(cl);
        this._methodMap = cl.getMethodMap();
        this._entries = new Entry[16];
        this._prime = DEFAULT_PRIME;
    }

    public ObjectExtValue(Env env, ObjectExtValue copy, CopyRoot root) {
        super(copy.getQuercusClass());
        root.putCopy(copy, this);
        this._methodMap = copy._methodMap;
        this._size = copy._size;
        this._isFieldInit = copy._isFieldInit;
        Entry[] copyEntries = copy._entries;
        this._entries = new Entry[copyEntries.length];
        this._prime = copy._prime;
        int len = copyEntries.length;
        for (int i = 0; i < len; ++i) {
            Entry entry = copyEntries[i];
            while (entry != null) {
                Entry entryCopy = entry.copyTree(env, root);
                entryCopy._next = this._entries[i];
                if (this._entries[i] != null) {
                    this._entries[i]._prev = entryCopy;
                }
                this._entries[i] = entryCopy;
                entry = entry._next;
            }
        }
        this._incompleteObjectName = copy._incompleteObjectName;
    }

    public ObjectExtValue(Env env, IdentityHashMap<Value, Value> copyMap, ObjectExtValue copy) {
        super(copy.getQuercusClass());
        this._methodMap = copy._methodMap;
        this._size = copy._size;
        this._isFieldInit = copy._isFieldInit;
        Entry[] copyEntries = copy._entries;
        this._entries = new Entry[copyEntries.length];
        this._prime = copy._prime;
        int len = copyEntries.length;
        for (int i = 0; i < len; ++i) {
            Entry entry = copyEntries[i];
            while (entry != null) {
                Entry entryCopy = new Entry(env, copyMap, entry);
                entryCopy._next = this._entries[i];
                if (this._entries[i] != null) {
                    this._entries[i]._prev = entryCopy;
                }
                this._entries[i] = entryCopy;
                entry = entry._next;
            }
        }
        this._incompleteObjectName = copy._incompleteObjectName;
    }

    private void init() {
        this._entries = new Entry[16];
        this._prime = DEFAULT_PRIME;
        this._size = 0;
    }

    @Override
    protected void setQuercusClass(QuercusClass cl) {
        super.setQuercusClass(cl);
        this._methodMap = cl.getMethodMap();
    }

    @Override
    public void initObject(Env env, QuercusClass cls) {
        this.setQuercusClass(cls);
        this._incompleteObjectName = null;
        Entry[] existingEntries = this._entries;
        this._entries = new Entry[16];
        this._prime = DEFAULT_PRIME;
        this._size = 0;
        cls.initObject(env, this);
        EntryIterator iter = new EntryIterator(existingEntries);
        while (iter.hasNext()) {
            Entry newField = iter.next();
            Entry entry = this.getThisEntry(newField._key);
            if (entry != null) {
                entry._value = newField._value;
                continue;
            }
            this.initField(newField._key, newField._value, newField._visibility);
        }
    }

    @Override
    public int getSize() {
        return this._size;
    }

    @Override
    public final Value getField(Env env, StringValue name) {
        int hash = (name.hashCode() & Integer.MAX_VALUE) % this._prime;
        Entry entry = this._entries[hash];
        while (entry != null) {
            StringValue entryKey = entry._key;
            if (name == entryKey || name.equals(entryKey)) {
                return entry._value.toValue();
            }
            entry = entry._next;
        }
        return this.getFieldExt(env, name);
    }

    @Override
    public Value getThisField(Env env, StringValue name) {
        Entry entry = this.getThisEntry(name);
        if (entry != null) {
            return entry._value.toValue();
        }
        return this.getFieldExt(env, name);
    }

    protected Value getFieldExt(Env env, StringValue name) {
        return this._quercusClass.getField(env, this, name);
    }

    @Override
    public Var getFieldVar(Env env, StringValue name) {
        Entry entry = this.getEntry(env, name);
        if (entry != null) {
            Value value = entry._value;
            if (value instanceof Var) {
                return (Var)value;
            }
            Var var = new Var(value);
            entry._value = var;
            return var;
        }
        Value value = this.getFieldExt(env, name);
        if (value != UnsetValue.UNSET) {
            if (value instanceof Var) {
                return (Var)value;
            }
            return new Var(value);
        }
        entry = this.createEntry(name, FieldVisibility.PUBLIC);
        value = entry._value;
        if (value instanceof Var) {
            return (Var)value;
        }
        Var var = new Var(value);
        entry.setValue(var);
        return var;
    }

    @Override
    public Var getThisFieldVar(Env env, StringValue name) {
        Entry entry = this.getThisEntry(name);
        if (entry != null) {
            Value value = entry._value;
            if (value instanceof Var) {
                return (Var)value;
            }
            Var var = new Var(value);
            entry._value = var;
            return var;
        }
        Value value = this.getFieldExt(env, name);
        if (value != UnsetValue.UNSET) {
            if (value instanceof Var) {
                return (Var)value;
            }
            return new Var(value);
        }
        entry = this.createEntry(name, FieldVisibility.PUBLIC);
        value = entry._value;
        if (value instanceof Var) {
            return (Var)value;
        }
        Var var = new Var(value);
        entry.setValue(var);
        return var;
    }

    @Override
    public Value getFieldArg(Env env, StringValue name, boolean isTop) {
        Entry entry = this.getEntry(env, name);
        if (entry != null) {
            Value value = entry.getValue();
            if (isTop || !value.isset()) {
                return entry.toArg();
            }
            return value;
        }
        Value value = this.getFieldExt(env, name);
        if (value != UnsetValue.UNSET) {
            return value;
        }
        return new ArgGetFieldValue(env, this, name);
    }

    @Override
    public Value getThisFieldArg(Env env, StringValue name) {
        Entry entry = this.getThisEntry(name);
        if (entry != null) {
            return entry.toArg();
        }
        Value value = this.getFieldExt(env, name);
        if (value != UnsetValue.UNSET) {
            return value;
        }
        return new ArgGetFieldValue(env, this, name);
    }

    @Override
    public Value getFieldArgRef(Env env, StringValue name) {
        Entry entry = this.getEntry(env, name);
        if (entry != null) {
            return entry.toArg();
        }
        Value value = this.getFieldExt(env, name);
        if (value != UnsetValue.UNSET) {
            return value;
        }
        return new ArgGetFieldValue(env, this, name);
    }

    @Override
    public Value getThisFieldArgRef(Env env, StringValue name) {
        Entry entry = this.getThisEntry(name);
        if (entry != null) {
            return entry.toArg();
        }
        Value value = this.getFieldExt(env, name);
        if (value != UnsetValue.UNSET) {
            return value;
        }
        return new ArgGetFieldValue(env, this, name);
    }

    @Override
    public Value putField(Env env, StringValue name, Value value) {
        Value oldValue;
        Entry entry = this.getEntry(env, name);
        if (entry == null) {
            AbstractFunction fieldSet;
            oldValue = this.putFieldExt(env, name, value);
            if (oldValue != null) {
                return oldValue;
            }
            if (!this._isFieldInit && (fieldSet = this._quercusClass.getFieldSet()) != null) {
                this._isFieldInit = true;
                Value retVal = fieldSet.callMethod(env, this._quercusClass, (Value)this, (Value)name, value);
                this._isFieldInit = false;
                return retVal;
            }
            entry = this.createEntry(name, FieldVisibility.PUBLIC);
        }
        oldValue = entry._value;
        if (value instanceof Var) {
            Var var = (Var)value;
            entry._value = var;
        } else if (oldValue instanceof Var) {
            oldValue.set(value);
        } else {
            entry._value = value;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value putThisField(Env env, StringValue name, Value value) {
        Value oldValue;
        Entry entry = this.getThisEntry(name);
        if (entry == null) {
            AbstractFunction fieldSet;
            oldValue = this.putFieldExt(env, name, value);
            if (oldValue != null) {
                return oldValue;
            }
            if (!this._isFieldInit && (fieldSet = this._quercusClass.getFieldSet()) != null) {
                this._isFieldInit = true;
                Value retValue = NullValue.NULL;
                try {
                    retValue = fieldSet.callMethod(env, this._quercusClass, (Value)this, (Value)name, value);
                }
                finally {
                    this._isFieldInit = false;
                }
                return retValue;
            }
        }
        entry = this.createEntry(name, FieldVisibility.PUBLIC);
        oldValue = entry._value;
        if (value instanceof Var) {
            Var var = (Var)value;
            entry._value = var;
        } else if (oldValue instanceof Var) {
            oldValue.set(value);
        } else {
            entry._value = value;
        }
        return value;
    }

    protected Value putFieldExt(Env env, StringValue name, Value value) {
        return null;
    }

    @Override
    public void setFieldInit(boolean isInit) {
        this._isFieldInit = isInit;
    }

    @Override
    public boolean isFieldInit() {
        return this._isFieldInit;
    }

    @Override
    public void initField(StringValue key, Value value, FieldVisibility visibility) {
        Entry entry = this.createEntry(key, visibility);
        entry._value = value;
    }

    @Override
    public void unsetField(StringValue name) {
        int hash = (name.hashCode() & Integer.MAX_VALUE) % this._prime;
        Entry entry = this._entries[hash];
        while (entry != null) {
            if (name.equals(entry.getKey())) {
                Entry prev = entry._prev;
                Entry next = entry._next;
                if (prev != null) {
                    prev._next = next;
                } else {
                    this._entries[hash] = next;
                }
                if (next != null) {
                    next._prev = prev;
                }
                --this._size;
                return;
            }
            entry = entry._next;
        }
    }

    @Override
    public void unsetArray(Env env, StringValue name, Value index) {
        if (this._quercusClass.getFieldGet() != null) {
            return;
        }
        Entry entry = this.createEntry(name, FieldVisibility.PUBLIC);
        entry.toValue().remove(index);
    }

    @Override
    public void unsetThisArray(Env env, StringValue name, Value index) {
        if (this._quercusClass.getFieldGet() != null) {
            return;
        }
        Entry entry = this.createEntry(name, FieldVisibility.PUBLIC);
        entry.toValue().remove(index);
    }

    private Entry getEntry(Env env, StringValue name) {
        int hash = (name.hashCode() & Integer.MAX_VALUE) % this._prime;
        Entry entry = this._entries[hash];
        while (entry != null) {
            StringValue entryKey = entry._key;
            if (name == entryKey || name.equals(entryKey)) {
                return entry;
            }
            entry = entry._next;
        }
        return null;
    }

    private Entry getThisEntry(StringValue name) {
        int hash = (name.hashCode() & Integer.MAX_VALUE) % this._prime;
        Entry entry = this._entries[hash];
        while (entry != null) {
            StringValue entryKey = entry._key;
            if (name == entryKey || name.equals(entryKey)) {
                return entry;
            }
            entry = entry._next;
        }
        return null;
    }

    private Entry createEntry(StringValue name, FieldVisibility visibility) {
        int hash = (name.hashCode() & Integer.MAX_VALUE) % this._prime;
        Entry entry = this._entries[hash];
        while (entry != null) {
            if (name.equals(entry._key)) {
                return entry;
            }
            entry = entry._next;
        }
        ++this._size;
        Entry newEntry = new Entry(name, visibility);
        Entry next = this._entries[hash];
        if (next != null) {
            newEntry._next = next;
            next._prev = newEntry;
        }
        this._entries[hash] = newEntry;
        return newEntry;
    }

    @Override
    public Iterator<Map.Entry<Value, Value>> getIterator(Env env) {
        TraversableDelegate delegate = this._quercusClass.getTraversableDelegate();
        if (delegate != null) {
            return delegate.getIterator(env, this);
        }
        return new KeyValueIterator(this._entries);
    }

    @Override
    public Iterator<Value> getKeyIterator(Env env) {
        TraversableDelegate delegate = this._quercusClass.getTraversableDelegate();
        if (delegate != null) {
            return delegate.getKeyIterator(env, this);
        }
        return new KeyIterator(this._entries);
    }

    @Override
    public Iterator<Value> getValueIterator(Env env) {
        TraversableDelegate delegate = this._quercusClass.getTraversableDelegate();
        if (delegate != null) {
            return delegate.getValueIterator(env, this);
        }
        return new ValueIterator(this._entries);
    }

    @Override
    public AbstractFunction findFunction(String methodName) {
        return this._quercusClass.findFunction(methodName);
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash, Value[] args) {
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethod(env, this._quercusClass, (Value)this, args);
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash) {
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethod(env, this._quercusClass, (Value)this);
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash, Value a1) {
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethod(env, this._quercusClass, (Value)this, a1);
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash, Value a1, Value a2) {
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethod(env, this._quercusClass, (Value)this, a1, a2);
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3) {
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethod(env, this._quercusClass, (Value)this, a1, a2, a3);
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3, Value a4) {
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethod(env, this._quercusClass, (Value)this, a1, a2, a3, a4);
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3, Value a4, Value a5) {
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethod(env, this._quercusClass, this, a1, a2, a3, a4, a5);
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash, Value[] args) {
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethodRef(env, this._quercusClass, (Value)this, args);
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash) {
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethodRef(env, this._quercusClass, (Value)this);
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash, Value a1) {
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethodRef(env, this._quercusClass, (Value)this, a1);
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash, Value a1, Value a2) {
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethodRef(env, this._quercusClass, (Value)this, a1, a2);
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3) {
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethodRef(env, this._quercusClass, (Value)this, a1, a2, a3);
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3, Value a4) {
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethodRef(env, this._quercusClass, (Value)this, a1, a2, a3, a4);
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3, Value a4, Value a5) {
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethodRef(env, this._quercusClass, this, a1, a2, a3, a4, a5);
    }

    @Override
    public Value getObject(Env env) {
        return this;
    }

    @Override
    public Value copy() {
        return this;
    }

    @Override
    public Value copy(Env env, IdentityHashMap<Value, Value> map) {
        Value oldValue = map.get(this);
        if (oldValue != null) {
            return oldValue;
        }
        return new ObjectExtValue(env, map, this);
    }

    @Override
    public Value copyTree(Env env, CopyRoot root) {
        Value copy = root.getCopy(this);
        if (copy != null) {
            return copy;
        }
        return new CopyObjectExtValue(env, this, root);
    }

    @Override
    public Value clone(Env env) {
        ObjectExtValue newObject = new ObjectExtValue(this._quercusClass);
        EntryIterator iter = new EntryIterator(this._entries);
        while (iter.hasNext()) {
            Entry entry = (Entry)iter.next();
            Entry copy = newObject.createEntry(entry.getKey(), entry.getVisibility());
            copy.setValue(entry.getValue().copy());
        }
        return newObject;
    }

    @Override
    public void serialize(Env env, StringBuilder sb, SerializeMap serializeMap) {
        Integer index = serializeMap.get(this);
        if (index != null) {
            sb.append("r:");
            sb.append(index);
            sb.append(";");
            return;
        }
        serializeMap.put(this);
        serializeMap.incrementIndex();
        sb.append("O:");
        sb.append(this._className.length());
        sb.append(":\"");
        sb.append(this._className);
        sb.append("\":");
        sb.append(this.getSize());
        sb.append(":{");
        EntryIterator iter = new EntryIterator(this._entries);
        while (iter.hasNext()) {
            Entry entry = (Entry)iter.next();
            sb.append("s:");
            StringValue key = entry.getKey();
            int len = ((Value)key).length();
            if (entry._visibility == FieldVisibility.PROTECTED) {
                sb.append(len + 3);
                sb.append(":\"");
                sb.append("\u0000*\u0000");
            } else if (entry._visibility == FieldVisibility.PRIVATE) {
                sb.append(len + 3);
                sb.append(":\"");
                sb.append("\u0000A\u0000");
            } else {
                sb.append(len);
                sb.append(":\"");
            }
            sb.append((Object)key);
            sb.append("\";");
            Value value = entry.getRawValue();
            value.serialize(env, sb, serializeMap);
        }
        sb.append("}");
    }

    @Override
    public void varExport(StringBuilder sb) {
        sb.append(this.getName());
        sb.append("::__set_state(array(\n");
        for (Map.Entry<Value, Value> entry : this.entrySet()) {
            sb.append("   ");
            entry.getKey().varExport(sb);
            sb.append(" => ");
            entry.getValue().varExport(sb);
            sb.append(",\n");
        }
        sb.append("))");
    }

    @Override
    public StringValue appendTo(UnicodeBuilderValue sb) {
        return sb.append(this.toString(Env.getInstance()));
    }

    @Override
    public StringValue appendTo(StringBuilderValue sb) {
        return sb.append(this.toString(Env.getInstance()));
    }

    @Override
    public StringValue appendTo(BinaryBuilderValue sb) {
        return sb.appendBytes(this.toString(Env.getInstance()));
    }

    @Override
    public StringValue appendTo(LargeStringBuilderValue sb) {
        return sb.append(this.toString(Env.getInstance()));
    }

    @Override
    public StringValue toStringBuilder(Env env) {
        return this.toString(env).toStringBuilder(env);
    }

    @Override
    public String toJavaString() {
        return this.toString(Env.getInstance()).toString();
    }

    @Override
    public StringValue toString(Env env) {
        AbstractFunction toString = this._quercusClass.getToString();
        if (toString != null) {
            return toString.callMethod(env, this._quercusClass, (Value)this).toStringValue();
        }
        return env.createString(this._className + "[]");
    }

    @Override
    public void print(Env env) {
        env.print(this.toString(env));
    }

    @Override
    public Value toArray() {
        ArrayValueImpl array = new ArrayValueImpl();
        for (Map.Entry<Value, Value> entry : this.entrySet()) {
            array.put(entry.getKey(), entry.getValue());
        }
        return array;
    }

    @Override
    public Value toObject(Env env) {
        return this;
    }

    @Override
    public Object toJavaObject() {
        return this;
    }

    @Override
    public Set<? extends Map.Entry<Value, Value>> entrySet() {
        return new EntrySet();
    }

    public Set<? extends Map.Entry<Value, Value>> sortedEntrySet() {
        return new TreeSet<Map.Entry<Value, Value>>(this.entrySet());
    }

    @Override
    public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        int size = this.getSize();
        if (this.isIncompleteObject()) {
            ++size;
        }
        out.println("object(" + this.getName() + ") (" + size + ") {");
        if (this.isIncompleteObject()) {
            this.printDepth(out, 2 * (depth + 1));
            out.println("[\"__Quercus_Incomplete_Class_name\"]=>");
            this.printDepth(out, 2 * (depth + 1));
            StringValue value = env.createString(this.getIncompleteObjectName());
            value.varDump(env, out, depth + 1, valueSet);
            out.println();
        }
        for (Map.Entry<Value, Value> entry : this.sortedEntrySet()) {
            Entry entry2 = (Entry)entry;
            entry2.varDumpImpl(env, out, depth + 1, valueSet);
        }
        this.printDepth(out, 2 * depth);
        out.print("}");
    }

    @Override
    protected void printRImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        out.print(this.getName());
        out.print(' ');
        out.println("Object");
        this.printDepth(out, 4 * depth);
        out.println("(");
        for (Map.Entry<Value, Value> entry : this.sortedEntrySet()) {
            Entry entry2 = (Entry)entry;
            entry2.printRImpl(env, out, depth + 1, valueSet);
        }
        this.printDepth(out, 4 * depth);
        out.println(")");
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this._className);
        out.writeInt(this._size);
        for (Map.Entry<Value, Value> entry : this.entrySet()) {
            out.writeObject(entry.getKey());
            out.writeObject(entry.getValue());
        }
    }

    @Override
    public void jsonEncode(Env env, StringValue sb) {
        sb.append('{');
        int length = 0;
        EntryIterator iter = new EntryIterator(this._entries);
        while (iter.hasNext()) {
            Entry entry = (Entry)iter.next();
            if (entry.getVisibility() != FieldVisibility.PUBLIC) continue;
            if (length > 0) {
                sb.append(',');
            }
            entry.getKey().toStringValue().jsonEncode(env, sb);
            sb.append(':');
            entry.getValue().jsonEncode(env, sb);
            ++length;
        }
        sb.append('}');
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        Env env = Env.getInstance();
        String name = (String)in.readObject();
        QuercusClass cl = env.findClass(name);
        this.init();
        if (cl != null) {
            this.setQuercusClass(cl);
        } else {
            cl = env.getQuercus().getStdClass();
            this.setQuercusClass(cl);
            this.setIncompleteObjectName(name);
        }
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.putThisField(env, (StringValue)in.readObject(), (Value)in.readObject());
        }
    }

    public void cleanup(Env env) {
        QuercusClass qClass = this.getQuercusClass();
        AbstractFunction fun = qClass.getDestructor();
        if (fun != null) {
            fun.callMethod(env, qClass, (Value)this);
        }
    }

    private static String toMethod(char[] key, int keyLength) {
        return new String(key, 0, keyLength);
    }

    public String toString() {
        if (Alarm.isTest()) {
            return this.getClass().getSimpleName() + "[" + this._className + "]";
        }
        return this.getClass().getSimpleName() + "@" + System.identityHashCode(this) + "[" + this._className + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Entry
    implements Map.Entry<Value, Value>,
    Comparable<Map.Entry<Value, Value>> {
        private final StringValue _key;
        private final FieldVisibility _visibility;
        private Value _value;
        private Entry _prev;
        private Entry _next;

        public Entry(StringValue key) {
            this._key = key;
            this._visibility = FieldVisibility.PUBLIC;
            this._value = NullValue.NULL;
        }

        public Entry(StringValue key, FieldVisibility visibility) {
            this._key = key;
            this._visibility = visibility;
            this._value = NullValue.NULL;
        }

        public Entry(StringValue key, Value value) {
            this._key = key;
            this._visibility = FieldVisibility.PUBLIC;
            this._value = value;
        }

        public Entry(StringValue key, Value value, FieldVisibility visibility) {
            this._key = key;
            this._visibility = visibility;
            this._value = value;
        }

        public Entry(Env env, IdentityHashMap<Value, Value> map, Entry entry) {
            this._key = entry._key;
            this._visibility = entry._visibility;
            this._value = entry._value.copy(env, map);
        }

        @Override
        public Value getValue() {
            return this._value.toValue();
        }

        public Value getRawValue() {
            return this._value;
        }

        @Override
        public StringValue getKey() {
            return this._key;
        }

        public Entry getNext() {
            return this._next;
        }

        public void setNext(Entry next) {
            this._next = next;
        }

        public FieldVisibility getVisibility() {
            return this._visibility;
        }

        public final boolean isPrivate() {
            return this._visibility == FieldVisibility.PRIVATE;
        }

        public Value toValue() {
            return this._value.toValue();
        }

        public Var toRefVar() {
            Var var = this._value.toLocalVarDeclAsRef();
            this._value = var;
            return var;
        }

        public Value toArgValue() {
            return this._value.toValue();
        }

        @Override
        public Value setValue(Value value) {
            Value oldValue = this.toValue();
            this._value = value;
            return oldValue;
        }

        public Value toRef() {
            Value value = this._value;
            if (value instanceof Var) {
                return new ArgRef((Var)value);
            }
            Var var = new Var(this._value);
            this._value = var;
            return new ArgRef(var);
        }

        public Value toArgRef() {
            Value value = this._value;
            if (value instanceof Var) {
                return new ArgRef((Var)value);
            }
            Var var = new Var(this._value);
            this._value = var;
            return new ArgRef(var);
        }

        public Value toArg() {
            Value value = this._value;
            if (value instanceof Var) {
                return value;
            }
            Var var = new Var(this._value);
            this._value = var;
            return var;
        }

        Entry copyTree(Env env, CopyRoot root) {
            Value copy = root.getCopy(this._value);
            if (copy == null) {
                copy = this._value.copyTree(env, root);
            }
            return new Entry(this._key, copy, this._visibility);
        }

        @Override
        public int compareTo(Map.Entry<Value, Value> other) {
            if (other == null) {
                return 1;
            }
            StringValue thisKey = this.getKey();
            Value otherKey = other.getKey();
            if (thisKey == null) {
                return otherKey == null ? 0 : -1;
            }
            if (otherKey == null) {
                return 1;
            }
            return ((Value)thisKey).cmp(otherKey);
        }

        public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
            String suffix = "";
            if (this._visibility == FieldVisibility.PROTECTED) {
                suffix = ":protected";
            } else if (this._visibility == FieldVisibility.PRIVATE) {
                suffix = ":private";
            }
            this.printDepth(out, 2 * depth);
            out.println("[\"" + this.getKey() + suffix + "\"]=>");
            this.printDepth(out, 2 * depth);
            this._value.varDump(env, out, depth, valueSet);
            out.println();
        }

        protected void printRImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
            String suffix = "";
            if (this._visibility == FieldVisibility.PROTECTED) {
                suffix = ":protected";
            } else if (this._visibility == FieldVisibility.PRIVATE) {
                suffix = ":private";
            }
            this.printDepth(out, 4 * depth);
            out.print("[" + this.getKey() + suffix + "] => ");
            this._value.printR(env, out, depth + 1, valueSet);
            out.println();
        }

        private void printDepth(WriteStream out, int depth) throws IOException {
            for (int i = 0; i < depth; ++i) {
                out.print(' ');
            }
        }

        public String toString() {
            return "ObjectExtValue.Entry[" + this.getKey() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeyIterator
    implements Iterator<Value> {
        private final Entry[] _list;
        private int _index;
        private Entry _entry;

        KeyIterator(Entry[] list) {
            this._list = list;
        }

        @Override
        public boolean hasNext() {
            if (this._entry != null) {
                return true;
            }
            while (this._index < this._list.length && this._list[this._index] == null) {
                ++this._index;
            }
            return this._index < this._list.length;
        }

        @Override
        public Value next() {
            if (this._entry != null) {
                Entry entry = this._entry;
                this._entry = entry._next;
                return entry._key;
            }
            while (this._index < this._list.length && this._list[this._index] == null) {
                ++this._index;
            }
            if (this._list.length <= this._index) {
                return null;
            }
            Entry entry = this._list[this._index++];
            this._entry = entry._next;
            return entry._key;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ValueIterator
    implements Iterator<Value> {
        private final Entry[] _list;
        private int _index;
        private Entry _entry;

        ValueIterator(Entry[] list) {
            this._list = list;
        }

        @Override
        public boolean hasNext() {
            if (this._entry != null) {
                return true;
            }
            while (this._index < this._list.length && this._list[this._index] == null) {
                ++this._index;
            }
            return this._index < this._list.length;
        }

        @Override
        public Value next() {
            if (this._entry != null) {
                Entry entry = this._entry;
                this._entry = entry._next;
                return entry._value;
            }
            while (this._index < this._list.length && this._list[this._index] == null) {
                ++this._index;
            }
            if (this._list.length <= this._index) {
                return null;
            }
            Entry entry = this._list[this._index++];
            this._entry = entry._next;
            return entry._value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeyValueIterator
    implements Iterator<Map.Entry<Value, Value>> {
        private final Entry[] _list;
        private int _index;
        private Entry _entry;

        KeyValueIterator(Entry[] list) {
            this._list = list;
        }

        @Override
        public boolean hasNext() {
            if (this._entry != null) {
                return true;
            }
            while (this._index < this._list.length && this._list[this._index] == null) {
                ++this._index;
            }
            return this._index < this._list.length;
        }

        @Override
        public Map.Entry<Value, Value> next() {
            if (this._entry != null) {
                Entry entry = this._entry;
                this._entry = entry._next;
                return entry;
            }
            while (this._index < this._list.length && this._list[this._index] == null) {
                ++this._index;
            }
            if (this._list.length <= this._index) {
                return null;
            }
            Entry entry = this._list[this._index++];
            this._entry = entry._next;
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EntryIterator
    implements Iterator<Entry> {
        private final Entry[] _list;
        private int _index;
        private Entry _entry;

        EntryIterator(Entry[] list) {
            this._list = list;
        }

        @Override
        public boolean hasNext() {
            if (this._entry != null) {
                return true;
            }
            while (this._index < this._list.length && this._list[this._index] == null) {
                ++this._index;
            }
            return this._index < this._list.length;
        }

        @Override
        public Entry next() {
            if (this._entry != null) {
                Entry entry = this._entry;
                this._entry = entry._next;
                return entry;
            }
            while (this._index < this._list.length && this._list[this._index] == null) {
                ++this._index;
            }
            if (this._list.length <= this._index) {
                return null;
            }
            Entry entry = this._list[this._index++];
            this._entry = entry._next;
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EntrySet
    extends AbstractSet<Map.Entry<Value, Value>> {
        EntrySet() {
        }

        @Override
        public int size() {
            return ObjectExtValue.this.getSize();
        }

        @Override
        public Iterator<Map.Entry<Value, Value>> iterator() {
            return new KeyValueIterator(ObjectExtValue.this._entries);
        }
    }
}

