/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BinaryBuilderValue;
import com.caucho.quercus.env.BinaryValue;
import com.caucho.quercus.env.ConstStringValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LargeStringBuilderValue;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.UnsetStringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.ValueType;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.TempCharBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.IdentityHashMap;
import java.util.zip.CRC32;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringBuilderValue
extends BinaryValue {
    public static final StringBuilderValue EMPTY = new ConstStringValue("");
    private static final StringBuilderValue[] CHAR_STRINGS = new ConstStringValue[256];
    private static final int LARGE_BUILDER_THRESHOLD = 4096;
    private byte[] _buffer;
    private int _length;
    private boolean _isCopy;
    private int _hashCode;

    public StringBuilderValue() {
        this._buffer = new byte[32];
    }

    public StringBuilderValue(int capacity) {
        if (capacity < 32) {
            capacity = 32;
        }
        this._buffer = new byte[capacity];
    }

    public StringBuilderValue(byte[] buffer, int offset, int length) {
        this._buffer = new byte[length];
        this._length = length;
        System.arraycopy(buffer, offset, this._buffer, 0, length);
    }

    public StringBuilderValue(char[] buffer, int offset, int length) {
        this._buffer = new byte[length];
        this._length = length;
        for (int i = 0; i < length; ++i) {
            this._buffer[i] = (byte)buffer[offset + i];
        }
    }

    public StringBuilderValue(char[] buffer, int length) {
        this(buffer, 0, length);
    }

    public StringBuilderValue(byte[] buffer) {
        this(buffer, 0, buffer.length);
    }

    public StringBuilderValue(char ch) {
        this._buffer = new byte[1];
        this._length = 1;
        this._buffer[0] = (byte)ch;
    }

    public StringBuilderValue(byte ch) {
        this._buffer = new byte[1];
        this._length = 1;
        this._buffer[0] = ch;
    }

    public StringBuilderValue(String s) {
        int len = s.length();
        this._buffer = new byte[len];
        this._length = len;
        for (int i = 0; i < len; ++i) {
            this._buffer[i] = (byte)s.charAt(i);
        }
    }

    public StringBuilderValue(char[] s) {
        this(s, 0, s.length);
    }

    public StringBuilderValue(char[] s, Value v1) {
        int bufferLength;
        int len = s.length;
        for (bufferLength = 32; bufferLength < len; bufferLength *= 2) {
        }
        this._buffer = new byte[bufferLength];
        this._length = len;
        for (int i = 0; i < len; ++i) {
            this._buffer[i] = (byte)s[i];
        }
        v1.appendTo(this);
    }

    public StringBuilderValue(byte[] s, Value v1) {
        int bufferLength;
        int len = s.length;
        for (bufferLength = 32; bufferLength < len; bufferLength *= 2) {
        }
        this._buffer = new byte[bufferLength];
        this._length = len;
        System.arraycopy(s, 0, this._buffer, 0, len);
        v1.appendTo(this);
    }

    public StringBuilderValue(Value v1) {
        if (v1 instanceof StringBuilderValue) {
            this.init((StringBuilderValue)v1);
        } else {
            this._buffer = new byte[32];
            v1.appendTo(this);
        }
    }

    public StringBuilderValue(StringBuilderValue v) {
        this.init(v);
    }

    private void init(StringBuilderValue v) {
        if (v._isCopy || v instanceof ConstStringValue) {
            this._buffer = new byte[v._buffer.length];
            System.arraycopy(v._buffer, 0, this._buffer, 0, v._length);
            this._length = v._length;
        } else {
            this._buffer = v._buffer;
            this._length = v._length;
            v._isCopy = true;
        }
    }

    public StringBuilderValue(Value v1, Value v2) {
        this._buffer = new byte[32];
        v1.appendTo(this);
        v2.appendTo(this);
    }

    public StringBuilderValue(Value v1, Value v2, Value v3) {
        this._buffer = new byte[32];
        v1.appendTo(this);
        v2.appendTo(this);
        v3.appendTo(this);
    }

    public static StringValue create(byte value) {
        return CHAR_STRINGS[value & 0xFF];
    }

    public static StringValue create(char value) {
        return CHAR_STRINGS[value & 0xFF];
    }

    public static Value create(String value) {
        if (value == null) {
            return NullValue.NULL;
        }
        if (value.length() == 0) {
            return EMPTY;
        }
        return new StringBuilderValue(value);
    }

    public final String getValue() {
        return this.toString();
    }

    @Override
    public String getType() {
        return "string";
    }

    @Override
    public ValueType getValueType() {
        return StringBuilderValue.getValueType(this._buffer, 0, this._length);
    }

    public static final ValueType getValueType(byte[] buffer, int offset, int len) {
        int i;
        if (len == 0) {
            return ValueType.LONG_ADD;
        }
        byte ch = 0;
        for (i = offset; i < len && Character.isWhitespace(buffer[i]); ++i) {
        }
        if (i + 1 < len && buffer[i] == 48 && buffer[i + 1] == 120) {
            return ValueType.LONG_EQ;
        }
        if (i < len && ((ch = buffer[i]) == 43 || ch == 45)) {
            ++i;
        }
        if (len <= i) {
            return ValueType.STRING;
        }
        ch = buffer[i];
        if (ch == 46) {
            if (++i < len && 48 <= (ch = buffer[i]) && ch <= 57) {
                return ValueType.DOUBLE_CMP;
            }
            return ValueType.STRING;
        }
        if (48 > ch || ch > 57) {
            return ValueType.STRING;
        }
        while (i < len && 48 <= (ch = buffer[i]) && ch <= 57) {
            ++i;
        }
        while (i < len && Character.isWhitespace(buffer[i])) {
            ++i;
        }
        if (len <= i) {
            return ValueType.LONG_EQ;
        }
        if (ch == 46 || ch == 101 || ch == 69) {
            ++i;
            while (i < len && (48 <= (ch = buffer[i]) && ch <= 57 || ch == 43 || ch == 45 || ch == 101 || ch == 69)) {
                ++i;
            }
            while (i < len && Character.isWhitespace(buffer[i])) {
                ++i;
            }
            if (i < len) {
                return ValueType.STRING;
            }
            return ValueType.DOUBLE_CMP;
        }
        return ValueType.STRING;
    }

    @Override
    public final boolean isScalar() {
        return true;
    }

    @Override
    public boolean isPHP5String() {
        return true;
    }

    @Override
    public final boolean toBoolean() {
        if (this._length == 0) {
            return false;
        }
        return this._length != 1 || this._buffer[0] != 48;
    }

    @Override
    public long toLong() {
        return StringBuilderValue.parseLong(this._buffer, 0, this._length);
    }

    @Override
    public double toDouble() {
        return StringBuilderValue.toDouble(this._buffer, 0, this._length);
    }

    public static final double toDouble(byte[] buffer, int offset, int len) {
        int i;
        int start = offset;
        int ch = 0;
        for (i = offset; i < len && Character.isWhitespace(buffer[i]); ++i) {
            ++start;
        }
        int end = offset + len;
        if (offset + 1 < end && buffer[offset] == 48 && ((ch = buffer[offset + 1]) == 120 || ch == 88)) {
            double value = 0.0;
            offset += 2;
            while (offset < end) {
                ch = buffer[offset] & 0xFF;
                if (48 <= ch && ch <= 57) {
                    value = value * 16.0 + (double)ch - 48.0;
                } else if (97 <= ch && ch <= 122) {
                    value = value * 16.0 + (double)ch - 97.0 + 10.0;
                } else if (65 <= ch && ch <= 90) {
                    value = value * 16.0 + (double)ch - 65.0 + 10.0;
                } else {
                    return value;
                }
                ++offset;
            }
            return value;
        }
        if (i < len && ((ch = buffer[i]) == 43 || ch == 45)) {
            ++i;
        }
        while (i < len && 48 <= (ch = buffer[i]) && ch <= 57) {
            ++i;
        }
        if (ch == 46) {
            ++i;
            while (i < len && 48 <= (ch = buffer[i]) && ch <= 57) {
                ++i;
            }
            if (i == 1) {
                return 0.0;
            }
        }
        if (ch == 101 || ch == 69) {
            int e = i++;
            if (i < len && (ch = buffer[i]) == 43 || ch == 45) {
                ++i;
            }
            while (i < len && 48 <= (ch = buffer[i]) && ch <= 57) {
                ++i;
            }
            if (i == e + 1) {
                i = e;
            }
        }
        if (i == 0) {
            return 0.0;
        }
        try {
            return Double.parseDouble(new String(buffer, start, i - start));
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    @Override
    public final InputStream toInputStream() {
        return new BuilderInputStream();
    }

    @Override
    public String toString() {
        if (this._length == 1) {
            return String.valueOf((char)(this._buffer[0] & 0xFF));
        }
        CharBuffer buf = CharBuffer.allocate();
        buf.append(this._buffer, 0, this._length);
        String str = buf.toString();
        buf.free();
        return str;
    }

    @Override
    public final StringValue toBinaryValue(Env env) {
        return this;
    }

    @Override
    public final StringValue toBinaryValue(String charset) {
        return this;
    }

    @Override
    public StringValue toUnicodeValue() {
        return new UnicodeBuilderValue().append(this.getBuffer(), 0, this.length());
    }

    @Override
    public StringValue toUnicodeValue(Env env) {
        return this.toUnicodeValue();
    }

    @Override
    public StringValue toUnicodeValue(Env env, String charset) {
        return this.toUnicodeValue();
    }

    @Override
    public final Object toJavaObject() {
        return this.toString();
    }

    @Override
    public final boolean isEmpty() {
        return this._length == 0 || this._length == 1 && this._buffer[0] == 48;
    }

    @Override
    public final void writeTo(OutputStream os) {
        try {
            os.write(this._buffer, 0, this._length);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    @Override
    public StringValue appendTo(StringBuilderValue bb) {
        bb.append(this._buffer, 0, this._length);
        return bb;
    }

    @Override
    public StringValue appendTo(UnicodeBuilderValue bb) {
        bb.append(this._buffer, 0, this._length);
        return bb;
    }

    @Override
    public StringValue appendTo(LargeStringBuilderValue bb) {
        bb.append(this._buffer, 0, this._length);
        return bb;
    }

    @Override
    public StringValue appendTo(BinaryBuilderValue bb) {
        bb.append(this._buffer, 0, this._length);
        return bb;
    }

    @Override
    public Value toKey() {
        byte[] buffer = this._buffer;
        int len = this._length;
        if (len == 0) {
            return this;
        }
        int sign = 1;
        long value = 0L;
        int i = 0;
        byte ch = buffer[i];
        if (ch == 45) {
            sign = -1;
            ++i;
        }
        while (i < len) {
            ch = buffer[i];
            if (48 > ch || ch > 57) {
                return this;
            }
            value = 10L * value + (long)ch - 48L;
            ++i;
        }
        return LongValue.create((long)sign * value);
    }

    @Override
    public final byte[] toBytes() {
        byte[] bytes = new byte[this._length];
        System.arraycopy(this._buffer, 0, bytes, 0, this._length);
        return bytes;
    }

    @Override
    public final Value get(Value key) {
        return this.charValueAt(key.toLong());
    }

    @Override
    public Value put(Value index, Value value) {
        this.setCharValueAt(index.toLong(), value);
        return value;
    }

    @Override
    public Value append(Value index, Value value) {
        if (this._length > 0) {
            return this.setCharValueAt(index.toLong(), value);
        }
        return new ArrayValueImpl().append(index, value);
    }

    @Override
    public int length() {
        return this._length;
    }

    @Override
    public final char charAt(int index) {
        if (index < 0 || this._length <= index) {
            return '\u0000';
        }
        return (char)(this._buffer[index] & 0xFF);
    }

    @Override
    public Value charValueAt(long index) {
        int len = this._length;
        if (index < 0L || (long)len <= index) {
            return UnsetStringValue.UNSET;
        }
        byte ch = this._buffer[(int)index];
        return CHAR_STRINGS[ch & 0xFF];
    }

    @Override
    public Value setCharValueAt(long indexL, Value value) {
        int len = this._length;
        if (indexL < 0L) {
            return this;
        }
        if (indexL < (long)len) {
            StringBuilderValue sb = this.createStringBuilder(this._buffer, 0, len);
            StringValue str = value.toStringValue();
            int index = (int)indexL;
            sb._buffer[index] = value.length() == 0 ? (byte)0 : (byte)str.charAt(0);
            return sb;
        }
        int index = (int)indexL;
        StringBuilderValue sb = (StringBuilderValue)this.copyStringBuilder();
        if (sb._buffer.length < index + 1) {
            sb.ensureCapacity(index + 1);
        }
        int padLen = index - len;
        for (int i = 0; i <= padLen; ++i) {
            sb._buffer[sb._length++] = 32;
        }
        StringValue str = value.toStringValue();
        sb._buffer[index] = value.length() == 0 ? (byte)0 : (byte)str.charAt(0);
        return sb;
    }

    @Override
    public int indexOf(char match) {
        int length = this._length;
        byte[] buffer = this._buffer;
        for (int head = 0; head < length; ++head) {
            if (buffer[head] != match) continue;
            return head;
        }
        return -1;
    }

    @Override
    public int indexOf(char match, int head) {
        int length = this._length;
        byte[] buffer = this._buffer;
        while (head < length) {
            if (buffer[head] == match) {
                return head;
            }
            ++head;
        }
        return -1;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (end <= start) {
            return EMPTY;
        }
        if (end - start == 1) {
            return CHAR_STRINGS[this._buffer[start] & 0xFF];
        }
        return this.createStringBuilder(this._buffer, start, end - start);
    }

    @Override
    public String stringSubstring(int start, int end) {
        if (end <= start) {
            return "";
        }
        CharBuffer buf = CharBuffer.allocate();
        buf.append(this._buffer, start, end - start);
        String str = buf.toString();
        buf.free();
        return str;
    }

    @Override
    public StringValue toLowerCase() {
        int length = this._length;
        StringBuilderValue string = this.createStringBuilder(length);
        byte[] srcBuffer = this._buffer;
        byte[] dstBuffer = string._buffer;
        for (int i = 0; i < length; ++i) {
            byte ch = srcBuffer[i];
            dstBuffer[i] = 65 <= ch && ch <= 90 ? (byte)(ch + 97 - 65) : ch;
        }
        string._length = length;
        return string;
    }

    @Override
    public StringValue toUpperCase() {
        int length = this._length;
        StringBuilderValue string = this.createStringBuilder(this._length);
        byte[] srcBuffer = this._buffer;
        byte[] dstBuffer = string._buffer;
        for (int i = 0; i < length; ++i) {
            byte ch = srcBuffer[i];
            dstBuffer[i] = 97 <= ch && ch <= 122 ? (byte)(ch + 65 - 97) : ch;
        }
        string._length = length;
        return string;
    }

    @Override
    public boolean regionMatches(int offset, char[] mBuffer, int mOffset, int mLength) {
        int length = this._length;
        if (length < offset + mLength) {
            return false;
        }
        byte[] buffer = this._buffer;
        for (int i = 0; i < mLength; ++i) {
            if ((buffer[offset + i] & 0xFF) == mBuffer[mOffset + i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean regionMatchesIgnoreCase(int offset, char[] mBuffer, int mOffset, int mLength) {
        int length = this._length;
        if (length < offset + mLength) {
            return false;
        }
        byte[] buffer = this._buffer;
        for (int i = 0; i < mLength; ++i) {
            int a = buffer[offset + i] & 0xFF;
            char b = mBuffer[mOffset + i];
            if (65 <= a && a <= 90) {
                a += 32;
            }
            if ('A' <= b && b <= 'Z') {
                b = (char)(b + 32);
            }
            if (a == b) continue;
            return false;
        }
        return true;
    }

    @Override
    public StringBuilderValue createStringBuilder() {
        return new StringBuilderValue();
    }

    @Override
    public StringBuilderValue createStringBuilder(int length) {
        return new StringBuilderValue(length);
    }

    public StringBuilderValue createStringBuilder(byte[] buffer, int offset, int length) {
        return new StringBuilderValue(buffer, offset, length);
    }

    @Override
    public StringValue copyStringBuilder() {
        return new StringBuilderValue(this);
    }

    @Override
    public StringValue toStringBuilder() {
        return new StringBuilderValue(this);
    }

    @Override
    public StringValue toStringBuilder(Env env) {
        if (this._length >= 4096) {
            return new LargeStringBuilderValue(this);
        }
        return new StringBuilderValue(this);
    }

    @Override
    public StringValue toStringBuilder(Env env, Value value) {
        if (this._length + value.length() >= 4096) {
            LargeStringBuilderValue v = new LargeStringBuilderValue(this);
            value.appendTo(v);
            return v;
        }
        StringBuilderValue v = new StringBuilderValue(this);
        value.appendTo(v);
        return v;
    }

    @Override
    public StringValue toStringBuilder(Env env, StringValue value) {
        if (this._length + value.length() >= 4096) {
            LargeStringBuilderValue v = new LargeStringBuilderValue(this);
            value.appendTo(v);
            return v;
        }
        StringBuilderValue v = new StringBuilderValue(this);
        value.appendTo(v);
        return v;
    }

    @Override
    public final StringValue append(String s) {
        int sublen = s.length();
        if (this._buffer.length < this._length + sublen) {
            this.ensureCapacity(this._length + sublen);
        }
        byte[] buffer = this._buffer;
        int length = this._length;
        for (int i = 0; i < sublen; ++i) {
            buffer[length + i] = (byte)s.charAt(i);
        }
        this._length = length + sublen;
        return this;
    }

    @Override
    public final StringValue append(String s, int start, int end) {
        int sublen = end - start;
        if (this._buffer.length < this._length + sublen) {
            this.ensureCapacity(this._length + sublen);
        }
        byte[] buffer = this._buffer;
        int length = this._length;
        while (start < end) {
            buffer[length++] = (byte)s.charAt(start);
            ++start;
        }
        this._length = length;
        return this;
    }

    @Override
    public final StringValue append(char ch) {
        if (this._buffer.length < this._length + 1) {
            this.ensureCapacity(this._length + 1);
        }
        this._buffer[this._length++] = (byte)ch;
        return this;
    }

    @Override
    public final void write(int ch) {
        if (this._buffer.length < this._length + 1) {
            this.ensureCapacity(this._length + 1);
        }
        this._buffer[this._length++] = (byte)ch;
    }

    @Override
    public final StringValue append(char[] buf, int offset, int length) {
        int end = this._length + length;
        if (this._buffer.length < end) {
            this.ensureCapacity(end);
        }
        byte[] buffer = this._buffer;
        int bufferLength = this._length;
        for (int i = 0; i < length; ++i) {
            buffer[bufferLength + i] = (byte)buf[offset + i];
        }
        this._length = end;
        return this;
    }

    @Override
    public final StringValue append(char[] buf) {
        int length = buf.length;
        if (this._buffer.length < this._length + length) {
            this.ensureCapacity(this._length + length);
        }
        byte[] buffer = this._buffer;
        int bufferLength = this._length;
        for (int i = 0; i < length; ++i) {
            buffer[bufferLength++] = (byte)buf[i];
        }
        this._buffer = buffer;
        this._length = bufferLength;
        return this;
    }

    @Override
    public StringValue appendUnicode(char[] buf) {
        int length = buf.length;
        if (this._buffer.length < this._length + length) {
            this.ensureCapacity(this._length + length);
        }
        byte[] buffer = this._buffer;
        int bufferLength = this._length;
        for (int i = 0; i < length; ++i) {
            buffer[bufferLength++] = (byte)buf[i];
        }
        this._buffer = buffer;
        this._length = bufferLength;
        return this;
    }

    @Override
    public StringValue appendUnicode(char[] buf, int offset, int length) {
        if (this._buffer.length < this._length + length) {
            this.ensureCapacity(this._length + length);
        }
        byte[] buffer = this._buffer;
        int bufferLength = this._length;
        while (length > 0) {
            buffer[bufferLength++] = (byte)buf[offset++];
            --length;
        }
        this._buffer = buffer;
        this._length = bufferLength;
        return this;
    }

    @Override
    public final StringValue append(CharSequence buf, int head, int tail) {
        int length = tail - head;
        if (this._buffer.length < this._length + length) {
            this.ensureCapacity(this._length + length);
        }
        if (buf instanceof StringBuilderValue) {
            StringBuilderValue sb = (StringBuilderValue)buf;
            System.arraycopy(sb._buffer, head, this._buffer, this._length, length);
            this._length += length;
            return this;
        }
        byte[] buffer = this._buffer;
        int bufferLength = this._length;
        while (head < tail) {
            buffer[bufferLength++] = (byte)buf.charAt(head);
            ++head;
        }
        this._length = bufferLength;
        return this;
    }

    @Override
    public StringValue append(StringBuilderValue sb, int head, int tail) {
        int length = tail - head;
        if (this._buffer.length < this._length + length) {
            this.ensureCapacity(this._length + length);
        }
        System.arraycopy(sb._buffer, head, this._buffer, this._length, length);
        this._length += length;
        return this;
    }

    @Override
    public final StringValue append(Value v) {
        v.appendTo(this);
        return this;
    }

    @Override
    public final int indexOf(CharSequence match, int head) {
        int matchLength = match.length();
        if (matchLength <= 0) {
            return -1;
        }
        if (head < 0) {
            return -1;
        }
        int length = this._length;
        int end = length - matchLength;
        char first = match.charAt(0);
        byte[] buffer = this._buffer;
        while (head <= end) {
            block6: {
                if (buffer[head] == first) {
                    for (int i = 1; i < matchLength; ++i) {
                        if (buffer[head + i] == match.charAt(i)) {
                            continue;
                        }
                        break block6;
                    }
                    return head;
                }
            }
            ++head;
        }
        return -1;
    }

    @Override
    public StringValue appendUnicode(Value v) {
        v.appendTo(this);
        return this;
    }

    @Override
    public StringValue appendUnicode(Value v1, Value v2) {
        v1.appendTo(this);
        v2.appendTo(this);
        return this;
    }

    @Override
    public final StringValue append(byte[] buf, int offset, int length) {
        int end = this._length + length;
        if (this._buffer.length < end) {
            this.ensureCapacity(end);
        }
        System.arraycopy(buf, offset, this._buffer, this._length, length);
        this._length = end;
        return this;
    }

    @Override
    public final void write(byte[] buf, int offset, int length) {
        this.append(buf, offset, length);
    }

    @Override
    public final StringValue append(byte[] buf) {
        return this.append(buf, 0, buf.length);
    }

    @Override
    public final StringValue appendUtf8(byte[] buf, int offset, int length) {
        if (this._buffer.length < this._length + length) {
            this.ensureCapacity(this._length + length);
        }
        byte[] charBuffer = this._buffer;
        int charLength = this._length;
        int end = offset + length;
        while (offset < end) {
            int ch2;
            int ch;
            if ((ch = buf[offset++] & 0xFF) < 128) {
                charBuffer[charLength++] = (byte)ch;
                continue;
            }
            if (ch < 224) {
                ch2 = buf[offset++] & 0xFF;
                char v = (char)(((ch & 0x1F) << 6) + (ch2 & 0x3F));
                charBuffer[charLength++] = (byte)(v & 0xFF);
                continue;
            }
            ch2 = buf[offset++] & 0xFF;
            int ch3 = buf[offset++] & 0xFF;
            byte v = (byte)(((ch & 0xF) << 12) + ((ch2 & 0x3F) << 6) + (ch3 << 6));
            charBuffer[charLength++] = v;
        }
        this._length = charLength;
        return this;
    }

    @Override
    public final StringValue appendByte(int v) {
        if (this._buffer.length < this._length + 1) {
            this.ensureCapacity(this._length + 1);
        }
        this._buffer[this._length++] = (byte)v;
        return this;
    }

    @Override
    public final StringValue append(boolean v) {
        return this.append(v ? "true" : "false");
    }

    @Override
    public StringValue append(long v) {
        return this.append(String.valueOf(v));
    }

    @Override
    public StringValue append(double v) {
        return this.append(String.valueOf(v));
    }

    @Override
    public StringValue appendBytes(String s) {
        int sublen = s.length();
        if (this._buffer.length < this._length + sublen) {
            this.ensureCapacity(this._length + sublen);
        }
        for (int i = 0; i < sublen; ++i) {
            this._buffer[this._length++] = (byte)s.charAt(i);
        }
        return this;
    }

    @Override
    public final StringValue appendBytes(byte[] bytes, int offset, int end) {
        int len = end - offset;
        if (this._buffer.length < this._length + len) {
            this.ensureCapacity(this._length + len);
        }
        System.arraycopy(bytes, offset, this._buffer, this._length, len);
        this._length += len;
        return this;
    }

    @Override
    public StringValue append(Reader reader, long length) throws IOException {
        TempCharBuffer tempBuf = TempCharBuffer.allocate();
        char[] buffer = tempBuf.getBuffer();
        int sublen = (int)Math.min((long)buffer.length, length);
        try {
            while (length > 0L) {
                int count;
                if (this._buffer.length < this._length + sublen) {
                    this.ensureCapacity(this._length + sublen);
                }
                if ((count = reader.read(buffer, 0, sublen)) <= 0) {
                    break;
                }
                this.append(buffer, 0, count);
                length -= (long)count;
            }
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
        finally {
            TempCharBuffer.free(tempBuf);
        }
        return this;
    }

    public final byte[] getBuffer() {
        return this._buffer;
    }

    public int getOffset() {
        return this._length;
    }

    public void setOffset(int offset) {
        this._length = offset;
    }

    public int getBufferLength() {
        return this._buffer.length;
    }

    @Override
    public boolean isset(Value indexV) {
        int index = indexV.toInt();
        return 0 <= index && index < this._length;
    }

    @Override
    public void print(Env env) {
        env.write(this._buffer, 0, this._length);
    }

    @Override
    public void print(Env env, WriteStream out) {
        try {
            out.write(this._buffer, 0, this._length);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    @Override
    public void serialize(Env env, StringBuilder sb) {
        sb.append("s:");
        sb.append(this._length);
        sb.append(":\"");
        for (int i = 0; i < this._length; ++i) {
            sb.append((char)(this._buffer[i] & 0xFF));
        }
        sb.append("\";");
    }

    @Override
    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        int length = this.length();
        sb.append("binary(");
        sb.append(length);
        sb.append(") \"");
        int appendLength = length < 256 ? length : 256;
        for (int i = 0; i < appendLength; ++i) {
            sb.append(this.charAt(i));
        }
        if (length > 256) {
            sb.append(" ...");
        }
        sb.append('\"');
        return sb.toString();
    }

    @Override
    public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        int length = this.length();
        if (length < 0) {
            length = 0;
        }
        out.print("string(");
        out.print(length);
        out.print(") \"");
        out.write(this._buffer, 0, this._length);
        out.print("\"");
    }

    public OutputStream getOutputStream() {
        return new BuilderOutputStream();
    }

    @Override
    public long getCrc32Value() {
        CRC32 crc = new CRC32();
        crc.update(this._buffer, 0, this._length);
        return crc.getValue() & 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public void ensureAppendCapacity(int newCapacity) {
        this.ensureCapacity(this._length + newCapacity);
    }

    protected void ensureCapacity(int newCapacity) {
        int bufferLength = this._buffer.length;
        if (newCapacity <= bufferLength) {
            return;
        }
        if (bufferLength < 32) {
            bufferLength = 32;
        }
        while (bufferLength <= newCapacity) {
            bufferLength = 2 * bufferLength;
        }
        byte[] buffer = new byte[bufferLength];
        System.arraycopy(this._buffer, 0, buffer, 0, this._length);
        this._buffer = buffer;
        this._isCopy = false;
    }

    @Override
    public int hashCode() {
        int hash = this._hashCode;
        if (hash != 0) {
            return hash;
        }
        hash = 37;
        int length = this._length;
        byte[] buffer = this._buffer;
        if (length > 256) {
            int i;
            for (i = 127; i >= 0; --i) {
                hash = 65521 * hash + buffer[i];
            }
            for (i = length - 128; i < length; ++i) {
                hash = 65521 * hash + buffer[i];
            }
            this._hashCode = hash;
            return hash;
        }
        for (int i = length - 1; i >= 0; --i) {
            hash = 65521 * hash + buffer[i];
        }
        this._hashCode = hash;
        return hash;
    }

    @Override
    public int hashCodeCaseInsensitive() {
        int hash = 0;
        if (hash != 0) {
            return hash;
        }
        hash = 37;
        int length = this._length;
        byte[] buffer = this._buffer;
        if (length > 256) {
            int i;
            for (i = 127; i >= 0; --i) {
                hash = 65521 * hash + this.toLower(buffer[i]);
            }
            for (i = length - 128; i < length; ++i) {
                hash = 65521 * hash + this.toLower(buffer[i]);
            }
            this._hashCode = hash;
            return hash;
        }
        for (int i = length - 1; i >= 0; --i) {
            int ch = this.toLower(buffer[i]);
            hash = 65521 * hash + ch;
        }
        return hash;
    }

    private int toLower(int ch) {
        if (65 <= ch && ch <= 90) {
            return ch + 97 - 65;
        }
        return ch;
    }

    @Override
    public int getHashCode() {
        return this.hashCode();
    }

    @Override
    public boolean eq(Value rValue) {
        ValueType typeB = (rValue = rValue.toValue()).getValueType();
        if (typeB.isNumber()) {
            double r;
            double l = this.toDouble();
            return l == (r = rValue.toDouble());
        }
        if (typeB.isBoolean()) {
            return this.toBoolean() == rValue.toBoolean();
        }
        ValueType typeA = this.getValueType();
        if (typeA.isNumberCmp() && typeB.isNumberCmp()) {
            double r;
            double l = this.toDouble();
            return l == (r = rValue.toDouble());
        }
        if (rValue instanceof StringBuilderValue) {
            StringBuilderValue value = (StringBuilderValue)rValue;
            int length = this._length;
            if (length != value._length) {
                return false;
            }
            byte[] bufferA = this._buffer;
            byte[] bufferB = value._buffer;
            for (int i = length - 1; i >= 0; --i) {
                if (bufferA[i] == bufferB[i]) continue;
                return false;
            }
            return true;
        }
        String rString = rValue.toString();
        int len = rString.length();
        if (this._length != len) {
            return false;
        }
        for (int i = len - 1; i >= 0; --i) {
            if (this._buffer[i] == rString.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof StringBuilderValue) {
            StringBuilderValue value = (StringBuilderValue)o;
            int length = this._length;
            if (length != value._length) {
                return false;
            }
            byte[] bufferA = this._buffer;
            byte[] bufferB = value._buffer;
            for (int i = length - 1; i >= 0; --i) {
                if (bufferA[i] == bufferB[i]) continue;
                return false;
            }
            return true;
        }
        if (o instanceof LargeStringBuilderValue) {
            int length = this._length;
            StringValue value = (StringValue)o;
            int lengthB = value.length();
            if (length != lengthB) {
                return false;
            }
            byte[] bufferA = this._buffer;
            for (int i = length - 1; i >= 0; --i) {
                if (bufferA[i] == value.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean eql(Value o) {
        if ((o = o.toValue()) == this) {
            return true;
        }
        if (o instanceof StringBuilderValue) {
            StringBuilderValue value = (StringBuilderValue)o;
            int length = this._length;
            if (length != value._length) {
                return false;
            }
            byte[] bufferA = this._buffer;
            byte[] bufferB = value._buffer;
            for (int i = length - 1; i >= 0; --i) {
                if (bufferA[i] == bufferB[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this._length);
        out.write(this._buffer, 0, this._length);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        this._length = in.readInt();
        this._buffer = new byte[this._length];
        in.read(this._buffer, 0, this._length);
    }

    static {
        for (int i = 0; i < CHAR_STRINGS.length; ++i) {
            StringBuilderValue.CHAR_STRINGS[i] = new ConstStringValue((char)i);
        }
    }

    class BuilderOutputStream
    extends OutputStream {
        BuilderOutputStream() {
        }

        public void write(int ch) {
            StringBuilderValue.this.appendByte(ch);
        }

        public void write(byte[] buffer, int offset, int length) {
            StringBuilderValue.this.append(buffer, offset, length);
        }
    }

    class BuilderInputStream
    extends InputStream {
        private int _index;

        BuilderInputStream() {
        }

        public int read() {
            if (this._index < StringBuilderValue.this._length) {
                return StringBuilderValue.this._buffer[this._index++] & 0xFF;
            }
            return -1;
        }

        public int read(byte[] buffer, int offset, int length) {
            int sublen = Math.min(StringBuilderValue.this._length - this._index, length);
            if (sublen <= 0) {
                return -1;
            }
            System.arraycopy(StringBuilderValue.this._buffer, this._index, buffer, offset, sublen);
            this._index += sublen;
            return sublen;
        }
    }

    class BinaryInputStream
    extends InputStream {
        private int _offset;

        BinaryInputStream() {
        }

        public int read() {
            if (this._offset < StringBuilderValue.this._length) {
                return StringBuilderValue.this._buffer[this._offset++] & 0xFF;
            }
            return -1;
        }

        public int read(byte[] buffer, int offset, int length) {
            int sublen = Math.min(StringBuilderValue.this._length - this._offset, length);
            if (sublen <= 0) {
                return -1;
            }
            System.arraycopy(StringBuilderValue.this._buffer, this._offset, buffer, offset, sublen);
            this._offset += sublen;
            return sublen;
        }
    }
}

