/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.expr.VarVarExpr;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFieldVarExpr
extends AbstractVarExpr {
    private static final L10N L = new L10N(ClassFieldVarExpr.class);
    protected final String _className;
    protected final Expr _varName;
    private StringValue _prefix;

    public ClassFieldVarExpr(String className, Expr varName) {
        this._className = className;
        this._varName = varName;
        this._prefix = new StringBuilderValue(this._className).append("::");
    }

    @Override
    public Expr createCall(QuercusParser parser, Location location, ArrayList<Expr> args) throws IOException {
        ExprFactory factory = parser.getExprFactory();
        VarVarExpr var = factory.createVarVar(this._varName);
        return factory.createClassMethodCall(location, this._className, (Expr)var, args);
    }

    @Override
    public Value eval(Env env) {
        StringValue varName = this._varName.evalStringValue(env);
        StringValue var = this._prefix.toStringBuilder().append(varName);
        return env.getStaticValue(var);
    }

    @Override
    public Var evalVar(Env env) {
        StringValue varName = this._varName.evalStringValue(env);
        StringValue var = this._prefix.toStringBuilder().append(varName);
        return env.getStaticVar(var);
    }

    @Override
    public Value evalAssignRef(Env env, Value value) {
        StringValue varName = this._varName.evalStringValue(env);
        StringValue var = this._prefix.toStringBuilder().append(varName);
        env.setStaticRef(var, value);
        return value;
    }

    @Override
    public void evalUnset(Env env) {
        env.error(this.getLocation(), L.l("{0}::${1}: Cannot unset static variables.", (Object)this._className, this._varName));
    }

    @Override
    public String toString() {
        return this._className + "::$" + this._varName;
    }
}

