/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.MethodIntern;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.AbstractMethodExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.util.L10N;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassMethodExpr
extends AbstractMethodExpr {
    private static final L10N L = new L10N(ClassMethodExpr.class);
    protected final String _className;
    protected final StringValue _methodName;
    protected final int _hash;
    protected final Expr[] _args;
    protected boolean _isMethod;

    public ClassMethodExpr(Location location, String className, String methodName, ArrayList<Expr> args) {
        super(location);
        this._className = className.intern();
        this._methodName = MethodIntern.intern(methodName);
        this._hash = this._methodName.hashCodeCaseInsensitive();
        this._args = new Expr[args.size()];
        args.toArray(this._args);
    }

    public ClassMethodExpr(Location location, String className, String methodName, Expr[] args) {
        super(location);
        this._className = className.intern();
        this._methodName = MethodIntern.intern(methodName);
        this._hash = this._methodName.hashCodeCaseInsensitive();
        this._args = args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value eval(Env env) {
        Value oldThis;
        QuercusClass cl = env.findClass(this._className);
        if (cl == null) {
            throw env.createErrorException(L.l("{0} is an unknown class", this._className));
        }
        Value[] values = ClassMethodExpr.evalArgs(env, this._args);
        Value qThis = oldThis = env.getThis();
        env.pushCall(this, cl, values);
        try {
            env.checkTimeout();
            Value value = cl.callMethod(env, qThis, this._methodName, this._hash, values);
            return value;
        }
        finally {
            env.popCall();
            env.setThis(oldThis);
        }
    }

    @Override
    public String toString() {
        return this._className + "::" + this._methodName + "()";
    }
}

