/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.AbstractMethodExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.util.L10N;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassMethodVarExpr
extends AbstractMethodExpr {
    private static final L10N L = new L10N(ClassMethodVarExpr.class);
    protected final String _className;
    protected final Expr _nameExpr;
    protected final Expr[] _args;
    protected Expr[] _fullArgs;
    protected AbstractFunction _fun;
    protected boolean _isMethod;

    public ClassMethodVarExpr(Location location, String className, Expr nameExpr, ArrayList<Expr> args) {
        super(location);
        this._className = className.intern();
        this._nameExpr = nameExpr;
        this._args = new Expr[args.size()];
        args.toArray(this._args);
    }

    public ClassMethodVarExpr(Location location, String className, Expr nameExpr, Expr[] args) {
        super(location);
        this._className = className.intern();
        this._nameExpr = nameExpr;
        this._args = args;
    }

    public ClassMethodVarExpr(String className, Expr nameExpr, ArrayList<Expr> args) {
        this(Location.UNKNOWN, className, nameExpr, args);
    }

    public ClassMethodVarExpr(String className, Expr nameExpr, Expr[] args) {
        this(Location.UNKNOWN, className, nameExpr, args);
    }

    @Override
    public Expr createRef(QuercusParser parser) {
        return parser.getFactory().createRef(this);
    }

    @Override
    public Expr createCopy(ExprFactory factory) {
        return factory.createCopy(this);
    }

    @Override
    public Value eval(Env env) {
        QuercusClass cl = env.findClass(this._className);
        if (cl == null) {
            env.error(this.getLocation(), L.l("no matching class {0}", this._className));
        }
        Value qThis = env.getThis();
        StringValue methodName = this._nameExpr.evalStringValue(env);
        Value[] args = ClassMethodVarExpr.evalArgs(env, this._args);
        int hash = methodName.hashCodeCaseInsensitive();
        return cl.callMethod(env, qThis, methodName, hash, args);
    }

    @Override
    public String toString() {
        return this._nameExpr + "()";
    }
}

