/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassVarConstExpr
extends Expr {
    private static final L10N L = new L10N(ClassVarConstExpr.class);
    protected final Expr _className;
    protected final String _name;

    public ClassVarConstExpr(Expr className, String name) {
        this._className = className;
        this._name = name.intern();
    }

    @Override
    public Expr createCall(QuercusParser parser, Location location, ArrayList<Expr> args) throws IOException {
        ExprFactory factory = parser.getExprFactory();
        return factory.createClassMethodCall(location, this._className, this._name, args);
    }

    @Override
    public Value eval(Env env) {
        String className = this._className.evalString(env);
        return env.getClass(className).getConstant(env, this._name);
    }

    @Override
    public String toString() {
        return this._className + "::" + this._name;
    }
}

