/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.quercus.statement.Statement;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Expr {
    private static final L10N L = new L10N(Expr.class);
    private static final Logger log = Logger.getLogger(Expr.class.getName());
    public static final int COMPILE_ARG_MAX = 5;
    private final Location _location;

    public Expr(Location location) {
        this._location = location;
    }

    public Expr() {
        this._location = Location.UNKNOWN;
    }

    public final Location getLocation() {
        return this._location;
    }

    public String getFileName() {
        if (this._location != Location.UNKNOWN) {
            return this._location.getFileName();
        }
        return null;
    }

    public int getLine() {
        return this._location.getLineNumber();
    }

    public String getFunctionLocation() {
        return "";
    }

    public String getLocationLine() {
        if (this._location != Location.UNKNOWN) {
            return this._location.getFileName() + ":" + this.getLine() + ": ";
        }
        return "";
    }

    public boolean isRef() {
        return false;
    }

    public boolean isConstant() {
        return this.isLiteral();
    }

    public boolean isLiteral() {
        return false;
    }

    public boolean isTrue() {
        return false;
    }

    public boolean isFalse() {
        return false;
    }

    public boolean isAssign() {
        return false;
    }

    public boolean canRead() {
        return true;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isLong() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isNumber() {
        return this.isLong() || this.isDouble();
    }

    public boolean isString() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isVar() {
        return false;
    }

    public Expr createAssign(QuercusParser parser, Expr value) throws IOException {
        String msg = L.l("{0} is an invalid left-hand side of an assignment.", this);
        if (parser != null) {
            throw parser.error(msg);
        }
        throw new IOException(msg);
    }

    public Expr createAssignFrom(QuercusParser parser, AbstractVarExpr leftHandSide) {
        ExprFactory factory = parser.getExprFactory();
        return factory.createAssign(leftHandSide, this);
    }

    public void assign(QuercusParser parser) throws IOException {
        String msg = L.l("{0} is an invalid left-hand side of an assignment.", this);
        if (parser != null) {
            throw parser.error(msg);
        }
        throw new IOException(msg);
    }

    public Expr createAssignRef(QuercusParser parser, Expr value) throws IOException {
        String msg = L.l("{0} is an invalid left-hand side of an assignment.", this);
        if (parser != null) {
            throw parser.error(msg);
        }
        throw new IOException(msg);
    }

    public Expr createRef(QuercusParser parser) throws IOException {
        return this;
    }

    public Expr createDeref(ExprFactory factory) throws IOException {
        return this;
    }

    public Expr createCopy(ExprFactory factory) {
        return this;
    }

    public Expr createFieldGet(ExprFactory factory, StringValue name) {
        return factory.createFieldGet(this, name);
    }

    public Expr createFieldGet(ExprFactory factory, Expr name) {
        return factory.createFieldVarGet(this, name);
    }

    public Expr createClassConst(QuercusParser parser, String name) {
        ExprFactory factory = parser.getExprFactory();
        return factory.createClassConst(this, name);
    }

    public Expr createClassField(QuercusParser parser, String name) {
        ExprFactory factory = parser.getExprFactory();
        return factory.createClassField(this, name);
    }

    public Expr createClassField(QuercusParser parser, Expr name) {
        ExprFactory factory = parser.getExprFactory();
        return factory.createClassField(this, name);
    }

    public Statement createUnset(ExprFactory factory, Location location) throws IOException {
        throw new IOException(L.l("{0} is an illegal value to unset", this));
    }

    public Expr createIsset(ExprFactory factory) throws IOException {
        throw new IOException(L.l("{0} is an illegal value to isset", this));
    }

    public Expr createCall(QuercusParser parser, Location location, ArrayList<Expr> args) throws IOException {
        ExprFactory factory = parser.getExprFactory();
        return factory.createVarFunction(location, this, args);
    }

    public Value evalConstant() {
        return null;
    }

    public Value evalConstantPrefix() {
        return this.evalConstant();
    }

    public Value evalConstantSuffix() {
        return this.evalConstant();
    }

    public abstract Value eval(Env var1);

    public Var evalVar(Env env) {
        return this.eval(env).toVar();
    }

    public Value evalValue(Env env) {
        return this.eval(env);
    }

    public Value evalRef(Env env) {
        return this.eval(env);
    }

    public Value evalCopy(Env env) {
        return this.eval(env);
    }

    public Value evalArg(Env env, boolean isTop) {
        return this.eval(env);
    }

    public Value evalTop(Env env) {
        return this.eval(env);
    }

    public Value evalDirty(Env env) {
        return this.eval(env);
    }

    public Value evalArray(Env env) {
        return this.eval(env);
    }

    public Value evalObject(Env env) {
        return this.eval(env);
    }

    public Value evalAssignValue(Env env, Value value) {
        throw new RuntimeException(L.l("{0} is an invalid left-hand side of an assignment.", this));
    }

    public Value evalAssignRef(Env env, Value value) {
        throw new RuntimeException(L.l("{0} is an invalid left-hand side of an assignment.", this));
    }

    public Value evalArrayAssign(Env env, Value index, Value value) {
        Var var = this.evalVar(env);
        return ((Value)var).put(index, value);
    }

    public Value evalPostIncrement(Env env, int incr) {
        Var value = this.evalVar(env);
        return ((Value)value).postincr(incr);
    }

    public Value evalPreIncrement(Env env, int incr) {
        Var value = this.evalVar(env);
        return ((Value)value).preincr(incr);
    }

    public String evalString(Env env) {
        Value value = this.eval(env);
        if (value.isObject()) {
            return value.toString(env).toString();
        }
        return value.toString();
    }

    public StringValue evalStringValue(Env env) {
        return this.eval(env).toStringValue(env);
    }

    public char evalChar(Env env) {
        return this.eval(env).toChar();
    }

    public boolean evalBoolean(Env env) {
        return this.eval(env).toBoolean();
    }

    public long evalLong(Env env) {
        return this.eval(env).toLong();
    }

    public double evalDouble(Env env) {
        return this.eval(env).toDouble();
    }

    public boolean evalIsset(Env env) {
        return this.eval(env).isset();
    }

    public void evalUnsetArray(Env env, Value index) {
        Value array = this.evalDirty(env);
        array.remove(index);
    }

    public static Value[] evalArgs(Env env, Expr[] exprs) {
        Value[] args = new Value[exprs.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = exprs[i].evalArg(env, true);
        }
        return args;
    }

    public void print(Env env) throws IOException {
        this.eval(env).print(env);
    }

    public String toString() {
        return "Expr[]";
    }
}

