/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;

public class LiteralExpr
extends Expr {
    private final Value _value;

    public LiteralExpr(Value value) {
        this._value = value;
    }

    protected Value getValue() {
        return this._value;
    }

    public boolean isLiteral() {
        return true;
    }

    public boolean isTrue() {
        if (this._value == BooleanValue.TRUE) {
            return true;
        }
        if (this._value instanceof LongValue) {
            return this._value.toLong() != 0L;
        }
        return false;
    }

    public boolean isFalse() {
        if (this._value == BooleanValue.FALSE) {
            return true;
        }
        if (this._value instanceof LongValue) {
            return this._value.toLong() == 0L;
        }
        return false;
    }

    public boolean isLong() {
        return this._value.isLongConvertible();
    }

    public boolean isDouble() {
        return this._value.isDoubleConvertible();
    }

    public boolean isBoolean() {
        return this._value.isBoolean();
    }

    public Value evalConstant() {
        return this._value;
    }

    public Value eval(Env env) {
        return this._value;
    }

    public String toString() {
        return this._value.toString();
    }
}

