/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectFieldExpr
extends AbstractVarExpr {
    private static final L10N L = new L10N(ObjectFieldExpr.class);
    protected final Expr _objExpr;
    protected final StringValue _name;

    public ObjectFieldExpr(Location location, Expr objExpr, StringValue name) {
        super(location);
        this._objExpr = objExpr;
        this._name = name;
    }

    public ObjectFieldExpr(Expr objExpr, StringValue name) {
        this._objExpr = objExpr;
        this._name = name;
    }

    @Override
    public Expr createCall(QuercusParser parser, Location location, ArrayList<Expr> args) throws IOException {
        ExprFactory factory = parser.getExprFactory();
        return factory.createMethodCall(location, this._objExpr, this._name.toString(), args);
    }

    @Override
    public Value eval(Env env) {
        Value obj = this._objExpr.eval(env);
        return obj.getField(env, this._name);
    }

    @Override
    public Var evalVar(Env env) {
        Value obj = this._objExpr.evalVar(env);
        obj = obj.toAutoObject(env);
        return obj.getFieldVar(env, this._name);
    }

    @Override
    public Value evalArg(Env env, boolean isTop) {
        Value value = this._objExpr.evalArg(env, false);
        return value.getFieldArg(env, this._name, isTop);
    }

    @Override
    public Value evalDirty(Env env) {
        Value obj = this._objExpr.eval(env);
        return obj.getFieldVar(env, this._name).toValue();
    }

    @Override
    public Value evalAssignRef(Env env, Value value) {
        Value obj = this._objExpr.evalVar(env);
        obj = obj.toAutoObject(env);
        obj.putField(env, this._name, value);
        return value;
    }

    @Override
    public Value evalPostIncrement(Env env, int incr) {
        Value obj = this._objExpr.evalObject(env);
        Value value = obj.getField(env, this._name);
        value = value.postincr(incr);
        obj.putField(env, this._name, value);
        return value;
    }

    @Override
    public Value evalPreIncrement(Env env, int incr) {
        Value obj = this._objExpr.evalObject(env);
        Value value = obj.getField(env, this._name);
        value = value.preincr(incr);
        obj.putField(env, this._name, value);
        return value;
    }

    @Override
    public Value evalArray(Env env) {
        Value obj = this._objExpr.evalObject(env);
        return obj.getFieldArray(env, this._name);
    }

    @Override
    public Value evalObject(Env env) {
        Value obj = this._objExpr.evalObject(env);
        return obj.getFieldObject(env, this._name);
    }

    @Override
    public void evalUnset(Env env) {
        Value obj = this._objExpr.eval(env);
        obj.unsetField(this._name);
    }

    @Override
    public void evalUnsetArray(Env env, Value index) {
        Value obj = this._objExpr.eval(env);
        obj.unsetArray(env, this._name, index);
    }

    @Override
    public String toString() {
        return this._objExpr + "->" + this._name;
    }
}

