/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.Location;
import com.caucho.quercus.QuercusException;
import com.caucho.quercus.annotation.ClassImplementation;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.This;
import com.caucho.quercus.env.ConstStringValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.ErrorModule;
import java.util.Iterator;

@ClassImplementation
public class ExceptionClass {
    private static final StringValue MESSAGE = new ConstStringValue("message");
    private static final StringValue FUNCTION = new ConstStringValue("function");
    private static final StringValue FILE = new ConstStringValue("file");
    private static final StringValue LINE = new ConstStringValue("line");
    private static final StringValue CODE = new ConstStringValue("code");
    private static final StringValue TRACE = new ConstStringValue("trace");
    private static final StringValue JAVA_EXCEPTION = new ConstStringValue("__javaException");

    public static Value __construct(Env env, @This ObjectValue value, @Optional StringValue message, @Optional(value="0") int code) {
        value.putField(env, "message", (Value)message);
        value.putField(env, "code", (Value)LongValue.create(code));
        Location location = env.getLocation();
        if (location != null) {
            if (location.getFileName() != null) {
                value.putField(env, "file", (Value)env.createString(location.getFileName()));
            } else {
                value.putField(env, "file", (Value)env.createString("unknown"));
            }
            value.putField(env, "line", (Value)LongValue.create(location.getLineNumber()));
        }
        value.putField(env, "trace", ErrorModule.debug_backtrace(env));
        QuercusException e = new QuercusException();
        e.fillInStackTrace();
        value.putField(env, "_quercusException", env.wrapJava(e));
        return value;
    }

    public static Value __toString(Env env, @This ObjectValue value) {
        StringValue sb = env.createUnicodeBuilder();
        sb.append("ExceptionClass[" + value.getName() + "]\n");
        sb.append(ExceptionClass.getMessage(env, value));
        sb.append("\n");
        sb.append(ExceptionClass.getTraceAsString(env, value));
        sb.append("\n");
        return sb;
    }

    public static Value getMessage(Env env, @This ObjectValue obj) {
        return obj.getField(env, MESSAGE);
    }

    public static Value getCode(Env env, @This ObjectValue obj) {
        return obj.getField(env, CODE);
    }

    public static Value getFile(Env env, @This ObjectValue obj) {
        return obj.getField(env, FILE);
    }

    public static Value getLine(Env env, @This ObjectValue obj) {
        return obj.getField(env, LINE);
    }

    public static Value getTrace(Env env, @This Value obj) {
        return obj.getField(env, TRACE);
    }

    public static Value getJavaException(Env env, @This Value obj) {
        return obj.getField(env, JAVA_EXCEPTION);
    }

    public static Value getTraceAsString(Env env, @This Value obj) {
        Value trace = ExceptionClass.getTrace(env, obj);
        StringValue sb = env.createUnicodeBuilder();
        sb.append("<trace>");
        Iterator<Value> iter = trace.getValueIterator(env);
        while (iter.hasNext()) {
            Value value = iter.next();
            sb = sb.append('\n');
            sb = sb.append(value.get(FILE));
            sb = sb.append(':');
            sb = sb.append(value.get(LINE));
            sb = sb.append(": ");
            sb = sb.append(value.get(FUNCTION));
        }
        return sb;
    }
}

