/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.annotation.VariableArguments;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Callable;
import com.caucho.quercus.env.CallbackFunction;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;

public class FunctionModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(FunctionModule.class);
    private static final Logger log = Logger.getLogger(FunctionModule.class.getName());

    public static Value call_user_func(Env env, Callable function, Value[] args) {
        return function.call(env, args).copyReturn();
    }

    public static Value call_user_func_array(Env env, Callable function, Value arg) {
        Value[] args;
        if (function == null) {
            env.warning("call_user_func_array: first argument is not a valid function");
            return NullValue.NULL;
        }
        ArrayValue argArray = arg.isArray() ? (ArrayValue)arg.toArray() : new ArrayValueImpl().append(arg);
        if (argArray != null) {
            args = new Value[argArray.getSize()];
            int i = 0;
            for (Map.Entry<Value, Value> entry : argArray.entrySet()) {
                ArrayValue.Entry arrayEntry = (ArrayValue.Entry)entry;
                args[i++] = arrayEntry.getRawValue();
            }
        } else {
            args = new Value[]{};
        }
        return function.call(env, args).copyReturn();
    }

    public static Value create_function(Env env, String args, String code) {
        try {
            AbstractFunction fun = env.createAnonymousFunction(args, code);
            return new CallbackFunction(fun, fun.getName());
        }
        catch (IOException e) {
            env.warning(e.getMessage());
            return BooleanValue.FALSE;
        }
    }

    @VariableArguments
    public static Value func_get_arg(Env env, int index) {
        Value[] args = env.getFunctionArgs();
        if (0 <= index && index < args.length) {
            return args[index];
        }
        return NullValue.NULL;
    }

    @VariableArguments
    public static Value func_get_args(Env env) {
        Value[] args = env.getFunctionArgs();
        ArrayValueImpl result = new ArrayValueImpl();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                ((ArrayValue)result).put(args[i]);
            }
        }
        return result;
    }

    @VariableArguments
    public static Value func_num_args(Env env) {
        Value[] args = env.getFunctionArgs();
        if (args != null && args.length > 0) {
            return LongValue.create(args.length);
        }
        return LongValue.ZERO;
    }

    public static boolean function_exists(Env env, String name) {
        return name != null && env.findFunction(name) != null;
    }

    public static Value get_defined_functions(Env env) {
        return env.getDefinedFunctions();
    }

    public static Value register_shutdown_function(Env env, Callable fun, Value[] args) {
        env.addShutdown(fun, args);
        return NullValue.NULL;
    }
}

