/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.quercus.program.JavaClassDef;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaModule
extends AbstractQuercusModule {
    private static final Logger log = Logger.getLogger(JavaModule.class.getName());
    private static final L10N L = new L10N(JavaModule.class);

    public static Object java(Env env, String className, Value[] args) {
        try {
            JavaClassDef def = env.getJavaClassDefinition(className);
            if (def == null) {
                env.warning(L.l("could not find Java class {0}", className));
                return null;
            }
            Value newObj = def.callNew(env, args);
            if (newObj.isNull()) {
                return new JavaValue(env, null, def);
            }
            return newObj;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(e);
            return null;
        }
    }

    public static Object java_class(Env env, String className) {
        try {
            JavaClassDef def = env.getJavaClassDefinition(className);
            if (def == null) {
                env.warning(L.l("could not find Java class {0}", className));
                return null;
            }
            return new JavaValue(env, def.getType(), def);
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(e);
            return null;
        }
    }

    public static String get_java_class_name(Env env, Value value) {
        if (value instanceof JavaValue) {
            Object obj = value.toJavaObject();
            if (obj == null) {
                return String.valueOf(null);
            }
            return obj.getClass().getName();
        }
        return value.getClass().getName();
    }
}

