/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.curl;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.lib.curl.CurlResource;
import com.caucho.quercus.lib.curl.HttpConnection;
import com.caucho.quercus.lib.curl.HttpRequest;
import com.caucho.quercus.lib.curl.PostBody;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ProtocolException;

public class HttpPostRequest
extends HttpRequest {
    private PostBody _body;

    public HttpPostRequest(CurlResource curlResource) {
        super(curlResource);
    }

    protected boolean init(Env env) throws ProtocolException {
        if (!super.init(env)) {
            return false;
        }
        CurlResource curl = this.getCurlResource();
        this._body = PostBody.create(env, curl.getPostBody());
        if (this._body == null) {
            return false;
        }
        HttpConnection conn = this.getHttpConnection();
        conn.setRequestProperty("Content-Type", this._body.getContentType());
        conn.setRequestProperty("Content-Length", String.valueOf(this._body.getContentLength()));
        conn.setDoOutput(true);
        return true;
    }

    protected void transfer(Env env) throws IOException {
        super.transfer(env);
        HttpConnection conn = this.getHttpConnection();
        OutputStream out = conn.getOutputStream();
        this._body.writeTo(env, out);
    }
}

