/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.date;

import com.caucho.quercus.UnimplementedException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.lib.date.DateModule;
import com.caucho.quercus.lib.date.DateTimeZone;
import com.caucho.util.QDate;

public class DateTime {
    public static final String ATOM = "Y-m-d\\TH:i:sP";
    public static final String COOKIE = "l, d-M-y H:i:s T";
    public static final String ISO8601 = "Y-m-d\\TH:i:sO";
    public static final String RFC822 = "D, d M y H:i:s O";
    public static final String RFC850 = "l, d-M-y H:i:s T";
    public static final String RFC1036 = "D, d M y H:i:s O";
    public static final String RFC1123 = "D, d M Y H:i:s O";
    public static final String RFC2822 = "D, d M Y H:i:s O";
    public static final String RFC3339 = "Y-m-d\\TH:i:sP";
    public static final String RSS = "D, d M Y H:i:s O";
    public static final String W3C = "Y-m-d\\TH:i:sP";
    private QDate _qDate;
    private DateTimeZone _dateTimeZone;

    protected DateTime(Env env, String timeString) {
        this(env, timeString, new DateTimeZone(env));
    }

    protected DateTime(Env env, String timeString, DateTimeZone dateTimeZone) {
        this._qDate = new QDate(dateTimeZone.getTimeZone(), env.getCurrentTime());
        this._dateTimeZone = dateTimeZone;
        this.init(env, timeString);
    }

    private void init(Env env, String timeString) {
        long now = env.getCurrentTime();
        this._qDate.setGMTTime(now);
        if (timeString.equals("")) {
            this._qDate.setHour(0);
            this._qDate.setMinute(0);
            this._qDate.setSecond(0);
        }
        DateModule.DateParser parser = new DateModule.DateParser(timeString, this._qDate);
        long time = parser.parse();
        this._qDate.setGMTTime(time);
    }

    public static DateTime __construct(Env env, @Optional(value="now") String time, @Optional DateTimeZone timeZone) {
        if (timeZone == null) {
            return new DateTime(env, time);
        }
        return new DateTime(env, time, timeZone);
    }

    public String format(String format) {
        long time = this._qDate.getGMTTime() / 1000L;
        QDate calendar = new QDate(this._qDate.getLocalTimeZone());
        return DateModule.dateImpl(format, time, calendar);
    }

    public void modify(String modify) {
        DateModule.DateParser parser = new DateModule.DateParser(modify, this._qDate);
        long time = parser.parse();
        this.setTime(time);
    }

    public DateTimeZone getTimeZone() {
        return this._dateTimeZone;
    }

    public void setTimeZone(Env env, DateTimeZone dateTimeZone) {
        this._dateTimeZone = dateTimeZone;
        long time = this._qDate.getGMTTime();
        this._qDate = new QDate(dateTimeZone.getTimeZone(), env.getCurrentTime());
        this._qDate.setGMTTime(time);
    }

    public long getOffset() {
        return this._qDate.getZoneOffset() / 1000L;
    }

    public void setTime(int hour, int minute, @Optional int second) {
        this._qDate.setTime(hour, minute, second, 0L);
    }

    public void setDate(int year, int month, int day) {
        this._qDate.setDate(year, month - 1, day);
    }

    public void setISODate(int year, int week, @Optional int day) {
        throw new UnimplementedException("DateTime::setISODate()");
    }

    protected QDate getQDate() {
        return this._qDate;
    }

    protected long getTime() {
        return this._qDate.getLocalTime();
    }

    protected void setTime(long time) {
        this._qDate.setLocalTime(time);
    }

    public String toString() {
        return this.format("now");
    }
}

