/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.Reference;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.db.JdbcResultResource;
import com.caucho.quercus.lib.db.Mysqli;
import com.caucho.quercus.lib.db.MysqliResult;
import com.caucho.quercus.lib.db.MysqliStatement;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MysqliModule
extends AbstractQuercusModule {
    private static final Logger log = Log.open(MysqliModule.class);
    private static final L10N L = new L10N(MysqliModule.class);
    public static final int MYSQLI_ASSOC = 1;
    public static final int MYSQLI_NUM = 2;
    public static final int MYSQLI_BOTH = 3;
    public static final int MYSQLI_USE_RESULT = 0;
    public static final int MYSQLI_STORE_RESULT = 1;
    public static final int NOT_NULL_FLAG = 1;
    public static final int PRI_KEY_FLAG = 2;
    public static final int UNIQUE_KEY_FLAG = 4;
    public static final int MULTIPLE_KEY_FLAG = 8;
    public static final int BLOB_FLAG = 16;
    public static final int UNSIGNED_FLAG = 32;
    public static final int ZEROFILL_FLAG = 64;
    public static final int BINARY_FLAG = 128;
    public static final int ENUM_FLAG = 256;
    public static final int AUTO_INCREMENT_FLAG = 512;
    public static final int TIMESTAMP_FLAG = 1024;
    public static final int SET_FLAG = 2048;
    public static final int NUM_FLAG = 32768;
    public static final int PART_KEY_FLAG = 16384;
    public static final int GROUP_FLAG = 32768;
    public static final int UNIQUE_FLAG = 65536;
    public static final int BINCMP_FLAG = 131072;
    public static final int MYSQLI_TYPE_DECIMAL = 0;
    public static final int MYSQLI_TYPE_TINY = 1;
    public static final int MYSQLI_TYPE_SHORT = 2;
    public static final int MYSQLI_TYPE_LONG = 3;
    public static final int MYSQLI_TYPE_FLOAT = 4;
    public static final int MYSQLI_TYPE_DOUBLE = 5;
    public static final int MYSQLI_TYPE_NULL = 6;
    public static final int MYSQLI_TYPE_TIMESTAMP = 7;
    public static final int MYSQLI_TYPE_LONGLONG = 8;
    public static final int MYSQLI_TYPE_INT24 = 9;
    public static final int MYSQLI_TYPE_DATE = 10;
    public static final int MYSQLI_TYPE_TIME = 11;
    public static final int MYSQLI_TYPE_DATETIME = 12;
    public static final int MYSQLI_TYPE_YEAR = 13;
    public static final int MYSQLI_TYPE_NEWDATE = 14;
    public static final int MYSQLI_TYPE_BIT = 16;
    public static final int MYSQLI_TYPE_NEWDECIMAL = 246;
    public static final int MYSQLI_TYPE_ENUM = 247;
    public static final int MYSQLI_TYPE_SET = 248;
    public static final int MYSQLI_TYPE_TINY_BLOB = 249;
    public static final int MYSQLI_TYPE_MEDIUM_BLOB = 250;
    public static final int MYSQLI_TYPE_LONG_BLOB = 251;
    public static final int MYSQLI_TYPE_BLOB = 252;
    public static final int MYSQLI_TYPE_VAR_STRING = 253;
    public static final int MYSQLI_TYPE_STRING = 254;
    public static final int MYSQLI_TYPE_GEOMETRY = 255;
    public static final int MYSQLI_TYPE_CHAR = 1;
    public static final int MYSQLI_TYPE_INTERVAL = 247;
    public static final int MYSQL_CLIENT_COMPRESS = 32;
    private static final int MYSQL_CLIENT_LOCAL_FILES = 128;
    public static final int MYSQL_CLIENT_IGNORE_SPACE = 256;
    public static final int MYSQL_CLIENT_INTERACTIVE = 1024;
    public static final int MYSQL_CLIENT_SSL = 2048;
    public static final int MYSQLI_READ_DEFAULT_GROUP = 0;
    public static final int MYSQLI_READ_DEFAULT_FILE = 1;
    public static final int MYSQLI_OPT_CONNECT_TIMEOUT = 2;
    public static final int MYSQLI_OPT_LOCAL_INFILE = 3;
    public static final int MYSQLI_INIT_COMMAND = 4;

    public String[] getLoadedExtensions() {
        return new String[]{"mysqli"};
    }

    public static int mysqli_affected_rows(@NotNull Mysqli conn) {
        if (conn == null) {
            return -1;
        }
        return conn.affected_rows();
    }

    public static boolean mysqli_autocommit(@NotNull Mysqli conn, boolean mode) {
        if (conn == null) {
            return false;
        }
        return conn.autocommit(mode);
    }

    public static boolean mysqli_bind_param(Env env, @NotNull MysqliStatement stmt, StringValue types, @Reference Value[] params) {
        return MysqliModule.mysqli_stmt_bind_param(env, stmt, types, params);
    }

    public static boolean mysqli_commit(@NotNull Mysqli conn) {
        if (conn == null) {
            return false;
        }
        return conn.commit();
    }

    public static Value mysqli_character_set_name(Env env, @NotNull Mysqli conn) {
        if (conn == null) {
            return NullValue.NULL;
        }
        return conn.character_set_name(env);
    }

    public static Value mysqli_client_encoding(Env env, @NotNull Mysqli conn) {
        return MysqliModule.mysqli_character_set_name(env, conn);
    }

    public static boolean mysqli_close(Env env, @NotNull Mysqli conn) {
        if (conn == null) {
            return false;
        }
        if (!conn.isConnected()) {
            env.warning(L.l("no MySQLi-Link resource supplied"));
            return false;
        }
        return conn.close(env);
    }

    @ReturnNullAsFalse
    public static Mysqli mysqli_connect(Env env, @Optional(value="localhost") StringValue host, @Optional StringValue userName, @Optional StringValue password, @Optional String dbname, @Optional(value="3306") int port, @Optional StringValue socket) throws IllegalStateException {
        Mysqli mysqli = new Mysqli(env, host, userName, password, dbname, port, socket);
        if (!mysqli.isConnected()) {
            return null;
        }
        return mysqli;
    }

    public static int mysqli_connect_errno(Env env) {
        Value value = (Value)env.getSpecialValue("mysqli.connectErrno");
        if (value != null) {
            return value.toInt();
        }
        return 0;
    }

    public static StringValue mysqli_connect_error(Env env) {
        Object error = env.getSpecialValue("mysqli.connectError");
        if (error != null) {
            return env.createString(error.toString());
        }
        return env.getEmptyString();
    }

    public static Value mysqli_data_seek(Env env, @NotNull MysqliResult result, int rowNumber) {
        if (result == null) {
            return NullValue.NULL;
        }
        if (result.seek(env, rowNumber)) {
            return BooleanValue.TRUE;
        }
        env.warning(L.l("Offset {0} is invalid for MySQL (or the query data is unbuffered)", rowNumber));
        return BooleanValue.FALSE;
    }

    public static Value mysqli_errno(@NotNull Mysqli conn) {
        if (conn == null) {
            return NullValue.NULL;
        }
        return LongValue.create(conn.errno());
    }

    public static Value mysqli_escape_string(Env env, @NotNull Mysqli conn, StringValue unescapedString) {
        return MysqliModule.mysqli_real_escape_string(env, conn, unescapedString);
    }

    public static Value mysqli_fetch(Env env, MysqliStatement stmt) {
        return MysqliModule.mysqli_stmt_fetch(env, stmt);
    }

    public static Value mysqli_fetch_field_direct(Env env, @NotNull MysqliResult result, int fieldOffset) {
        if (result == null) {
            return BooleanValue.FALSE;
        }
        return result.fetch_field_direct(env, fieldOffset);
    }

    public static Value mysqli_fetch_field(Env env, @NotNull MysqliResult result) {
        if (result == null) {
            return BooleanValue.FALSE;
        }
        return result.fetch_field(env);
    }

    public static Value mysqli_fetch_fields(Env env, @NotNull MysqliResult result) {
        if (result == null) {
            return BooleanValue.FALSE;
        }
        return result.fetch_fields(env);
    }

    public static Value mysqli_fetch_lengths(Env env, @NotNull MysqliResult result) {
        if (result == null) {
            return NullValue.NULL;
        }
        return result.fetch_lengths();
    }

    public static boolean mysqli_field_seek(Env env, @NotNull MysqliResult result, int fieldOffset) {
        if (result == null) {
            return false;
        }
        return result.field_seek(env, fieldOffset);
    }

    public static int mysqli_field_tell(Env env, @NotNull MysqliResult result) {
        if (result == null) {
            return -1;
        }
        return result.field_tell(env);
    }

    public static boolean mysqli_free_result(@NotNull MysqliResult result) {
        if (result == null) {
            return false;
        }
        result.close();
        return true;
    }

    public static Value mysqli_insert_id(Env env, @NotNull Mysqli conn) {
        if (conn == null) {
            return BooleanValue.FALSE;
        }
        return conn.insert_id(env);
    }

    public static Value mysqli_num_fields(@NotNull MysqliResult result) {
        if (result == null) {
            return NullValue.NULL;
        }
        return LongValue.create(result.num_fields());
    }

    public static boolean mysqli_multi_query(Env env, @NotNull Mysqli conn, StringValue query) {
        if (conn == null) {
            return false;
        }
        return conn.multi_query(env, query);
    }

    public static boolean mysqli_more_results(@NotNull Mysqli conn) {
        if (conn == null) {
            return false;
        }
        return conn.more_results();
    }

    public static boolean mysqli_next_result(@NotNull Mysqli conn) {
        if (conn == null) {
            return false;
        }
        return conn.next_result();
    }

    public static int mysqli_stmt_errno(Env env, @NotNull MysqliStatement stmt) {
        if (stmt == null) {
            return 0;
        }
        return stmt.errno();
    }

    public static StringValue mysqli_stmt_error(Env env, @NotNull MysqliStatement stmt) {
        if (stmt == null) {
            return env.getEmptyString();
        }
        return stmt.error(env);
    }

    public static Value mysqli_error(Env env, @NotNull Mysqli conn) {
        if (conn == null) {
            return NullValue.NULL;
        }
        return conn.error(env);
    }

    public static int mysqli_field_count(@NotNull Mysqli conn) {
        if (conn == null) {
            return 0;
        }
        return conn.field_count();
    }

    @ReturnNullAsFalse
    public static ArrayValue mysqli_fetch_array(Env env, @NotNull MysqliResult result, @Optional(value="MYSQLI_BOTH") int type) {
        if (result == null) {
            return null;
        }
        return result.fetch_array(env, type);
    }

    @ReturnNullAsFalse
    public static ArrayValue mysqli_fetch_assoc(Env env, @NotNull MysqliResult result) {
        if (result == null) {
            return null;
        }
        return result.fetch_assoc(env);
    }

    public static ArrayValue mysqli_fetch_row(Env env, @NotNull MysqliResult result) {
        if (result == null) {
            return null;
        }
        return result.fetch_row(env);
    }

    public static Value mysqli_fetch_object(Env env, @NotNull MysqliResult result) {
        if (result == null) {
            return NullValue.NULL;
        }
        return result.fetch_object(env);
    }

    public static StringValue mysqli_get_client_info(Env env) {
        return Mysqli.getClientInfo(env);
    }

    public static int mysqli_get_client_version(Env env) {
        return Mysqli.infoToVersion(MysqliModule.mysqli_get_client_info(env).toString());
    }

    public static Value mysqli_get_host_info(Env env, @NotNull Mysqli conn) {
        if (conn == null) {
            return NullValue.NULL;
        }
        return conn.get_host_info(env);
    }

    public static Value mysqli_get_proto_info(@NotNull Mysqli conn) {
        if (conn == null) {
            return NullValue.NULL;
        }
        return LongValue.create(conn.get_proto_info());
    }

    public static Value mysqli_get_server_info(Env env, @NotNull Mysqli conn) {
        if (conn == null) {
            return NullValue.NULL;
        }
        if (conn.isConnected()) {
            return conn.get_server_info(env);
        }
        return NullValue.NULL;
    }

    public static Value mysqli_get_server_version(@NotNull Mysqli conn) {
        if (conn == null) {
            return NullValue.NULL;
        }
        return LongValue.create(conn.get_server_version());
    }

    public static Value mysqli_num_rows(Env env, @NotNull MysqliResult result) {
        if (result == null) {
            return NullValue.NULL;
        }
        return LongValue.create(result.num_rows());
    }

    public static boolean mysqli_options(@NotNull Mysqli mysqli, int option, Value value) {
        if (mysqli == null) {
            return false;
        }
        return mysqli.options(option, value);
    }

    public static boolean mysqli_set_opt(@NotNull Mysqli mysqli, int option, Value value) {
        return MysqliModule.mysqli_options(mysqli, option, value);
    }

    public static int mysqli_param_count(Env env, @NotNull MysqliStatement stmt) {
        return MysqliModule.mysqli_stmt_param_count(env, stmt);
    }

    public static boolean mysqli_rollback(@NotNull Mysqli conn) {
        if (conn == null) {
            return false;
        }
        return conn.rollback();
    }

    public static boolean mysqli_set_charset(@NotNull Mysqli mysqli, String charset) {
        if (mysqli == null) {
            return false;
        }
        return mysqli.set_charset(charset);
    }

    public static Value mysqli_stmt_num_rows(Env env, @NotNull MysqliStatement stmt) {
        if (stmt == null) {
            return BooleanValue.FALSE;
        }
        return stmt.num_rows(env);
    }

    public static int mysqli_stmt_param_count(Env env, @NotNull MysqliStatement stmt) {
        if (stmt == null) {
            return -1;
        }
        return stmt.param_count(env);
    }

    public static boolean mysqli_stmt_prepare(Env env, @NotNull MysqliStatement stmt, StringValue query) {
        if (stmt == null) {
            return false;
        }
        return stmt.prepare(env, query);
    }

    public static boolean mysqli_stmt_reset(Env env, @NotNull MysqliStatement stmt) {
        if (stmt == null) {
            return false;
        }
        return stmt.reset(env);
    }

    @ReturnNullAsFalse
    public static JdbcResultResource mysqli_stmt_result_metadata(Env env, @NotNull MysqliStatement stmt) {
        if (stmt == null) {
            return null;
        }
        return stmt.result_metadata(env);
    }

    public static Value mysqli_sqlstate(Env env, @NotNull Mysqli conn) {
        if (conn == null) {
            return NullValue.NULL;
        }
        return conn.sqlstate(env);
    }

    public static Value mysqli_stmt_sqlstate(Env env, @NotNull MysqliStatement stmt) {
        if (stmt == null) {
            return NullValue.NULL;
        }
        return stmt.sqlstate(env);
    }

    public static boolean mysqli_stmt_store_result(Env env, @NotNull MysqliStatement stmt) {
        if (stmt == null) {
            return false;
        }
        return stmt.store_result(env);
    }

    @ReturnNullAsFalse
    public static JdbcResultResource mysqli_store_result(Env env, @NotNull Mysqli conn) {
        if (conn == null) {
            return null;
        }
        return conn.store_result(env);
    }

    @ReturnNullAsFalse
    public static JdbcResultResource mysqli_use_result(Env env, @NotNull Mysqli conn) {
        if (conn == null) {
            return null;
        }
        return conn.use_result(env);
    }

    public static int mysqli_warning_count(Env env, @NotNull Mysqli conn) {
        if (conn == null) {
            return 0;
        }
        return conn.warning_count(env);
    }

    public static boolean mysqli_ping(Env env, @NotNull Mysqli conn) {
        if (conn == null) {
            return false;
        }
        return conn.ping(env);
    }

    public static Value mysqli_query(Env env, @NotNull Mysqli conn, StringValue sql, @Optional(value="MYSQLI_STORE_RESULT") int resultMode) {
        Value value = MysqliModule.query(env, conn, sql);
        if (value == null) {
            return BooleanValue.FALSE;
        }
        return value;
    }

    private static Value query(Env env, Mysqli conn, StringValue sql) {
        Value value = null;
        try {
            value = conn.query(env, sql, 1);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        if (value == null) {
            return BooleanValue.FALSE;
        }
        return value;
    }

    public static boolean mysqli_real_connect(Env env, @NotNull Mysqli mysqli, @Optional(value="localhost") StringValue host, @Optional StringValue userName, @Optional StringValue password, @Optional StringValue dbname, @Optional(value="3306") int port, @Optional StringValue socket, @Optional int flags) {
        if (mysqli == null) {
            return false;
        }
        return mysqli.real_connect(env, host, userName, password, dbname, port, socket, flags);
    }

    public static Value mysqli_real_escape_string(Env env, @NotNull Mysqli conn, StringValue unescapedString) {
        if (conn == null) {
            return NullValue.NULL;
        }
        if (unescapedString.length() == 0) {
            return env.getEmptyString();
        }
        StringBuilder buf = new StringBuilder();
        MysqliModule.escapeString(buf, unescapedString.toString());
        return env.createString(buf.toString());
    }

    static void escapeString(StringBuilder buf, String unescapedString) {
        int strLength = unescapedString.length();
        block9: for (int i = 0; i < strLength; ++i) {
            char c = unescapedString.charAt(i);
            switch (c) {
                case '\u0000': {
                    buf.append('\\');
                    buf.append('\u0000');
                    continue block9;
                }
                case '\n': {
                    buf.append('\\');
                    buf.append('n');
                    continue block9;
                }
                case '\r': {
                    buf.append('\\');
                    buf.append('r');
                    continue block9;
                }
                case '\\': {
                    buf.append('\\');
                    buf.append('\\');
                    continue block9;
                }
                case '\'': {
                    buf.append('\\');
                    buf.append('\'');
                    continue block9;
                }
                case '\"': {
                    buf.append('\\');
                    buf.append('\"');
                    continue block9;
                }
                case '\u001a': {
                    buf.append('\\');
                    buf.append('Z');
                    continue block9;
                }
                default: {
                    buf.append(c);
                }
            }
        }
    }

    public static boolean mysqli_real_query(Env env, @NotNull Mysqli conn, StringValue query) {
        if (conn == null) {
            return false;
        }
        return conn.real_query(env, query);
    }

    static Value mysqli_query(Env env, Mysqli conn, StringValue query, Object ... args) {
        StringBuilder buf = new StringBuilder();
        int size = query.length();
        int argIndex = 0;
        for (int i = 0; i < size; ++i) {
            char ch = buf.charAt(i);
            if (ch == '?') {
                Object arg;
                if ((arg = args[argIndex++]) == null) {
                    throw new IllegalArgumentException(L.l("argument `{0}' cannot be null", arg));
                }
                buf.append('\'');
                MysqliModule.escapeString(buf, String.valueOf(arg));
                buf.append('\'');
                continue;
            }
            buf.append(ch);
        }
        return MysqliModule.query(env, conn, env.createString(buf.toString()));
    }

    public static boolean mysqli_select_db(Mysqli conn, String dbName) {
        if (conn == null) {
            return false;
        }
        return conn.select_db(dbName);
    }

    public static Value mysqli_stat(Env env, @NotNull Mysqli conn) {
        if (conn == null) {
            return BooleanValue.FALSE;
        }
        return conn.stat(env);
    }

    public static int mysqli_stmt_affected_rows(Env env, @NotNull MysqliStatement stmt) {
        if (stmt == null) {
            return -1;
        }
        if (stmt.errno() != 0) {
            return -1;
        }
        return stmt.affected_rows(env);
    }

    public static boolean mysqli_stmt_bind_param(Env env, @NotNull MysqliStatement stmt, StringValue types, @Reference Value[] params) {
        if (stmt == null) {
            return false;
        }
        return stmt.bind_param(env, types, params);
    }

    public static boolean mysqli_stmt_bind_result(Env env, @NotNull MysqliStatement stmt, @Reference Value[] outParams) {
        if (stmt == null) {
            return false;
        }
        return stmt.bind_result(env, outParams);
    }

    public boolean mysql_stmt_close(MysqliStatement stmt) {
        if (stmt == null) {
            return false;
        }
        stmt.close();
        return true;
    }

    public Value mysqli_stmt_data_seek(Env env, @NotNull MysqliStatement stmt, int offset) {
        if (stmt == null) {
            return BooleanValue.FALSE;
        }
        return stmt.data_seek(env, offset);
    }

    public int mysql_stmt_errno(Env env, MysqliStatement stmt) {
        if (stmt != null) {
            return stmt.errno();
        }
        return 0;
    }

    public StringValue mysql_stmt_error(Env env, MysqliStatement stmt) {
        if (stmt == null) {
            return null;
        }
        return stmt.error(env);
    }

    public static boolean mysqli_stmt_execute(Env env, @NotNull MysqliStatement stmt) {
        if (stmt == null) {
            return false;
        }
        return stmt.execute(env);
    }

    public static Value mysqli_stmt_fetch(Env env, @NotNull MysqliStatement stmt) {
        if (stmt == null) {
            return BooleanValue.FALSE;
        }
        return stmt.fetch(env);
    }

    public static boolean mysqli_stmt_free_result(Env env, MysqliStatement stmt) {
        if (stmt == null) {
            return false;
        }
        stmt.free_result(env);
        return true;
    }

    public static boolean mysqli_bind_result(Env env, @NotNull MysqliStatement stmt, @Reference Value[] outParams) {
        return MysqliModule.mysqli_stmt_bind_result(env, stmt, outParams);
    }

    public static boolean mysqli_change_user(@NotNull Mysqli mysqli, String user, String password, String db) {
        if (mysqli == null) {
            return false;
        }
        return mysqli.change_user(user, password, db);
    }

    public static boolean mysqli_execute(Env env, @NotNull MysqliStatement stmt) {
        return MysqliModule.mysqli_stmt_execute(env, stmt);
    }

    @ReturnNullAsFalse
    public static JdbcResultResource mysqli_get_metadata(Env env, @NotNull MysqliStatement stmt) {
        return MysqliModule.mysqli_stmt_result_metadata(env, stmt);
    }

    public static Mysqli mysqli_init(Env env) {
        return new Mysqli(env);
    }

    @ReturnNullAsFalse
    public static MysqliStatement mysqli_prepare(Env env, @NotNull Mysqli conn, StringValue query) {
        if (conn == null) {
            return null;
        }
        return conn.prepare(env, query);
    }

    public static boolean mysqli_stmt_close(Env env, @NotNull MysqliStatement stmt) {
        if (stmt == null) {
            return false;
        }
        return stmt.close(env);
    }

    public static MysqliStatement mysqli_stmt_init(Env env, @NotNull Mysqli conn) {
        if (conn == null) {
            return null;
        }
        return conn.stmt_init(env);
    }

    public static Value mysqli_info(Env env, @Optional Mysqli conn) {
        if (conn == null) {
            return null;
        }
        return conn.info(env);
    }

    public static int mysqli_stmt_field_count(Env env, @NotNull MysqliStatement stmt) {
        if (stmt == null) {
            return -1;
        }
        return stmt.field_count(env);
    }

    public static Value mysqli_thread_id(Env env, @NotNull Mysqli conn) {
        if (conn == null) {
            return BooleanValue.FALSE;
        }
        return conn.thread_id(env);
    }

    public static boolean mysqli_kill(Env env, @NotNull Mysqli conn, int threadId) {
        if (conn == null) {
            return false;
        }
        return conn.kill(env, threadId);
    }
}

