/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.UnimplementedException;
import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.Reference;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.DefaultValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.db.JdbcConnectionResource;
import com.caucho.quercus.lib.db.JdbcResultResource;
import com.caucho.quercus.lib.db.Oracle;
import com.caucho.quercus.lib.db.OracleOciCollection;
import com.caucho.quercus.lib.db.OracleOciLob;
import com.caucho.quercus.lib.db.OracleStatement;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OracleModule
extends AbstractQuercusModule {
    private static final Logger log = Log.open(OracleModule.class);
    private static final L10N L = new L10N(OracleModule.class);
    public static final int OCI_B_BFILE = 1;
    public static final int OCI_B_CFILEE = 2;
    public static final int OCI_B_CLOB = 3;
    public static final int OCI_B_BLOB = 4;
    public static final int OCI_B_ROWID = 5;
    public static final int OCI_B_CURSOR = 6;
    public static final int OCI_B_NTY = 7;
    public static final int OCI_B_BIN = 8;
    public static final int OCI_DTYPE_FILE = 9;
    public static final int OCI_DTYPE_LOB = 10;
    public static final int OCI_DTYPE_ROWID = 11;
    public static final int OCI_D_FILE = 12;
    public static final int OCI_D_LOB = 13;
    public static final int OCI_D_ROWID = 14;
    public static final int OCI_SYSDATE = 15;
    public static final int OCI_TEMP_CLOB = 16;
    public static final int OCI_TEMP_BLOB = 17;
    public static final int SQLT_BFILEE = 18;
    public static final int SQLT_CFILEE = 19;
    public static final int SQLT_CLOB = 20;
    public static final int SQLT_BLOB = 21;
    public static final int SQLT_RDD = 22;
    public static final int SQLT_NTY = 23;
    public static final int SQLT_LNG = 24;
    public static final int SQLT_LBI = 25;
    public static final int SQLT_BIN = 26;
    public static final int SQLT_NUM = 27;
    public static final int SQLT_INT = 28;
    public static final int SQLT_AFC = 29;
    public static final int SQLT_CHR = 30;
    public static final int SQLT_VCS = 31;
    public static final int SQLT_AVC = 32;
    public static final int SQLT_STR = 33;
    public static final int SQLT_LVC = 34;
    public static final int SQLT_FLT = 35;
    public static final int SQLT_ODT = 36;
    public static final int SQLT_BDOUBLE = 37;
    public static final int SQLT_BFLOAT = 38;
    public static final int SQLT_RSET = 39;
    public static final int SQLT_FILE = 40;
    public static final int SQLT_CFILE = 41;
    public static final int OCI_DEFAULT = 80;
    public static final int OCI_DESCRIBE_ONLY = 81;
    public static final int OCI_COMMIT_ON_SUCCESS = 82;
    public static final int OCI_EXACT_FETCH = 83;
    public static final int OCI_FETCHSTATEMENT_BY_COLUMN = 84;
    public static final int OCI_FETCHSTATEMENT_BY_ROW = 85;
    public static final int OCI_ASSOC = 86;
    public static final int OCI_NUM = 87;
    public static final int OCI_BOTH = 88;
    public static final int OCI_RETURN_NULLS = 89;
    public static final int OCI_RETURN_LOBS = 90;
    public static final int OCI_SYSOPER = 91;
    public static final int OCI_SYSDBA = 92;
    public static final int OCI_LOB_BUFFER_FREE = 93;
    public static final int OCI_SEEK_SET = 94;
    public static final int OCI_SEEK_CUR = 95;
    public static final int OCI_SEEK_END = 106;
    private static Class classOracleTypes;
    private static int[] arrayPhpToOracleType;

    public String[] getLoadedExtensions() {
        return new String[]{"oci8"};
    }

    public static boolean oci_bind_array_by_name(Env env, @NotNull OracleStatement stmt, @NotNull String name, @NotNull ArrayValue varArray, @NotNull int maxTableLength, @Optional(value="0") int maxItemLength, @Optional(value="0") int type) {
        try {
            Connection conn = stmt.getJavaConnection();
            PreparedStatement oracleStmt = stmt.getPreparedStatement();
            Class<?> clArrayDescriptor = Class.forName("oracle.sql.ArrayDescriptor");
            Method method = clArrayDescriptor.getDeclaredMethod("createDescriptor", String.class, Connection.class);
            Object arrayDesc = method.invoke(clArrayDescriptor, "NUMBER_VARRAY", conn);
            Value[] valueArray = varArray.valuesToArray();
            Object[] objectArray = new Object[5];
            for (int i = 0; i < valueArray.length; ++i) {
                Object obj;
                objectArray[i] = obj = valueArray[i].toJavaObject();
            }
            Class<?> clARRAY = Class.forName("oracle.sql.ARRAY");
            Constructor<?> constructor = clARRAY.getDeclaredConstructor(clArrayDescriptor, Connection.class, Object.class);
            Array oracleArray = (Array)constructor.newInstance(arrayDesc, conn, objectArray);
            if (name == null) {
                return false;
            }
            if (!name.startsWith(":")) {
                name = ":" + name;
            }
            if (name.length() < 2) {
                return false;
            }
            Integer index = stmt.getBindingVariable(name);
            if (index == null) {
                return false;
            }
            int i = index;
            Object object = varArray.toJavaObject();
            if (object instanceof OracleOciCollection) {
                oracleArray = ((OracleOciCollection)object).getCollection();
                oracleStmt.setArray(i, oracleArray);
            } else if (varArray instanceof ArrayValueImpl) {
                oracleStmt.setArray(i, oracleArray);
            } else {
                oracleStmt.setObject(i, object);
            }
            return true;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public static boolean oci_bind_by_name(Env env, @NotNull OracleStatement stmt, @NotNull String placeholderName, Value variable, @Optional(value="0") int maxLength, @Optional(value="0") int type) {
        if (type == 2 || type == 41 || type == 19) {
            throw new UnimplementedException("oci_bind_by_name with CFILE");
        }
        try {
            if (placeholderName == null) {
                return false;
            }
            if (!placeholderName.startsWith(":")) {
                placeholderName = ":" + placeholderName;
            }
            if (placeholderName.length() < 2) {
                return false;
            }
            Integer index = stmt.getBindingVariable(placeholderName);
            if (index == null) {
                return false;
            }
            int i = index;
            PreparedStatement pstmt = stmt.getPreparedStatement();
            CallableStatement callableStmt = (CallableStatement)pstmt;
            switch (type) {
                case 6: 
                case 39: {
                    int oracleType = arrayPhpToOracleType[type];
                    callableStmt.registerOutParameter(i, oracleType);
                    Object cursor = variable.toJavaObject();
                    if (cursor == null || !(cursor instanceof OracleStatement)) {
                        return false;
                    }
                    ((OracleStatement)cursor).setPreparedStatement(callableStmt);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 18: 
                case 20: 
                case 21: 
                case 22: 
                case 40: {
                    int oracleType = arrayPhpToOracleType[type];
                    callableStmt.registerOutParameter(i, oracleType);
                    Object ociLob = variable.toJavaObject();
                    if (ociLob == null || !(ociLob instanceof OracleOciLob)) {
                        return false;
                    }
                    stmt.setOutParameter((OracleOciLob)ociLob);
                    break;
                }
                default: {
                    Object object = variable.toJavaObject();
                    if (object instanceof OracleOciCollection) {
                        object = ((OracleOciCollection)object).getCollection();
                    }
                    pstmt.setObject(i, object);
                }
            }
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            try {
                stmt.resetBindingVariables();
                stmt.resetByNameVariables();
            }
            catch (Exception ex2) {
                log.log(Level.FINE, ex2.toString(), ex2);
            }
            return false;
        }
    }

    public static boolean oci_cancel(Env env, @NotNull OracleStatement stmt) {
        return OracleModule.oci_free_statement(env, stmt);
    }

    public static boolean oci_close(Env env, @NotNull Oracle conn) {
        if (conn == null) {
            conn = OracleModule.getConnection(env);
        }
        if (conn != null) {
            if (conn == OracleModule.getConnection(env)) {
                env.removeSpecialValue("caucho.oracle");
            }
            conn.close(env);
            return true;
        }
        return false;
    }

    public static boolean oci_commit(Env env, @NotNull Oracle conn) {
        try {
            return conn.commit();
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    public static Value oci_connect(Env env, @NotNull String username, @NotNull String password, @Optional String db, @Optional String charset, @Optional(value="0") int sessionMode) {
        if (charset != null && charset.length() != 0) {
            throw new UnimplementedException("oci_connect with charset");
        }
        if (sessionMode == 80 || sessionMode == 91 || sessionMode == 92) {
            throw new UnimplementedException("oci_connect with session mode");
        }
        return OracleModule.connectInternal(env, true, username, password, db, charset, sessionMode);
    }

    public static boolean oci_define_by_name(Env env, @NotNull OracleStatement stmt, @NotNull String columnName, @NotNull @Reference Value variable, @Optional(value="0") int type) {
        try {
            stmt.putByNameVariable(columnName, variable);
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    @ReturnNullAsFalse
    public static String oci_error(Env env, @Optional Value resource) {
        if (resource instanceof DefaultValue) {
            return null;
        }
        JdbcConnectionResource conn = null;
        if (resource == null) {
            ConnectionInfo connectionInfo = (ConnectionInfo)env.getSpecialValue("caucho.oracle");
            if (connectionInfo != null) {
                conn = connectionInfo.getConnection();
            }
        } else {
            Object object = resource.toJavaObject();
            conn = object instanceof Oracle ? ((Oracle)object).validateConnection() : ((OracleStatement)object).validateConnection();
        }
        return conn.getErrorMessage();
    }

    public static boolean oci_execute(Env env, @NotNull OracleStatement stmt, @Optional(value="0") int mode) {
        try {
            Connection conn = stmt.getJavaConnection();
            conn.setAutoCommit(false);
            CallableStatement callableStatement = stmt.getCallableStatement();
            Object cursorResult = null;
            try {
                cursorResult = callableStatement.getObject(1);
                if (cursorResult != null && cursorResult instanceof ResultSet) {
                    ResultSet rs = (ResultSet)cursorResult;
                    stmt.setResultSet(rs);
                    return true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            stmt.execute(env);
            OracleOciLob ociLob = stmt.getOutParameter();
            if (ociLob != null) {
                ociLob.setLob(callableStatement.getObject(1));
            }
            if (mode == 82) {
                conn.commit();
            }
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            try {
                stmt.resetBindingVariables();
                stmt.resetByNameVariables();
            }
            catch (Exception ex2) {
                log.log(Level.FINE, ex2.toString(), ex2);
            }
            return false;
        }
    }

    @ReturnNullAsFalse
    public static ArrayValue oci_fetch_all(Env env, @NotNull OracleStatement stmt, @NotNull Value output, @Optional int skip, @Optional int maxrows, @Optional int flags) {
        JdbcResultResource resource = null;
        ArrayValueImpl newArray = new ArrayValueImpl();
        try {
            if (stmt == null) {
                return null;
            }
            resource = new JdbcResultResource(env, null, stmt.getResultSet(), null);
            ArrayValue value = resource.fetchArray(env, 1);
            int curr = 0;
            if (maxrows == 0) {
                maxrows = 0x3FFFFFFF;
            }
            while (value != null && curr < maxrows) {
                newArray.put(LongValue.create(curr), value);
                ++curr;
                value = resource.fetchArray(env, 1);
            }
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
        return newArray;
    }

    @ReturnNullAsFalse
    public static ArrayValue oci_fetch_array(Env env, @NotNull OracleStatement stmt, @Optional(value="-1") int mode) {
        if (stmt == null) {
            return null;
        }
        if (mode == 90) {
            throw new UnimplementedException("oci_fetch_array with OCI_RETURN_LOBS");
        }
        if (mode == 89) {
            throw new UnimplementedException("oci_fetch_array with OCI_RETURN_NULLS");
        }
        try {
            JdbcResultResource resource = new JdbcResultResource(env, null, stmt.getResultSet(), null);
            switch (mode) {
                case 86: {
                    return resource.fetchArray(env, 1);
                }
                case 87: {
                    return resource.fetchArray(env, 2);
                }
            }
            return resource.fetchArray(env, 3);
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    @ReturnNullAsFalse
    public static ArrayValue oci_fetch_assoc(Env env, @NotNull OracleStatement stmt) {
        try {
            if (stmt == null) {
                return null;
            }
            JdbcResultResource resource = new JdbcResultResource(env, null, stmt.getResultSet(), null);
            ArrayValue arrayValue = resource.fetchArray(env, 1);
            return arrayValue;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    public static Value oci_fetch_object(Env env, @NotNull OracleStatement stmt) {
        try {
            if (stmt == null) {
                return BooleanValue.FALSE;
            }
            JdbcResultResource resource = new JdbcResultResource(env, null, stmt.getResultSet(), null);
            return resource.fetchObject(env);
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return BooleanValue.FALSE;
        }
    }

    @ReturnNullAsFalse
    public static ArrayValue oci_fetch_row(Env env, @NotNull OracleStatement stmt) {
        try {
            if (stmt == null) {
                return null;
            }
            JdbcResultResource resource = new JdbcResultResource(env, null, stmt.getResultSet(), null);
            return resource.fetchArray(env, 2);
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    public static boolean oci_fetch(Env env, @NotNull OracleStatement stmt) {
        try {
            if (stmt == null) {
                return false;
            }
            JdbcResultResource resource = new JdbcResultResource(env, null, stmt.getResultSet(), null);
            ArrayValue result = resource.fetchArray(env, 3);
            stmt.setResultBuffer(result);
            if (!(result instanceof ArrayValue)) {
                return false;
            }
            ArrayValue arrayValue = result;
            for (Map.Entry<String, Value> entry : stmt.getByNameVariables().entrySet()) {
                String fieldName = entry.getKey();
                Value var = entry.getValue();
                Value newValue = arrayValue.get(StringValue.create(fieldName));
                var.set(newValue);
            }
            stmt.increaseFetchedRows();
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            try {
                stmt.resetByNameVariables();
            }
            catch (Exception ex2) {
                log.log(Level.FINE, ex2.toString(), ex2);
            }
            return false;
        }
    }

    public static boolean oci_field_is_null(Env env, @NotNull OracleStatement stmt, @NotNull Value fieldNameOrNumber) {
        if (stmt == null) {
            return false;
        }
        try {
            ResultSet rs = stmt.getResultSet();
            JdbcResultResource resource = new JdbcResultResource(env, null, rs, null);
            int fieldNumber = resource.getColumnNumber(fieldNameOrNumber, 1);
            if (fieldNumber < 0) {
                return false;
            }
            ResultSetMetaData metaData = rs.getMetaData();
            return metaData.isNullable(fieldNumber + 1) == 1;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    public static Value oci_field_name(Env env, @NotNull OracleStatement stmt, @NotNull int fieldNumber) {
        try {
            if (stmt == null) {
                return BooleanValue.FALSE;
            }
            JdbcResultResource resource = new JdbcResultResource(env, null, stmt.getResultSet(), null);
            return resource.getFieldName(env, fieldNumber);
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return BooleanValue.FALSE;
        }
    }

    @ReturnNullAsFalse
    public static LongValue oci_field_precision(Env env, @NotNull OracleStatement stmt, @NotNull int field) {
        if (stmt == null) {
            return null;
        }
        try {
            ResultSet rs = stmt.getResultSet();
            ResultSetMetaData metaData = rs.getMetaData();
            int precision = metaData.getPrecision(field);
            return LongValue.create(precision);
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    @ReturnNullAsFalse
    public static LongValue oci_field_scale(Env env, @NotNull OracleStatement stmt, @NotNull int field) {
        if (stmt == null) {
            return null;
        }
        try {
            ResultSet rs = stmt.getResultSet();
            ResultSetMetaData metaData = rs.getMetaData();
            int precision = metaData.getScale(field);
            return LongValue.create(precision);
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    public static Value oci_field_size(Env env, @NotNull OracleStatement stmt, @Optional(value="-1") Value fieldNameOrNumber) {
        try {
            if (stmt == null) {
                return BooleanValue.FALSE;
            }
            ResultSet rs = stmt.getResultSet();
            JdbcResultResource resource = new JdbcResultResource(env, null, rs, null);
            int fieldNumber = resource.getColumnNumber(fieldNameOrNumber, 1);
            return resource.getFieldLength(env, fieldNumber);
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return BooleanValue.FALSE;
        }
    }

    public static int oci_field_type_raw(Env env, @NotNull OracleStatement stmt, int field) {
        try {
            if (stmt == null) {
                return -1;
            }
            if (field <= 0) {
                return -1;
            }
            JdbcResultResource resource = new JdbcResultResource(env, null, stmt.getResultSet(), null);
            Value typeV = resource.getJdbcType(--field);
            if (typeV instanceof LongValue) {
                int type = typeV.toInt();
                switch (type) {
                    case -4: 
                    case -1: 
                    case 2004: {
                        type = 21;
                        break;
                    }
                    case 2005: {
                        type = 20;
                        break;
                    }
                    case -7: 
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 16: {
                        type = 27;
                        break;
                    }
                    default: {
                        type = 30;
                    }
                }
                return type;
            }
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
        }
        return -1;
    }

    public static Value oci_field_type(Env env, @NotNull OracleStatement stmt, int fieldNumber) {
        try {
            if (stmt == null) {
                return BooleanValue.FALSE;
            }
            JdbcResultResource resource = new JdbcResultResource(env, null, stmt.getResultSet(), null);
            return resource.getFieldType(env, fieldNumber);
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return BooleanValue.FALSE;
        }
    }

    public static boolean oci_free_statement(Env env, @NotNull OracleStatement stmt) {
        try {
            stmt.close();
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    public static void oci_internal_debug(Env env, @NotNull int onoff) {
        throw new UnimplementedException("oci_internal_debug");
    }

    public static boolean oci_lob_copy(Env env, @NotNull OracleOciLob lobTo, @NotNull OracleOciLob lobFrom, @Optional(value="-1") int length) {
        try {
            return lobTo.save(env, lobFrom.read(env, length).toString(), 0L);
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    public static boolean oci_lob_is_equal(Env env, @NotNull OracleOciLob lob1, @NotNull OracleOciLob lob2) {
        try {
            return lob1.equals(lob2);
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    @ReturnNullAsFalse
    public static OracleOciCollection oci_new_collection(Env env, @NotNull Oracle conn, @NotNull String tdo, @Optional String schema) {
        try {
            String typeName = tdo;
            if (schema != null && schema.length() > 0) {
                typeName = schema + "." + tdo;
            }
            Connection jdbcConn = conn.getJavaConnection();
            Class<?> clArrayDescriptor = Class.forName("oracle.sql.ArrayDescriptor");
            Method method = clArrayDescriptor.getDeclaredMethod("createDescriptor", String.class, Connection.class);
            Object arrayDesc = method.invoke(clArrayDescriptor, typeName, jdbcConn);
            if (arrayDesc != null) {
                return new OracleOciCollection(jdbcConn, arrayDesc);
            }
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
        }
        return null;
    }

    public static Value oci_new_connect(Env env, @NotNull String username, @NotNull String password, @Optional String db, @Optional String charset, @Optional(value="0") int sessionMode) {
        if (sessionMode == 80 || sessionMode == 91 || sessionMode == 92) {
            log.warning(L.l("oci_new_connect with session mode '{0}'", sessionMode));
        }
        return OracleModule.connectInternal(env, false, username, password, db, charset, sessionMode);
    }

    @ReturnNullAsFalse
    public static OracleStatement oci_new_cursor(Env env, @NotNull Oracle conn) {
        try {
            OracleStatement stmt = new OracleStatement((Oracle)conn.validateConnection());
            return stmt;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    @ReturnNullAsFalse
    public static OracleOciLob oci_new_descriptor(Env env, @NotNull Oracle conn, @Optional(value="-1") int type) {
        try {
            if (type == 12 || type == 13 || type == 14) {
                OracleOciLob oracleLob = new OracleOciLob(conn, type);
                return oracleLob;
            }
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
        }
        return null;
    }

    public static Value oci_num_fields(Env env, @NotNull OracleStatement stmt) {
        try {
            if (stmt == null) {
                return BooleanValue.FALSE;
            }
            JdbcResultResource resource = new JdbcResultResource(env, null, stmt.getResultSet(), null);
            return LongValue.create(resource.getFieldCount());
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return BooleanValue.FALSE;
        }
    }

    @ReturnNullAsFalse
    public static LongValue oci_num_rows(Env env, @NotNull OracleStatement stmt) {
        try {
            if (stmt == null) {
                return null;
            }
            return LongValue.create(stmt.getFetchedRows());
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    @ReturnNullAsFalse
    public static OracleStatement oci_parse(Env env, @NotNull Oracle conn, String query) {
        try {
            query = query.trim();
            String lowerCaseQuery = query.toLowerCase();
            if (lowerCaseQuery.startsWith("insert") || lowerCaseQuery.startsWith("update") || lowerCaseQuery.startsWith("delete")) {
                if (!lowerCaseQuery.startsWith("begin ")) {
                    query = "begin " + query;
                }
                if (!lowerCaseQuery.endsWith(";")) {
                    query = query + ";";
                }
                if (!lowerCaseQuery.endsWith(" end;")) {
                    query = query + " end;";
                }
            }
            String regex = ":[a-zA-Z0-9_]+";
            String jdbcQuery = query.replaceAll(regex, "?");
            OracleStatement pstmt = conn.prepare(env, env.createString(jdbcQuery));
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(query);
            int i = 0;
            while (matcher.find()) {
                String group = matcher.group();
                pstmt.putBindingVariable(group, new Integer(++i));
            }
            return pstmt;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    public static boolean oci_password_change(Env env, @NotNull Oracle conn, @NotNull String username, @NotNull String oldPassword, @NotNull String newPassword) {
        try {
            if (conn == null) {
                return false;
            }
            OracleStatement oracleStmt = OracleModule.oci_parse(env, conn, "ALTER USER " + username + " IDENTIFIED BY " + newPassword);
            OracleModule.oci_execute(env, oracleStmt, 0);
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    public static Value oci_pconnect(Env env, @NotNull String username, @NotNull String password, @Optional String db, @Optional String charset, @Optional(value="0") int sessionMode) {
        if (charset != null && charset.length() != 0) {
            throw new UnimplementedException("oci_pconnect with charset");
        }
        if (sessionMode == 80 || sessionMode == 91 || sessionMode == 92) {
            throw new UnimplementedException("oci_pconnect with session mode");
        }
        return OracleModule.connectInternal(env, true, username, password, db, charset, sessionMode);
    }

    public static Value oci_result(Env env, @NotNull OracleStatement stmt, @NotNull Value field) {
        try {
            if (stmt == null) {
                return BooleanValue.FALSE;
            }
            Value result = stmt.getResultBuffer();
            return ((ArrayValueImpl)result).get(field);
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return BooleanValue.FALSE;
        }
    }

    public static Value oci_rollback(Env env, @NotNull Oracle conn) {
        try {
            return BooleanValue.create(conn.rollback());
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return BooleanValue.FALSE;
        }
    }

    @ReturnNullAsFalse
    public static String oci_server_version(Env env, @NotNull Oracle conn) {
        try {
            if (conn == null) {
                conn = OracleModule.getConnection(env);
            }
            return conn.getServerInfo();
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    public static boolean oci_set_prefetch(Env env, @NotNull OracleStatement stmt, @Optional(value="1") int rows) {
        try {
            if (stmt == null) {
                return false;
            }
            PreparedStatement pstmt = stmt.getPreparedStatement();
            pstmt.setFetchSize(rows);
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    public static String oci_statement_type(Env env, @NotNull OracleStatement stmt) {
        return stmt.getStatementType();
    }

    public static boolean ocibindbyname(Env env, @NotNull OracleStatement stmt, @NotNull String variable, @NotNull Value value, @Optional(value="0") int maxLength, @Optional(value="0") int type) {
        return OracleModule.oci_bind_by_name(env, stmt, variable, value, maxLength, type);
    }

    public static boolean ocicancel(Env env, @NotNull OracleStatement stmt) {
        return OracleModule.oci_cancel(env, stmt);
    }

    public static Value ocicloselob(Env env, @NotNull Oracle conn) {
        throw new UnimplementedException("ocicloselob");
    }

    public static Value ocicollappend(Env env, @NotNull Oracle conn) {
        throw new UnimplementedException("ocicollappend");
    }

    public static Value ocicollassign(Env env, @NotNull Oracle conn) {
        throw new UnimplementedException("ocicollassign");
    }

    public static Value ocicollassignelem(Env env, @NotNull Oracle conn) {
        throw new UnimplementedException("ocicollassignelem");
    }

    public static Value ocicollgetelem(Env env, @NotNull Oracle conn) {
        throw new UnimplementedException("ocicollgetelem");
    }

    public static Value ocicollmax(Env env, @NotNull Oracle conn) {
        throw new UnimplementedException("ocicollmax");
    }

    public static Value ocicollsize(Env env, @NotNull Oracle conn) {
        throw new UnimplementedException("ocicollsize");
    }

    public static Value ocicolltrim(Env env, @NotNull Oracle conn) {
        throw new UnimplementedException("ocicolltrim");
    }

    public static boolean ocicolumnisnull(Env env, @NotNull OracleStatement stmt, @NotNull Value field) {
        return OracleModule.oci_field_is_null(env, stmt, field);
    }

    public static Value ocicolumnname(Env env, @NotNull OracleStatement stmt, @NotNull int fieldNumber) {
        return OracleModule.oci_field_name(env, stmt, fieldNumber);
    }

    public static Value ocicolumnprecision(Env env, @NotNull OracleStatement stmt, @NotNull int field) {
        return OracleModule.oci_field_precision(env, stmt, field);
    }

    public static Value ocicolumnscale(Env env, @NotNull OracleStatement stmt, @NotNull int field) {
        return OracleModule.oci_field_scale(env, stmt, field);
    }

    public static Value ocicolumnsize(Env env, @NotNull OracleStatement stmt, @Optional Value field) {
        return OracleModule.oci_field_size(env, stmt, field);
    }

    public static Value ocicolumntype(Env env, @NotNull OracleStatement stmt, @Optional int fieldNumber) {
        return OracleModule.oci_field_type(env, stmt, fieldNumber);
    }

    public static int ocicolumntyperaw(Env env, @NotNull OracleStatement stmt, @Optional int field) {
        return OracleModule.oci_field_type_raw(env, stmt, field);
    }

    public static boolean ocicommit(Env env, @NotNull Oracle conn) {
        return OracleModule.oci_commit(env, conn);
    }

    public static boolean ocidefinebyname(Env env, @NotNull OracleStatement stmt, @NotNull String columnName, @NotNull Value variable, @Optional(value="0") int type) {
        return OracleModule.oci_define_by_name(env, stmt, columnName, variable, type);
    }

    @ReturnNullAsFalse
    public static String ocierror(Env env, @Optional Value resource) {
        return OracleModule.oci_error(env, resource);
    }

    public static boolean ociexecute(Env env, @NotNull OracleStatement stmt, @Optional(value="0") int mode) {
        return OracleModule.oci_execute(env, stmt, mode);
    }

    public static boolean ocifetch(Env env, @NotNull OracleStatement stmt) {
        return OracleModule.oci_fetch(env, stmt);
    }

    public static Value ocifetchinto(Env env, @NotNull OracleStatement stmt, @Reference Value result, @Optional(value="-1") int mode) {
        ArrayValue array;
        if (mode == -1) {
            mode = 87;
        }
        if ((array = OracleModule.oci_fetch_array(env, stmt, mode)) != null) {
            result.set(array);
            return LongValue.create(array.getSize());
        }
        return BooleanValue.FALSE;
    }

    public static Value ocifetchstatement(Env env, @NotNull OracleStatement stmt, @NotNull Value output, @Optional int skip, @Optional int maxrows, @Optional int flags) {
        return OracleModule.oci_fetch_all(env, stmt, output, skip, maxrows, flags);
    }

    public static Value ocifreecollection(Env env, @NotNull Oracle conn) {
        throw new UnimplementedException("ocifreecollection");
    }

    public static boolean ocifreecursor(Env env, @NotNull OracleStatement stmt) {
        return OracleModule.oci_free_statement(env, stmt);
    }

    public static Value ocifreedesc(Env env, @NotNull Oracle conn) {
        throw new UnimplementedException("ocifreedesc");
    }

    public static boolean ocifreestatement(Env env, @NotNull OracleStatement stmt) {
        return OracleModule.oci_free_statement(env, stmt);
    }

    public static void ociinternaldebug(Env env, @NotNull int onoff) {
        OracleModule.oci_internal_debug(env, onoff);
    }

    public static Value ociloadlob(Env env, @NotNull Oracle conn) {
        throw new UnimplementedException("ociloadlob");
    }

    public static boolean ocilogoff(Env env, @NotNull Oracle conn) {
        return OracleModule.oci_close(env, conn);
    }

    public static Value ocilogon(Env env, @NotNull String username, @NotNull String password, @Optional String db, @Optional String charset, @Optional(value="0") int sessionMode) {
        return OracleModule.oci_connect(env, username, password, db, charset, sessionMode);
    }

    @ReturnNullAsFalse
    public static OracleOciCollection ocinewcollection(Env env, @NotNull Oracle conn, @NotNull String tdo, @Optional String schema) {
        return OracleModule.oci_new_collection(env, conn, tdo, schema);
    }

    @ReturnNullAsFalse
    public static OracleStatement ocinewcursor(Env env, @NotNull Oracle conn) {
        return OracleModule.oci_new_cursor(env, conn);
    }

    public static OracleOciLob ocinewdescriptor(Env env, @NotNull Oracle conn, @Optional(value="-1") int type) {
        return OracleModule.oci_new_descriptor(env, conn, type);
    }

    public static Value ocinlogon(Env env, @NotNull String username, @NotNull String password, @Optional String db, @Optional String charset, @Optional(value="0") int sessionMode) {
        return OracleModule.oci_new_connect(env, username, password, db, charset, sessionMode);
    }

    public static Value ocinumcols(Env env, @NotNull OracleStatement stmt) {
        return OracleModule.oci_num_fields(env, stmt);
    }

    @ReturnNullAsFalse
    public static OracleStatement ociparse(Env env, @NotNull Oracle conn, @NotNull String query) {
        return OracleModule.oci_parse(env, conn, query);
    }

    public static Value ociplogon(Env env, @NotNull String username, @NotNull String password, @Optional String db, @Optional String charset, @Optional(value="0") int sessionMode) {
        return OracleModule.oci_pconnect(env, username, password, db, charset, sessionMode);
    }

    public static Value ociresult(Env env, @NotNull OracleStatement stmt, @NotNull Value field) {
        return OracleModule.oci_result(env, stmt, field);
    }

    public static Value ocirollback(Env env, @NotNull Oracle conn) {
        return OracleModule.oci_rollback(env, conn);
    }

    public static Value ocirowcount(Env env, @NotNull OracleStatement stmt) {
        return OracleModule.oci_num_rows(env, stmt);
    }

    public static Value ocisavelob(Env env, @NotNull Oracle conn) {
        throw new UnimplementedException("ocisavelob");
    }

    public static Value ocisavelobfile(Env env, @NotNull Oracle conn) {
        throw new UnimplementedException("ocisavelobfile");
    }

    public static String ociserverversion(Env env, @NotNull Oracle conn) {
        return OracleModule.oci_server_version(env, conn);
    }

    public static boolean ocisetprefetch(Env env, @NotNull OracleStatement stmt, @Optional(value="1") int rows) {
        return OracleModule.oci_set_prefetch(env, stmt, rows);
    }

    public static String ocistatementtype(Env env, @NotNull OracleStatement stmt) {
        return OracleModule.oci_statement_type(env, stmt);
    }

    public static Value ociwritelobtofile(Env env, @NotNull Oracle conn) {
        throw new UnimplementedException("ociwritelobtofile");
    }

    public static Value ociwritetemporarylob(Env env, @NotNull Oracle conn) {
        throw new UnimplementedException("ociwritetemporarylob");
    }

    private static Oracle getConnection(Env env) {
        Oracle conn = null;
        ConnectionInfo connectionInfo = (ConnectionInfo)env.getSpecialValue("caucho.oracle");
        if (connectionInfo != null) {
            conn = connectionInfo.getConnection();
            return conn;
        }
        String driver = "oracle.jdbc.OracleDriver";
        String url = "jdbc:oracle:thin:@localhost:1521";
        conn = new Oracle(env, "localhost", "", "", "", 1521, driver, url);
        env.setSpecialValue("caucho.oracle", conn);
        return conn;
    }

    private static Value connectInternal(Env env, boolean reuseConnection, String username, String password, String db, String charset, int sessionMode) {
        String url;
        String host = "localhost";
        int port = 1521;
        String driver = "oracle.jdbc.OracleDriver";
        if (db.indexOf("//") == 0) {
            url = "jdbc:oracle:thin:@" + db.substring(2);
            url = url.replace('/', ':');
        } else {
            url = "jdbc:oracle:thin:@" + host + ":" + port + ":" + db;
        }
        Oracle conn = null;
        ConnectionInfo connectionInfo = (ConnectionInfo)env.getSpecialValue("caucho.oracle");
        if (reuseConnection && connectionInfo != null && url.equals(connectionInfo.getUrl())) {
            conn = connectionInfo.getConnection();
        } else {
            conn = new Oracle(env, host, username, password, db, port, driver, url);
            if (!conn.isConnected()) {
                return BooleanValue.FALSE;
            }
            connectionInfo = new ConnectionInfo(url, conn);
            env.setSpecialValue("caucho.oracle", connectionInfo);
        }
        Value value = env.wrapJava(conn);
        return value;
    }

    static {
        try {
            classOracleTypes = Class.forName("oracle.jdbc.OracleTypes");
            arrayPhpToOracleType = new int[]{-1, classOracleTypes.getDeclaredField("BFILE").getInt(null), -1, classOracleTypes.getDeclaredField("CLOB").getInt(null), classOracleTypes.getDeclaredField("BLOB").getInt(null), classOracleTypes.getDeclaredField("ROWID").getInt(null), classOracleTypes.getDeclaredField("CURSOR").getInt(null), classOracleTypes.getDeclaredField("OTHER").getInt(null), classOracleTypes.getDeclaredField("RAW").getInt(null), -1, -1, -1, -1, -1, -1, classOracleTypes.getDeclaredField("TIMESTAMP").getInt(null), -1, -1, classOracleTypes.getDeclaredField("BFILE").getInt(null), -1, classOracleTypes.getDeclaredField("CLOB").getInt(null), classOracleTypes.getDeclaredField("BLOB").getInt(null), classOracleTypes.getDeclaredField("ROWID").getInt(null), classOracleTypes.getDeclaredField("OTHER").getInt(null), classOracleTypes.getDeclaredField("NUMBER").getInt(null), classOracleTypes.getDeclaredField("RAW").getInt(null), classOracleTypes.getDeclaredField("RAW").getInt(null), classOracleTypes.getDeclaredField("NUMBER").getInt(null), classOracleTypes.getDeclaredField("INTEGER").getInt(null), classOracleTypes.getDeclaredField("CHAR").getInt(null), classOracleTypes.getDeclaredField("CHAR").getInt(null), classOracleTypes.getDeclaredField("VARCHAR").getInt(null), classOracleTypes.getDeclaredField("CHAR").getInt(null), classOracleTypes.getDeclaredField("VARCHAR").getInt(null), classOracleTypes.getDeclaredField("LONGVARCHAR").getInt(null), classOracleTypes.getDeclaredField("FLOAT").getInt(null), classOracleTypes.getDeclaredField("DATE").getInt(null), classOracleTypes.getDeclaredField("DOUBLE").getInt(null), classOracleTypes.getDeclaredField("FLOAT").getInt(null), classOracleTypes.getDeclaredField("CURSOR").getInt(null), classOracleTypes.getDeclaredField("BFILE").getInt(null), -1};
        }
        catch (Exception e) {
            L.l("Unable to load Oracle types from oracle.jdbc.OracleTypes. Check your Oracle JDBC driver version.");
        }
    }

    private static class ConnectionInfo {
        private String _url;
        private Oracle _conn;

        public ConnectionInfo(String url, Oracle conn) {
            this._url = url;
            this._conn = conn;
        }

        public String getUrl() {
            return this._url;
        }

        public Oracle getConnection() {
            return this._conn;
        }
    }
}

