/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ResourceType;
import com.caucho.quercus.env.ConnectionEntry;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.lib.db.JdbcConnectionResource;
import com.caucho.quercus.lib.db.JdbcResultResource;
import com.caucho.quercus.lib.db.PostgresResult;
import com.caucho.quercus.lib.db.PostgresStatement;
import com.caucho.util.L10N;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

@ResourceType(value="pgsql link")
public class Postgres
extends JdbcConnectionResource {
    private static final Logger log = Logger.getLogger(Postgres.class.getName());
    private static final L10N L = new L10N(Postgres.class);
    PostgresResult _asyncResult;
    PostgresStatement _asyncStmt;
    private HashMap<String, PostgresStatement> _stmtTable = new HashMap();
    Object _serverErrorMessage;

    public Postgres(Env env, @Optional(value="localhost") String host, @Optional String user, @Optional String password, @Optional String db, @Optional(value="5432") int port, @Optional String driver, @Optional String url) {
        super(env);
        this.connectInternal(env, host, user, password, db, port, "", 0, driver, url, false);
    }

    protected ConnectionEntry connectImpl(Env env, String host, String userName, String password, String dbname, int port, String socket, int flags, String driver, String url, boolean isNewLink) {
        if (this.isConnected()) {
            env.warning(L.l("Connection is already opened to '{0}'", this));
            return null;
        }
        try {
            if (host == null || host.equals("")) {
                host = "localhost";
            }
            if (driver == null || driver.equals("")) {
                driver = "org.postgresql.Driver";
            }
            if (url == null || url.equals("")) {
                url = "jdbc:postgresql://" + host + ":" + port + "/" + dbname;
            }
            ConnectionEntry jConn = env.getConnection(driver, url, userName, password, !isNewLink);
            return jConn;
        }
        catch (SQLException e) {
            env.warning("A link to the server could not be established. " + e.toString());
            env.setSpecialValue("postgres.connectErrno", LongValue.create(e.getErrorCode()));
            env.setSpecialValue("postgres.connectError", env.createString(e.getMessage()));
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
        catch (Exception e) {
            env.warning("A link to the server could not be established. " + e.toString());
            env.setSpecialValue("postgres.connectError", env.createString(e.getMessage()));
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    public PostgresStatement prepare(Env env, StringValue query) {
        PostgresStatement stmt = new PostgresStatement((Postgres)this.validateConnection());
        stmt.prepare(env, query);
        return stmt;
    }

    public PostgresResult query(Env env, String sql) {
        Object result;
        JdbcConnectionResource.SqlParseToken tok = this.parseSqlToken(sql, null);
        if (tok != null && tok.matchesFirstChar('S', 's') && tok.matchesToken("SET") && (tok = this.parseSqlToken(sql, tok)) != null && tok.matchesToken("CLIENT_ENCODING") && (tok = this.parseSqlToken(sql, tok)) != null && tok.matchesToken("TO")) {
            sql = "SET CLIENT_ENCODING TO 'UNICODE'";
        }
        if (!((result = this.realQuery(env, sql).toJavaObject()) instanceof PostgresResult)) {
            return null;
        }
        return (PostgresResult)result;
    }

    protected JdbcResultResource createResult(Env env, Statement stmt, ResultSet rs) {
        return new PostgresResult(env, stmt, rs, this);
    }

    public void setAsynchronousResult(PostgresResult asyncResult) {
        this._asyncResult = asyncResult;
    }

    public PostgresResult getAsynchronousResult() {
        return this._asyncResult;
    }

    public PostgresStatement getAsynchronousStatement() {
        return this._asyncStmt;
    }

    public void setAsynchronousStatement(PostgresStatement asyncStmt) {
        this._asyncStmt = asyncStmt;
    }

    public void putStatement(String name, PostgresStatement stmt) {
        this._stmtTable.put(name, stmt);
    }

    public PostgresStatement getStatement(String name) {
        return this._stmtTable.get(name);
    }

    public PostgresStatement removeStatement(String name) {
        return this._stmtTable.remove(name);
    }

    protected void keepResourceValues(Statement stmt) {
        this.setResultResource(this.createResult(this.getEnv(), stmt, null));
    }

    protected boolean keepStatementOpen() {
        return true;
    }

    public static StringValue pgRealEscapeString(StringValue str) {
        StringValue buf = str.createStringBuilder(str.length());
        int strLength = str.length();
        block9: for (int i = 0; i < strLength; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\u0000': {
                    buf.append('\\');
                    buf.append('\u0000');
                    continue block9;
                }
                case '\n': {
                    buf.append('\\');
                    buf.append('n');
                    continue block9;
                }
                case '\r': {
                    buf.append('\\');
                    buf.append('r');
                    continue block9;
                }
                case '\\': {
                    buf.append('\\');
                    buf.append('\\');
                    continue block9;
                }
                case '\'': {
                    buf.append('\'');
                    buf.append('\'');
                    continue block9;
                }
                case '\"': {
                    buf.append('\"');
                    continue block9;
                }
                case '\u001a': {
                    buf.append('\\');
                    buf.append('Z');
                    continue block9;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf;
    }

    protected StringValue realEscapeString(StringValue str) {
        return Postgres.pgRealEscapeString(str);
    }

    protected void clearErrors() {
        super.clearErrors();
        this._serverErrorMessage = null;
    }

    protected void saveErrors(SQLException e) {
        try {
            super.saveErrors(e);
            Class<?> cl = Class.forName("org.postgresql.util.PSQLException");
            Method method = cl.getDeclaredMethod("getServerErrorMessage", null);
            this._serverErrorMessage = method.invoke((Object)e, new Object[0]);
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
        }
    }

    protected Object getServerErrorMessage() {
        return this._serverErrorMessage;
    }

    public String toString() {
        if (this.isConnected()) {
            return "Postgres[" + this.getHost() + "]";
        }
        return "Postgres[]";
    }

    public String getClientEncoding() {
        return "UNICODE";
    }

    public boolean setClientEncoding(String encoding) {
        return true;
    }
}

