/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.dom;

import com.caucho.quercus.UnimplementedException;
import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.lib.dom.DOMAttr;
import com.caucho.quercus.lib.dom.DOMCDATASection;
import com.caucho.quercus.lib.dom.DOMComment;
import com.caucho.quercus.lib.dom.DOMConfiguration;
import com.caucho.quercus.lib.dom.DOMDocument;
import com.caucho.quercus.lib.dom.DOMDocumentFragment;
import com.caucho.quercus.lib.dom.DOMDocumentType;
import com.caucho.quercus.lib.dom.DOMElement;
import com.caucho.quercus.lib.dom.DOMEntityReference;
import com.caucho.quercus.lib.dom.DOMException;
import com.caucho.quercus.lib.dom.DOMFactory;
import com.caucho.quercus.lib.dom.DOMNamedNodeMap;
import com.caucho.quercus.lib.dom.DOMNodeList;
import com.caucho.quercus.lib.dom.DOMNotation;
import com.caucho.quercus.lib.dom.DOMProcessingInstruction;
import com.caucho.quercus.lib.dom.DOMStringList;
import com.caucho.quercus.lib.dom.DOMText;
import com.caucho.quercus.lib.dom.DOMTypeInfo;
import com.caucho.quercus.lib.dom.QDOMFactory;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import java.io.IOException;
import java.util.IdentityHashMap;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;
import org.xml.sax.SAXException;

public class DOMImplementation {
    private static L10N L = new L10N(DOMImplementation.class);
    private final IdentityHashMap<Object, Object> _wrapperMap = new IdentityHashMap();
    private final DOMFactory _factory = new QDOMFactory();
    final org.w3c.dom.DOMImplementation _delegate = this._factory.getImplementation();

    static DOMImplementation get(Env env) {
        DOMImplementation impl = (DOMImplementation)env.getSpecialValue("caucho.dom");
        if (impl == null) {
            impl = new DOMImplementation();
            env.setSpecialValue("caucho.dom", impl);
        }
        return impl;
    }

    public static boolean hasFeature(Env env, String feature, String version) {
        return DOMImplementation.get((Env)env)._delegate.hasFeature(feature, version);
    }

    public static DOMDocument createDocument(Env env, @Optional String namespaceURI, @Optional String name, @Optional DOMDocumentType docType) {
        DOMDocument doc = docType != null ? DOMImplementation.get(env).createDocument(docType) : DOMImplementation.get(env).createDocument();
        if (name != null && name.length() > 0) {
            DOMElement elt = namespaceURI != null && namespaceURI.length() > 0 ? doc.createElementNS(namespaceURI, name) : doc.createElement(name);
            doc.appendChild(elt);
        }
        return doc;
    }

    @ReturnNullAsFalse
    public static DOMDocumentType createDocumentType(Env env, @NotNull String qualifiedName, @Optional String publicId, @Optional String systemId) {
        if (qualifiedName == null) {
            return null;
        }
        if (publicId != null && publicId.length() > 0 && publicId != null && publicId.length() > 0) {
            return DOMImplementation.get(env).createDocumentType(qualifiedName, publicId, systemId);
        }
        return DOMImplementation.get(env).createDocumentType(qualifiedName);
    }

    DOMAttr createWrapper(Attr node) {
        DOMAttr wrapper = new DOMAttr(this, node);
        this._wrapperMap.put(node, wrapper);
        return wrapper;
    }

    DOMCDATASection createWrapper(CDATASection node) {
        DOMCDATASection wrapper = new DOMCDATASection(this, node);
        this._wrapperMap.put(node, wrapper);
        return wrapper;
    }

    DOMComment createWrapper(Comment node) {
        DOMComment wrapper = new DOMComment(this, node);
        this._wrapperMap.put(node, wrapper);
        return wrapper;
    }

    DOMDocument createWrapper(Document node) {
        DOMDocument wrapper = new DOMDocument(this, node);
        this._wrapperMap.put(node, wrapper);
        return wrapper;
    }

    DOMDocumentFragment createWrapper(DocumentFragment node) {
        DOMDocumentFragment wrapper = new DOMDocumentFragment(this, node);
        this._wrapperMap.put(node, wrapper);
        return wrapper;
    }

    DOMDocumentType createWrapper(DocumentType node) {
        DOMDocumentType wrapper = new DOMDocumentType(this, node);
        this._wrapperMap.put(node, wrapper);
        return wrapper;
    }

    DOMConfiguration createWrapper(org.w3c.dom.DOMConfiguration node) {
        DOMConfiguration wrapper = new DOMConfiguration(this, node);
        this._wrapperMap.put(node, wrapper);
        return wrapper;
    }

    DOMException createWrapper(org.w3c.dom.DOMException node) {
        DOMException wrapper = new DOMException(this, node);
        this._wrapperMap.put(node, wrapper);
        return wrapper;
    }

    DOMElement createWrapper(Element node) {
        DOMElement wrapper = new DOMElement(this, node);
        this._wrapperMap.put(node, wrapper);
        return wrapper;
    }

    DOMEntityReference createWrapper(EntityReference node) {
        DOMEntityReference wrapper = new DOMEntityReference(this, node);
        this._wrapperMap.put(node, wrapper);
        return wrapper;
    }

    DOMNamedNodeMap createWrapper(NamedNodeMap node) {
        DOMNamedNodeMap wrapper = new DOMNamedNodeMap(this, node);
        this._wrapperMap.put(node, wrapper);
        return wrapper;
    }

    DOMNodeList createWrapper(NodeList node) {
        DOMNodeList wrapper = new DOMNodeList(this, node);
        this._wrapperMap.put(node, wrapper);
        return wrapper;
    }

    DOMNotation createWrapper(Notation node) {
        DOMNotation wrapper = new DOMNotation(this, node);
        this._wrapperMap.put(node, wrapper);
        return wrapper;
    }

    DOMProcessingInstruction createWrapper(ProcessingInstruction node) {
        DOMProcessingInstruction wrapper = new DOMProcessingInstruction(this, node);
        this._wrapperMap.put(node, wrapper);
        return wrapper;
    }

    DOMStringList createWrapper(org.w3c.dom.DOMStringList node) {
        DOMStringList wrapper = new DOMStringList(this, node);
        this._wrapperMap.put(node, wrapper);
        return wrapper;
    }

    DOMText createWrapper(Text node) {
        DOMText wrapper = new DOMText(this, node);
        this._wrapperMap.put(node, wrapper);
        return wrapper;
    }

    DOMTypeInfo createWrapper(TypeInfo node) {
        DOMTypeInfo wrapper = new DOMTypeInfo(this, node);
        this._wrapperMap.put(node, wrapper);
        return wrapper;
    }

    Object getWrapper(Object obj) {
        Object wrapper;
        if (obj == null) {
            return null;
        }
        if (obj instanceof NodeList) {
            wrapper = this.createWrapper((NodeList)obj);
        } else {
            wrapper = this._wrapperMap.get(obj);
            if (wrapper == null) {
                if (obj instanceof Attr) {
                    wrapper = this.createWrapper((Attr)obj);
                } else if (obj instanceof CDATASection) {
                    wrapper = this.createWrapper((CDATASection)obj);
                } else if (obj instanceof Comment) {
                    wrapper = this.createWrapper((Comment)obj);
                } else if (obj instanceof Document) {
                    wrapper = this.createWrapper((Document)obj);
                } else if (obj instanceof DocumentFragment) {
                    wrapper = this.createWrapper((DocumentFragment)obj);
                } else if (obj instanceof DocumentType) {
                    wrapper = this.createWrapper((DocumentType)obj);
                } else if (obj instanceof org.w3c.dom.DOMConfiguration) {
                    wrapper = this.createWrapper((org.w3c.dom.DOMConfiguration)obj);
                } else if (obj instanceof org.w3c.dom.DOMException) {
                    wrapper = this.createWrapper((org.w3c.dom.DOMException)obj);
                } else if (obj instanceof Element) {
                    wrapper = this.createWrapper((Element)obj);
                } else if (obj instanceof EntityReference) {
                    wrapper = this.createWrapper((EntityReference)obj);
                } else if (obj instanceof NamedNodeMap) {
                    wrapper = this.createWrapper((NamedNodeMap)obj);
                } else if (obj instanceof Notation) {
                    wrapper = this.createWrapper((Notation)obj);
                } else if (obj instanceof ProcessingInstruction) {
                    wrapper = this.createWrapper((ProcessingInstruction)obj);
                } else if (obj instanceof org.w3c.dom.DOMStringList) {
                    wrapper = this.createWrapper((org.w3c.dom.DOMStringList)obj);
                } else if (obj instanceof Text) {
                    wrapper = this.createWrapper((Text)obj);
                } else if (obj instanceof TypeInfo) {
                    wrapper = this.createWrapper((TypeInfo)obj);
                } else {
                    throw new UnimplementedException(L.l("cannot wrap element of type {0}", obj.getClass().getName()));
                }
                this._wrapperMap.put(obj, wrapper);
            }
        }
        return wrapper;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    DOMAttr createAttr(String name) {
        return this.createWrapper(this._factory.createAttr(name));
    }

    public DOMComment createComment() {
        return this.createWrapper(this._factory.createComment());
    }

    public DOMDocument createDocument() {
        return this.createWrapper(this._factory.createDocument());
    }

    public DOMDocument createDocument(DOMDocumentType docType) {
        return this.createWrapper(this._factory.createDocument((DocumentType)docType._delegate));
    }

    public DOMDocumentType createDocumentType(String qualifiedName) {
        return this.createWrapper(this._factory.createDocumentType(qualifiedName));
    }

    public DOMDocumentType createDocumentType(String qualifiedName, String publicId, String systemId) {
        return this.createWrapper(this._factory.createDocumentType(qualifiedName, publicId, systemId));
    }

    public DOMElement createElement(String name) {
        return this.createWrapper(this._factory.createElement(name));
    }

    public DOMElement createElement(String name, String namespace) {
        return this.createWrapper(this._factory.createElement(name, namespace));
    }

    public DOMEntityReference createEntityReference(String name) {
        return this.createWrapper(this._factory.createEntityReference(name));
    }

    public DOMProcessingInstruction createProcessingInstruction(String name) {
        return this.createWrapper(this._factory.createProcessingInstruction(name));
    }

    public DOMText createText() {
        return this.createWrapper(this._factory.createText());
    }

    public void parseHTMLDocument(Document document, ReadStream is, String path) throws IOException, SAXException {
        this._factory.parseHTMLDocument(document, is, path);
    }

    public void parseXMLDocument(Document document, ReadStream is, String path) throws IOException, SAXException {
        this._factory.parseXMLDocument(document, is, path);
    }
}

