/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.quercus.lib.file.LineReader;
import com.caucho.vfs.ReadStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.logging.Logger;

public class AbstractBinaryInput
implements BinaryInput {
    private static final Logger log = Logger.getLogger(AbstractBinaryInput.class.getName());
    private Env _env;
    private final LineReader _lineReader;
    private ReadStream _is;
    private boolean _isEOF = false;

    protected AbstractBinaryInput(Env env) {
        this._env = env;
        this._lineReader = new LineReader(env);
    }

    protected AbstractBinaryInput(Env env, ReadStream is) {
        this(env);
        this.init(is);
    }

    public void init(ReadStream is) {
        this._is = is;
    }

    public InputStream getInputStream() {
        return this._is;
    }

    public BinaryInput openCopy() throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        if (this._is != null) {
            this._is.setEncoding(encoding);
        }
    }

    public void unread() throws IOException {
        if (this._is != null) {
            this._is.unread();
            this._isEOF = false;
        }
    }

    public int read() throws IOException {
        if (this._is != null) {
            int c = this._is.read();
            this._isEOF = c == -1;
            return c;
        }
        return -1;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this._is != null) {
            int c = this._is.read(buffer, offset, length);
            this._isEOF = c == -1;
            return c;
        }
        return -1;
    }

    public int read(char[] buffer, int offset, int length) throws IOException {
        if (this._is != null) {
            int c = this._is.read(buffer, offset, length);
            this._isEOF = c == -1;
            return c;
        }
        return -1;
    }

    public StringValue read(int length) throws IOException {
        if (this._is == null) {
            return null;
        }
        StringValue bb = this._env.createBinaryBuilder();
        if (bb.appendRead(this._is, (long)length) > 0) {
            return bb;
        }
        return null;
    }

    public boolean readOptionalLinefeed() throws IOException {
        if (this._is == null) {
            return false;
        }
        int ch = this.read();
        if (ch == 10) {
            return true;
        }
        this._is.unread();
        return false;
    }

    public void writeToStream(OutputStream os, int length) throws IOException {
        if (this._is != null) {
            this._is.writeToStream(os, length);
        }
    }

    public StringValue readLine(long length) throws IOException {
        return this._lineReader.readLine(this._env, this, length);
    }

    public StringValue appendTo(StringValue builder) throws IOException {
        if (this._is != null) {
            return builder.append(this._is);
        }
        return builder;
    }

    public boolean isEOF() {
        if (this._is == null) {
            return true;
        }
        return this._isEOF;
    }

    public long getPosition() {
        if (this._is == null) {
            return -1L;
        }
        return this._is.getPosition();
    }

    public boolean setPosition(long offset) {
        if (this._is == null) {
            return false;
        }
        this._isEOF = false;
        try {
            return this._is.setPosition(offset);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public long seek(long offset, int whence) {
        long position;
        switch (whence) {
            case 1: {
                position = this.getPosition() + offset;
                break;
            }
            case 2: {
                position = this.getPosition();
                break;
            }
            default: {
                position = offset;
            }
        }
        if (!this.setPosition(position)) {
            return -1L;
        }
        return position;
    }

    public Value stat() {
        return BooleanValue.FALSE;
    }

    public void closeRead() {
        ReadStream is = this._is;
        this._is = null;
        if (is != null) {
            is.close();
        }
    }

    public Object toJavaObject() {
        return this;
    }

    public String getResourceType() {
        return "stream";
    }

    protected Env getEnv() {
        return this._env;
    }

    public void close() {
        this.closeRead();
    }

    public String toString() {
        if (this._is != null) {
            return "AbstractBinaryInput[" + this._is.getPath() + "]";
        }
        return "AbstractBinaryInput[closed]";
    }
}

