/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.file.BinaryStream;
import com.caucho.quercus.lib.file.SocketInputOutput;
import com.caucho.quercus.lib.file.StreamModule;
import com.caucho.quercus.lib.file.TcpInputOutput;
import com.caucho.quercus.lib.file.UdpInputOutput;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempCharBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(SocketModule.class);
    private static final Logger log = Logger.getLogger(SocketModule.class.getName());
    private static final int AF_UNIX = 1;
    private static final int AF_INET = 2;
    private static final int AF_INET6 = 10;
    private static final int SOCK_STREAM = 1;
    private static final int SOCK_DGRAM = 2;
    private static final int SOCK_RAW = 3;
    private static final int SOCK_SEQPACKET = 5;
    private static final int SOCK_RDM = 4;
    private static final int MSG_OOB = 1;
    private static final int MSG_WAITALL = 256;
    private static final int MSG_PEEK = 2;
    private static final int MSG_DONTROUTE = 4;
    private static final int SO_DEBUG = 1;
    private static final int SO_REUSEADDR = 2;
    private static final int SO_KEEPALIVE = 9;
    private static final int SO_DONTROUTE = 5;
    private static final int SO_LINGER = 13;
    private static final int SO_BROADCAST = 6;
    private static final int SO_OOBINLINE = 10;
    private static final int SO_SNDBUF = 7;
    private static final int SO_RCVBUF = 8;
    private static final int SO_SNDLOWAT = 19;
    private static final int SO_RCVLOWAT = 18;
    private static final int SO_SNDTIMEO = 21;
    private static final int SO_RCVTIMEO = 20;
    private static final int SO_TYPE = 3;
    private static final int SO_ERROR = 4;
    private static final int SOL_SOCKET = 1;
    private static final int SOMAXCONN = 128;
    private static final int PHP_NORMAL_READ = 1;
    private static final int PHP_BINARY_READ = 2;
    private static final int SOCKET_EPERM = 1;
    private static final int SOCKET_ENOENT = 2;
    private static final int SOCKET_EINTR = 4;
    private static final int SOCKET_EIO = 5;
    private static final int SOCKET_ENXIO = 6;
    private static final int SOCKET_E2BIG = 7;
    private static final int SOCKET_EBADF = 9;
    private static final int SOCKET_EAGAIN = 11;
    private static final int SOCKET_ENOMEM = 12;
    private static final int SOCKET_EACCES = 13;
    private static final int SOCKET_EFAULT = 14;
    private static final int SOCKET_ENOTBLK = 15;
    private static final int SOCKET_EBUSY = 16;
    private static final int SOCKET_EEXIST = 17;
    private static final int SOCKET_EXDEV = 18;
    private static final int SOCKET_ENODEV = 19;
    private static final int SOCKET_ENOTDIR = 20;
    private static final int SOCKET_EISDIR = 21;
    private static final int SOCKET_EINVAL = 22;
    private static final int SOCKET_ENFILE = 23;
    private static final int SOCKET_EMFILE = 24;
    private static final int SOCKET_ENOTTY = 25;
    private static final int SOCKET_ENOSPC = 28;
    private static final int SOCKET_ESPIPE = 29;
    private static final int SOCKET_EROFS = 30;
    private static final int SOCKET_EMLINK = 31;
    private static final int SOCKET_EPIPE = 32;
    private static final int SOCKET_ENAMETOOLONG = 36;
    private static final int SOCKET_ENOLCK = 37;
    private static final int SOCKET_ENOSYS = 38;
    private static final int SOCKET_ENOTEMPTY = 39;
    private static final int SOCKET_ELOOP = 40;
    private static final int SOCKET_EWOULDBLOCK = 11;
    private static final int SOCKET_ENOMSG = 42;
    private static final int SOCKET_EIDRM = 43;
    private static final int SOCKET_ECHRNG = 44;
    private static final int SOCKET_EL2NSYNC = 45;
    private static final int SOCKET_EL3HLT = 46;
    private static final int SOCKET_EL3RST = 47;
    private static final int SOCKET_ELNRNG = 48;
    private static final int SOCKET_EUNATCH = 49;
    private static final int SOCKET_ENOCSI = 50;
    private static final int SOCKET_EL2HLT = 51;
    private static final int SOCKET_EBADE = 52;
    private static final int SOCKET_EBADR = 53;
    private static final int SOCKET_EXFULL = 54;
    private static final int SOCKET_ENOANO = 55;
    private static final int SOCKET_EBADRQC = 56;
    private static final int SOCKET_EBADSLT = 57;
    private static final int SOCKET_ENOSTR = 60;
    private static final int SOCKET_ENODATA = 61;
    private static final int SOCKET_ETIME = 62;
    private static final int SOCKET_ENOSR = 63;
    private static final int SOCKET_ENONET = 64;
    private static final int SOCKET_EREMOTE = 66;
    private static final int SOCKET_ENOLINK = 67;
    private static final int SOCKET_EADV = 68;
    private static final int SOCKET_ESRMNT = 69;
    private static final int SOCKET_ECOMM = 70;
    private static final int SOCKET_EPROTO = 71;
    private static final int SOCKET_EMULTIHOP = 72;
    private static final int SOCKET_EBADMSG = 74;
    private static final int SOCKET_ENOTUNIQ = 76;
    private static final int SOCKET_EBADFD = 77;
    private static final int SOCKET_EREMCHG = 78;
    private static final int SOCKET_ERESTART = 85;
    private static final int SOCKET_ESTRPIPE = 86;
    private static final int SOCKET_EUSERS = 87;
    private static final int SOCKET_ENOTSOCK = 88;
    private static final int SOCKET_EDESTADDRREQ = 89;
    private static final int SOCKET_EMSGSIZE = 90;
    private static final int SOCKET_EPROTOTYPE = 91;
    private static final int SOCKET_ENOPROTOOPT = 92;
    private static final int SOCKET_EPROTONOSUPPORT = 93;
    private static final int SOCKET_ESOCKTNOSUPPORT = 94;
    private static final int SOCKET_EOPNOTSUPP = 95;
    private static final int SOCKET_EPFNOSUPPORT = 96;
    private static final int SOCKET_EAFNOSUPPORT = 97;
    private static final int SOCKET_EADDRINUSE = 98;
    private static final int SOCKET_EADDRNOTAVAIL = 99;
    private static final int SOCKET_ENETDOWN = 100;
    private static final int SOCKET_ENETUNREACH = 101;
    private static final int SOCKET_ENETRESET = 102;
    private static final int SOCKET_ECONNABORTED = 103;
    private static final int SOCKET_ECONNRESET = 104;
    private static final int SOCKET_ENOBUFS = 105;
    private static final int SOCKET_EISCONN = 106;
    private static final int SOCKET_ENOTCONN = 107;
    private static final int SOCKET_ESHUTDOWN = 108;
    private static final int SOCKET_ETOOMANYREFS = 109;
    private static final int SOCKET_ETIMEDOUT = 110;
    private static final int SOCKET_ECONNREFUSED = 111;
    private static final int SOCKET_EHOSTDOWN = 112;
    private static final int SOCKET_EHOSTUNREACH = 113;
    private static final int SOCKET_EALREADY = 114;
    private static final int SOCKET_EINPROGRESS = 115;
    private static final int SOCKET_EISNAM = 120;
    private static final int SOCKET_EREMOTEIO = 121;
    private static final int SOCKET_EDQUOT = 122;
    private static final int SOCKET_ENOMEDIUM = 123;
    private static final int SOCKET_EMEDIUMTYPE = 124;
    private static final int SOL_TCP = 6;
    private static final int SOL_UDP = 17;
    private static final HashMap<StringValue, Value> _constMap = new HashMap();

    @Override
    public Map<StringValue, Value> getConstMap() {
        return _constMap;
    }

    @ReturnNullAsFalse
    public static SocketInputOutput socket_create(Env env, int domain, int type, int protocol) {
        try {
            SocketInputOutput.Domain socketDomain = SocketInputOutput.Domain.AF_INET;
            switch (domain) {
                case 2: {
                    socketDomain = SocketInputOutput.Domain.AF_INET;
                    break;
                }
                case 10: {
                    socketDomain = SocketInputOutput.Domain.AF_INET6;
                    break;
                }
                case 1: {
                    env.warning(L.l("Unix sockets not supported"));
                    return null;
                }
                default: {
                    env.warning(L.l("Unknown domain: {0}", domain));
                    return null;
                }
            }
            switch (type) {
                case 1: {
                    return new TcpInputOutput(env, new Socket(), socketDomain);
                }
                case 2: {
                    return new UdpInputOutput(env, new DatagramSocket(), socketDomain);
                }
            }
            env.warning(L.l("socket stream not socked"));
            return null;
        }
        catch (Exception e) {
            env.warning(e);
            return null;
        }
    }

    public static boolean socket_bind(Env env, @NotNull SocketInputOutput socket, StringValue address, @Optional(value="0") int port) {
        try {
            InetAddress[] addresses = InetAddress.getAllByName(address.toString());
            if (addresses == null || addresses.length < 1) {
                return false;
            }
            InetSocketAddress socketAddress = new InetSocketAddress(addresses[0], port);
            socket.bind(socketAddress);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void socket_close(Env env, @NotNull SocketInputOutput socket) {
        socket.close();
    }

    public static boolean socket_connect(Env env, @NotNull SocketInputOutput socket, StringValue address, @Optional int port) {
        try {
            InetAddress[] addresses = InetAddress.getAllByName(address.toString());
            if (addresses == null || addresses.length < 1) {
                return false;
            }
            InetSocketAddress socketAddress = new InetSocketAddress(addresses[0], port);
            socket.connect(socketAddress);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static Value socket_get_status(Env env, BinaryStream stream) {
        return StreamModule.stream_get_meta_data(env, stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Value socket_read(Env env, @NotNull SocketInputOutput socket, int length, @Optional int type) {
        TempBuffer tempBuffer = null;
        TempCharBuffer tempCharBuffer = null;
        try {
            byte[] buffer;
            if (type == 1) {
                StringValue stringValue = socket.readLine(length);
                return stringValue;
            }
            tempBuffer = TempBuffer.allocate();
            if (length > tempBuffer.getCapacity()) {
                length = tempBuffer.getCapacity();
            }
            if ((length = socket.read(buffer = tempBuffer.getBuffer(), 0, length)) > 0) {
                StringValue sb;
                StringValue stringValue = sb = env.createBinaryBuilder(buffer, 0, length);
                return stringValue;
            }
            BooleanValue booleanValue = BooleanValue.FALSE;
            return booleanValue;
        }
        catch (IOException e) {
            env.warning(e);
            BooleanValue booleanValue = BooleanValue.FALSE;
            return booleanValue;
        }
        finally {
            if (tempCharBuffer != null) {
                TempCharBuffer.free(tempCharBuffer);
            }
            if (tempBuffer != null) {
                TempBuffer.free(tempBuffer);
            }
        }
    }

    public static boolean socket_set_timeout(Env env, @NotNull Value stream, int seconds, @Optional(value="-1") int milliseconds) {
        return StreamModule.stream_set_timeout(env, stream, seconds, milliseconds);
    }

    public static Value socket_write(Env env, @NotNull SocketInputOutput socket, @NotNull InputStream is, @Optional(value="-1") int length) {
        if (is == null) {
            return BooleanValue.FALSE;
        }
        if (length < 0) {
            length = Integer.MAX_VALUE;
        }
        try {
            int result = socket.write(is, length);
            if (result < 0) {
                return BooleanValue.FALSE;
            }
            return LongValue.create(result);
        }
        catch (IOException e) {
            log.log(Level.FINER, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    public boolean socket_shutdown(Env env, @NotNull SocketInputOutput file, int how) {
        if (file == null) {
            return false;
        }
        switch (how) {
            case 0: {
                file.closeRead();
                return true;
            }
            case 1: {
                file.closeWrite();
                return true;
            }
            case 2: {
                file.close();
                return true;
            }
        }
        return false;
    }

    static {
        SocketModule.addConstant(_constMap, "AF_UNIX", 1L);
        SocketModule.addConstant(_constMap, "AF_INET", 2L);
        SocketModule.addConstant(_constMap, "AF_INET6", 10L);
        SocketModule.addConstant(_constMap, "SOCK_STREAM", 1L);
        SocketModule.addConstant(_constMap, "SOCK_DGRAM", 2L);
        SocketModule.addConstant(_constMap, "SOCK_RAW", 3L);
        SocketModule.addConstant(_constMap, "SOCK_SEQPACKET", 5L);
        SocketModule.addConstant(_constMap, "SOCK_RDM", 4L);
        SocketModule.addConstant(_constMap, "MSG_OOB", 1L);
        SocketModule.addConstant(_constMap, "MSG_WAITALL", 256L);
        SocketModule.addConstant(_constMap, "MSG_PEEK", 2L);
        SocketModule.addConstant(_constMap, "MSG_DONTROUTE", 4L);
        SocketModule.addConstant(_constMap, "SO_DEBUG", 1L);
        SocketModule.addConstant(_constMap, "SO_REUSEADDR", 2L);
        SocketModule.addConstant(_constMap, "SO_KEEPALIVE", 9L);
        SocketModule.addConstant(_constMap, "SO_DONTROUTE", 5L);
        SocketModule.addConstant(_constMap, "SO_LINGER", 13L);
        SocketModule.addConstant(_constMap, "SO_BROADCAST", 6L);
        SocketModule.addConstant(_constMap, "SO_OOBINLINE", 10L);
        SocketModule.addConstant(_constMap, "SO_SNDBUF", 7L);
        SocketModule.addConstant(_constMap, "SO_RCVBUF", 8L);
        SocketModule.addConstant(_constMap, "SO_SNDLOWAT", 19L);
        SocketModule.addConstant(_constMap, "SO_RCVLOWAT", 18L);
        SocketModule.addConstant(_constMap, "SO_SNDTIMEO", 21L);
        SocketModule.addConstant(_constMap, "SO_RCVTIMEO", 20L);
        SocketModule.addConstant(_constMap, "SO_TYPE", 3L);
        SocketModule.addConstant(_constMap, "SO_ERROR", 4L);
        SocketModule.addConstant(_constMap, "SOL_SOCKET", 1L);
        SocketModule.addConstant(_constMap, "SOMAXCONN", 128L);
        SocketModule.addConstant(_constMap, "PHP_NORMAL_READ", 1L);
        SocketModule.addConstant(_constMap, "PHP_BINARY_READ", 2L);
        SocketModule.addConstant(_constMap, "SOCKET_EPERM", 1L);
        SocketModule.addConstant(_constMap, "SOCKET_ENOENT", 2L);
        SocketModule.addConstant(_constMap, "SOCKET_EINTR", 4L);
        SocketModule.addConstant(_constMap, "SOCKET_EIO", 5L);
        SocketModule.addConstant(_constMap, "SOCKET_ENXIO", 6L);
        SocketModule.addConstant(_constMap, "SOCKET_E2BIG", 7L);
        SocketModule.addConstant(_constMap, "SOCKET_EBADF", 9L);
        SocketModule.addConstant(_constMap, "SOCKET_EAGAIN", 11L);
        SocketModule.addConstant(_constMap, "SOCKET_ENOMEM", 12L);
        SocketModule.addConstant(_constMap, "SOCKET_EACCES", 13L);
        SocketModule.addConstant(_constMap, "SOCKET_EFAULT", 14L);
        SocketModule.addConstant(_constMap, "SOCKET_ENOTBLK", 15L);
        SocketModule.addConstant(_constMap, "SOCKET_EBUSY", 16L);
        SocketModule.addConstant(_constMap, "SOCKET_EEXIST", 17L);
        SocketModule.addConstant(_constMap, "SOCKET_EXDEV", 18L);
        SocketModule.addConstant(_constMap, "SOCKET_ENODEV", 19L);
        SocketModule.addConstant(_constMap, "SOCKET_ENOTDIR", 20L);
        SocketModule.addConstant(_constMap, "SOCKET_EISDIR", 21L);
        SocketModule.addConstant(_constMap, "SOCKET_EINVAL", 22L);
        SocketModule.addConstant(_constMap, "SOCKET_ENFILE", 23L);
        SocketModule.addConstant(_constMap, "SOCKET_EMFILE", 24L);
        SocketModule.addConstant(_constMap, "SOCKET_ENOTTY", 25L);
        SocketModule.addConstant(_constMap, "SOCKET_ENOSPC", 28L);
        SocketModule.addConstant(_constMap, "SOCKET_ESPIPE", 29L);
        SocketModule.addConstant(_constMap, "SOCKET_EROFS", 30L);
        SocketModule.addConstant(_constMap, "SOCKET_EMLINK", 31L);
        SocketModule.addConstant(_constMap, "SOCKET_EPIPE", 32L);
        SocketModule.addConstant(_constMap, "SOCKET_ENAMETOOLONG", 36L);
        SocketModule.addConstant(_constMap, "SOCKET_ENOLCK", 37L);
        SocketModule.addConstant(_constMap, "SOCKET_ENOSYS", 38L);
        SocketModule.addConstant(_constMap, "SOCKET_ENOTEMPTY", 39L);
        SocketModule.addConstant(_constMap, "SOCKET_ELOOP", 40L);
        SocketModule.addConstant(_constMap, "SOCKET_EWOULDBLOCK", 11L);
        SocketModule.addConstant(_constMap, "SOCKET_ENOMSG", 42L);
        SocketModule.addConstant(_constMap, "SOCKET_EIDRM", 43L);
        SocketModule.addConstant(_constMap, "SOCKET_ECHRNG", 44L);
        SocketModule.addConstant(_constMap, "SOCKET_EL2NSYNC", 45L);
        SocketModule.addConstant(_constMap, "SOCKET_EL3HLT", 46L);
        SocketModule.addConstant(_constMap, "SOCKET_EL3RST", 47L);
        SocketModule.addConstant(_constMap, "SOCKET_ELNRNG", 48L);
        SocketModule.addConstant(_constMap, "SOCKET_EUNATCH", 49L);
        SocketModule.addConstant(_constMap, "SOCKET_ENOCSI", 50L);
        SocketModule.addConstant(_constMap, "SOCKET_EL2HLT", 51L);
        SocketModule.addConstant(_constMap, "SOCKET_EBADE", 52L);
        SocketModule.addConstant(_constMap, "SOCKET_EBADR", 53L);
        SocketModule.addConstant(_constMap, "SOCKET_EXFULL", 54L);
        SocketModule.addConstant(_constMap, "SOCKET_ENOANO", 55L);
        SocketModule.addConstant(_constMap, "SOCKET_EBADRQC", 56L);
        SocketModule.addConstant(_constMap, "SOCKET_EBADSLT", 57L);
        SocketModule.addConstant(_constMap, "SOCKET_ENOSTR", 60L);
        SocketModule.addConstant(_constMap, "SOCKET_ENODATA", 61L);
        SocketModule.addConstant(_constMap, "SOCKET_ETIME", 62L);
        SocketModule.addConstant(_constMap, "SOCKET_ENOSR", 63L);
        SocketModule.addConstant(_constMap, "SOCKET_ENONET", 64L);
        SocketModule.addConstant(_constMap, "SOCKET_EREMOTE", 66L);
        SocketModule.addConstant(_constMap, "SOCKET_ENOLINK", 67L);
        SocketModule.addConstant(_constMap, "SOCKET_EADV", 68L);
        SocketModule.addConstant(_constMap, "SOCKET_ESRMNT", 69L);
        SocketModule.addConstant(_constMap, "SOCKET_ECOMM", 70L);
        SocketModule.addConstant(_constMap, "SOCKET_EPROTO", 71L);
        SocketModule.addConstant(_constMap, "SOCKET_EMULTIHOP", 72L);
        SocketModule.addConstant(_constMap, "SOCKET_EBADMSG", 74L);
        SocketModule.addConstant(_constMap, "SOCKET_ENOTUNIQ", 76L);
        SocketModule.addConstant(_constMap, "SOCKET_EBADFD", 77L);
        SocketModule.addConstant(_constMap, "SOCKET_EREMCHG", 78L);
        SocketModule.addConstant(_constMap, "SOCKET_ERESTART", 85L);
        SocketModule.addConstant(_constMap, "SOCKET_ESTRPIPE", 86L);
        SocketModule.addConstant(_constMap, "SOCKET_EUSERS", 87L);
        SocketModule.addConstant(_constMap, "SOCKET_ENOTSOCK", 88L);
        SocketModule.addConstant(_constMap, "SOCKET_EDESTADDRREQ", 89L);
        SocketModule.addConstant(_constMap, "SOCKET_EMSGSIZE", 90L);
        SocketModule.addConstant(_constMap, "SOCKET_EPROTOTYPE", 91L);
        SocketModule.addConstant(_constMap, "SOCKET_ENOPROTOOPT", 92L);
        SocketModule.addConstant(_constMap, "SOCKET_EPROTONOSUPPORT", 93L);
        SocketModule.addConstant(_constMap, "SOCKET_ESOCKTNOSUPPORT", 94L);
        SocketModule.addConstant(_constMap, "SOCKET_EOPNOTSUPP", 95L);
        SocketModule.addConstant(_constMap, "SOCKET_EPFNOSUPPORT", 96L);
        SocketModule.addConstant(_constMap, "SOCKET_EAFNOSUPPORT", 97L);
        SocketModule.addConstant(_constMap, "SOCKET_EADDRINUSE", 98L);
        SocketModule.addConstant(_constMap, "SOCKET_EADDRNOTAVAIL", 99L);
        SocketModule.addConstant(_constMap, "SOCKET_ENETDOWN", 100L);
        SocketModule.addConstant(_constMap, "SOCKET_ENETUNREACH", 101L);
        SocketModule.addConstant(_constMap, "SOCKET_ENETRESET", 102L);
        SocketModule.addConstant(_constMap, "SOCKET_ECONNABORTED", 103L);
        SocketModule.addConstant(_constMap, "SOCKET_ECONNRESET", 104L);
        SocketModule.addConstant(_constMap, "SOCKET_ENOBUFS", 105L);
        SocketModule.addConstant(_constMap, "SOCKET_EISCONN", 106L);
        SocketModule.addConstant(_constMap, "SOCKET_ENOTCONN", 107L);
        SocketModule.addConstant(_constMap, "SOCKET_ESHUTDOWN", 108L);
        SocketModule.addConstant(_constMap, "SOCKET_ETOOMANYREFS", 109L);
        SocketModule.addConstant(_constMap, "SOCKET_ETIMEDOUT", 110L);
        SocketModule.addConstant(_constMap, "SOCKET_ECONNREFUSED", 111L);
        SocketModule.addConstant(_constMap, "SOCKET_EHOSTDOWN", 112L);
        SocketModule.addConstant(_constMap, "SOCKET_EHOSTUNREACH", 113L);
        SocketModule.addConstant(_constMap, "SOCKET_EALREADY", 114L);
        SocketModule.addConstant(_constMap, "SOCKET_EINPROGRESS", 115L);
        SocketModule.addConstant(_constMap, "SOCKET_EISNAM", 120L);
        SocketModule.addConstant(_constMap, "SOCKET_EREMOTEIO", 121L);
        SocketModule.addConstant(_constMap, "SOCKET_EDQUOT", 122L);
        SocketModule.addConstant(_constMap, "SOCKET_ENOMEDIUM", 123L);
        SocketModule.addConstant(_constMap, "SOCKET_EMEDIUMTYPE", 124L);
        SocketModule.addConstant(_constMap, "SOL_TCP", 6L);
        SocketModule.addConstant(_constMap, "SOL_UDP", 17L);
    }
}

