/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.jms;

import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BinaryValue;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.jms.JMSModule;
import com.caucho.util.L10N;
import com.caucho.vfs.TempBuffer;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;

public class JMSQueue {
    private static final L10N L = new L10N(JMSQueue.class);
    private static final Logger log = Logger.getLogger(JMSQueue.class.getName());
    private Connection _connection;
    private Session _session;
    private MessageConsumer _consumer;
    private MessageProducer _producer;
    private Destination _destination;

    public JMSQueue(ConnectionFactory connectionFactory, Destination queue) throws Exception {
        this._connection = connectionFactory.createConnection();
        this._session = this._connection.createSession(false, 1);
        this._destination = queue == null ? this._session.createTemporaryQueue() : queue;
        this._consumer = this._session.createConsumer(this._destination);
        this._producer = this._session.createProducer(this._destination);
        this._connection.start();
    }

    public static Value __construct(Env env, @Optional String queueName) {
        JMSQueue queue = JMSModule.message_get_queue(env, queueName, null);
        if (queue == null) {
            env.warning(L.l("'{0}' is an unknown JMSQueue", queueName));
            return NullValue.NULL;
        }
        return env.wrapJava(queue);
    }

    public boolean send(@NotNull Value value, @Optional JMSQueue replyTo) throws JMSException {
        MapMessage message = null;
        if (value.isArray()) {
            message = this._session.createMapMessage();
            ArrayValue array = (ArrayValue)value;
            Set<Map.Entry<Value, Value>> entrySet = array.entrySet();
            for (Map.Entry<Value, Value> entry : entrySet) {
                if (entry.getValue() instanceof BinaryValue) {
                    byte[] bytes = ((BinaryValue)entry.getValue()).toBytes();
                    message.setBytes(entry.getKey().toString(), bytes);
                    continue;
                }
                message.setString(entry.getKey().toString(), entry.getValue().toString());
            }
        } else if (value instanceof BinaryValue) {
            message = this._session.createBytesMessage();
            byte[] bytes = ((BinaryValue)value).toBytes();
            ((BytesMessage)message).writeBytes(bytes);
        } else if (value.isLongConvertible()) {
            message = this._session.createStreamMessage();
            ((StreamMessage)message).writeLong(value.toLong());
        } else if (value.isDoubleConvertible()) {
            message = this._session.createStreamMessage();
            ((StreamMessage)message).writeDouble(value.toDouble());
        } else if (value.toJavaObject() instanceof String) {
            message = this._session.createTextMessage();
            ((TextMessage)message).setText(value.toString());
        } else if (value.toJavaObject() instanceof Serializable) {
            message = this._session.createObjectMessage();
            ((ObjectMessage)message).setObject((Serializable)value.toJavaObject());
        } else {
            return false;
        }
        if (replyTo != null) {
            message.setJMSReplyTo(replyTo._destination);
        }
        this._producer.send((Message)message);
        return true;
    }

    public Value receive(Env env, @Optional(value="1") long timeout) throws JMSException {
        Message message = this._consumer.receive(timeout);
        if (message == null) {
            return BooleanValue.FALSE;
        }
        if (message instanceof ObjectMessage) {
            Serializable object = ((ObjectMessage)message).getObject();
            return env.wrapJava(object);
        }
        if (message instanceof TextMessage) {
            return env.createString(((TextMessage)message).getText());
        }
        if (message instanceof StreamMessage) {
            Object object = ((StreamMessage)message).readObject();
            return env.wrapJava(object);
        }
        if (message instanceof BytesMessage) {
            int sublen;
            BytesMessage bytesMessage = (BytesMessage)message;
            int length = (int)bytesMessage.getBodyLength();
            StringValue bb = env.createBinaryBuilder(length);
            TempBuffer tempBuffer = TempBuffer.allocate();
            while ((sublen = bytesMessage.readBytes(tempBuffer.getBuffer())) > 0) {
                bb.append(tempBuffer.getBuffer(), 0, sublen);
            }
            TempBuffer.free(tempBuffer);
            return bb;
        }
        if (message instanceof MapMessage) {
            MapMessage mapMessage = (MapMessage)message;
            Enumeration mapNames = mapMessage.getMapNames();
            ArrayValueImpl array = new ArrayValueImpl();
            while (mapNames.hasMoreElements()) {
                String name = mapNames.nextElement().toString();
                Object object = mapMessage.getObject(name);
                array.put(env.createString(name), env.wrapJava(object));
            }
            return array;
        }
        return BooleanValue.FALSE;
    }

    protected void finalize() {
        try {
            this._connection.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }
}

