/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.mcrypt;

import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.util.L10N;
import java.security.Key;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Mcrypt {
    private static final L10N L = new L10N(Mcrypt.class);
    private static final Logger log = Logger.getLogger(Mcrypt.class.getName());
    private final String _algorithm;
    private final String _mode;
    private final Cipher _cipher;
    private Key _key;
    private IvParameterSpec _iv;

    Mcrypt(Env env, String algorithm, String mode) throws Exception {
        this._algorithm = algorithm;
        this._mode = mode.toUpperCase();
        String transformation = Mcrypt.getTransformation(algorithm, mode);
        if (transformation == null) {
            throw new QuercusRuntimeException(L.l("'{0}' is an unknown algorithm", algorithm));
        }
        this._cipher = Cipher.getInstance(transformation);
    }

    public boolean deinit() {
        return false;
    }

    public byte[] decrypt(byte[] data) {
        try {
            this._cipher.init(2, this._key, this._iv);
            int blockSize = this._cipher.getBlockSize();
            return this._cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] encrypt(byte[] data) {
        try {
            this._cipher.init(1, this._key, this._iv);
            if (this.isPadded()) {
                data = this.pad(data);
            }
            return this._cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int get_block_size() {
        return this._cipher.getBlockSize();
    }

    public String get_algorithms_name() {
        return this._algorithm;
    }

    public int get_iv_size() {
        if (this._mode.equals("OFB")) {
            return this._cipher.getBlockSize();
        }
        if (this._mode.equals("CFB")) {
            return this._cipher.getBlockSize();
        }
        if (this._mode.equals("CBC")) {
            return this._cipher.getBlockSize();
        }
        if (this._mode.equals("ECB")) {
            return this._cipher.getBlockSize();
        }
        return 0;
    }

    public Value get_supported_key_sizes() {
        ArrayValueImpl value = new ArrayValueImpl();
        if ("rijndael-128".equals(this._algorithm)) {
            value.put(16L);
            value.put(24L);
            value.put(32L);
        } else if ("rijndael-192".equals(this._algorithm)) {
            value.put(16L);
            value.put(24L);
            value.put(32L);
        } else if ("rijndael-256".equals(this._algorithm)) {
            value.put(16L);
            value.put(24L);
            value.put(32L);
        } else if ("tripledes".equals(this._algorithm)) {
            value.put(24L);
        } else if ("des".equals(this._algorithm)) {
            value.put(8L);
        }
        return value;
    }

    public int get_key_size() {
        if ("rijndael-128".equals(this._algorithm)) {
            return 32;
        }
        if ("rijndael-192".equals(this._algorithm)) {
            return 32;
        }
        if ("rijndael-256".equals(this._algorithm)) {
            return 32;
        }
        if ("tripledes".equals(this._algorithm)) {
            return 24;
        }
        if ("blowfish".equals(this._algorithm)) {
            return 56;
        }
        return this.get_block_size();
    }

    private boolean isPadKey() {
        return !"blowfish".equals(this._algorithm);
    }

    private byte[] padKey(byte[] keyData) {
        int keySize = this.get_key_size();
        int len = keyData.length;
        if ("rijndael-128".equals(this._algorithm) || "rijndael-192".equals(this._algorithm) || "rijndael-256".equals(this._algorithm)) {
            if (len <= 16) {
                keySize = 16;
            } else if (len <= 24) {
                keySize = 24;
            } else if (len <= 32) {
                keySize = 32;
            } else {
                throw new QuercusRuntimeException(L.l("Key too large for algorithm ({0} > 32)", len));
            }
        }
        if (len == keySize) {
            return keyData;
        }
        byte[] paddedKey = new byte[keySize];
        System.arraycopy(keyData, 0, paddedKey, 0, len);
        return paddedKey;
    }

    public String get_modes_name() {
        return this._mode;
    }

    public int init(byte[] keyBytesArg, byte[] iv) {
        byte[] keyBytes = this.isPadKey() ? this.padKey(keyBytesArg) : keyBytesArg;
        this._key = new SecretKeySpec(keyBytes, Mcrypt.getAlgorithm(this._algorithm));
        this._iv = iv == null ? null : (this._mode.equals("CBC") || this._mode.equals("CFB") || this._mode.equals("OFB") ? new IvParameterSpec(iv) : null);
        return 0;
    }

    public boolean is_block_algorithm() {
        return !this._algorithm.equals("blowfish");
    }

    public boolean is_block_algorithm_mode() {
        return this._mode.equals("CBC") || this._mode.equals("CFB") || this._mode.equals("OFB");
    }

    public boolean is_block_mode() {
        return this._mode.equals("CBC") || this._mode.equals("ECB");
    }

    private byte[] pad(byte[] data) {
        int len = data.length;
        int blockSize = this.get_block_size();
        int offset = len % blockSize;
        if (offset == 0) {
            return data;
        }
        byte[] pad = new byte[len + blockSize - offset];
        System.arraycopy(data, 0, pad, 0, data.length);
        return pad;
    }

    private boolean isPadded() {
        return !this._mode.equals("CFB") && !this._mode.equals("OFB");
    }

    public void close() {
    }

    private static String getTransformation(String algorithm, String mode) throws Exception {
        if ((mode = mode.toUpperCase()).equals("OFB")) {
            mode = "OFB8";
        }
        if ("rijndael-128".equals(algorithm)) {
            return "AES/" + mode + "/NoPadding";
        }
        if ("rijndael-192".equals(algorithm)) {
            return "Rijndael192/" + mode + "/NoPadding";
        }
        if ("rijndael-256".equals(algorithm)) {
            return "Rijndael256/" + mode + "/NoPadding";
        }
        if ("des".equals(algorithm)) {
            return "DES/" + mode + "/NoPadding";
        }
        if ("tripledes".equals(algorithm)) {
            return "DESede/" + mode + "/NoPadding";
        }
        if ("blowfish".equals(algorithm)) {
            return "Blowfish/" + mode + "/NoPadding";
        }
        if ("arcfour".equals(algorithm) || "RC4".equals(algorithm)) {
            return "ARCFOUR/" + mode + "/NoPadding";
        }
        return algorithm + '/' + mode + "/NoPadding";
    }

    private static String getAlgorithm(String algorithm) {
        if ("rijndael-128".equals(algorithm)) {
            return "AES";
        }
        if ("rijndael-192".equals(algorithm) || "rijndael-256".equals(algorithm)) {
            return "Rijndael";
        }
        if ("tripledes".equals(algorithm)) {
            return "DESede";
        }
        return algorithm;
    }

    public String toString() {
        return "Mcrypt[" + this._algorithm + ", " + this._mode + "]";
    }
}

