/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.pdf;

import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.pdf.AfmParser;
import com.caucho.quercus.lib.pdf.Font;
import com.caucho.quercus.lib.pdf.PDFFont;
import com.caucho.quercus.lib.pdf.PDFImage;
import com.caucho.quercus.lib.pdf.PDFPage;
import com.caucho.quercus.lib.pdf.PDFProcSet;
import com.caucho.quercus.lib.pdf.PDFStream;
import com.caucho.quercus.lib.pdf.PDFWriter;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;

public class PDF {
    private static final Logger log = Logger.getLogger(PDF.class.getName());
    private static final L10N L = new L10N(PDF.class);
    private static final double KAPPA = 0.5522847498;
    private static final int PAGE_GROUP = 8;
    private static HashMap<String, Font> _faceMap = new HashMap();
    private HashMap<PDFFont, PDFFont> _fontMap = new HashMap();
    private HashMap<PDFProcSet, PDFProcSet> _procSetMap = new HashMap();
    private TempStream _tempStream;
    private WriteStream _os;
    private PDFWriter _out;
    private ArrayList<PDFPage> _pageGroup = new ArrayList();
    private ArrayList<Integer> _pagesGroupList = new ArrayList();
    private int _pageCount;
    private int _catalogId;
    private int _pageParentId;
    private PDFPage _page;
    private PDFStream _stream;
    private Env _env;

    public PDF(Env env) {
        this._out = new PDFWriter(env.getOut());
        this._env = env;
    }

    public boolean begin_document(@Optional String fileName, @Optional String optList) throws IOException {
        this._tempStream = new TempStream();
        this._tempStream.openWrite();
        this._os = new WriteStream(this._tempStream);
        this._out = new PDFWriter(this._os);
        this._out.beginDocument();
        this._catalogId = this._out.allocateId(1);
        this._pageParentId = this._out.allocateId(1);
        return true;
    }

    public boolean begin_page(double width, double height) throws IOException {
        if (8 <= this._pageGroup.size()) {
            this._out.writePageGroup(this._pageParentId, this._pageGroup);
            this._pageGroup.clear();
            this._pagesGroupList.add(this._pageParentId);
            this._pageParentId = this._out.allocateId(1);
        }
        this._page = new PDFPage(this._out, this._pageParentId, width, height);
        this._stream = this._page.getStream();
        ++this._pageCount;
        this._pageGroup.add(this._page);
        return true;
    }

    public boolean begin_page_ext(double width, double height, String opt) throws IOException {
        return this.begin_page(width, height);
    }

    public boolean set_info(String key, String value) {
        if ("Author".equals(key)) {
            this._out.setAuthor(key);
            return true;
        }
        if ("Title".equals(key)) {
            this._out.setTitle(key);
            return true;
        }
        if ("Creator".equals(key)) {
            this._out.setCreator(key);
            return true;
        }
        return false;
    }

    public boolean set_parameter(String key, String value) {
        return false;
    }

    public boolean set_value(String key, double value) {
        return false;
    }

    public Value get_buffer(Env env) {
        TempStream ts = this._tempStream;
        this._tempStream = null;
        if (ts == null) {
            return BooleanValue.FALSE;
        }
        StringValue result = env.createBinaryBuilder();
        for (TempBuffer ptr = ts.getHead(); ptr != null; ptr = ptr.getNext()) {
            result.append(ptr.getBuffer(), 0, ptr.getLength());
        }
        ts.destroy();
        return result;
    }

    public String get_errmsg() {
        return "";
    }

    public int get_errnum() {
        return 0;
    }

    public String get_parameter(String name, @Optional double modifier) {
        if ("fontname".equals(name)) {
            PDFFont font = this._stream.getFont();
            if (font != null) {
                return font.getFontName();
            }
            return null;
        }
        return null;
    }

    public double get_value(String name, @Optional double modifier) {
        if ("ascender".equals(name)) {
            PDFFont font = this._stream.getFont();
            if (font != null) {
                return font.getAscender();
            }
            return 0.0;
        }
        if ("capheight".equals(name)) {
            PDFFont font = this._stream.getFont();
            if (font != null) {
                return font.getCapHeight();
            }
            return 0.0;
        }
        if ("descender".equals(name)) {
            PDFFont font = this._stream.getFont();
            if (font != null) {
                return font.getDescender();
            }
            return 0.0;
        }
        if ("fontsize".equals(name)) {
            return this._stream.getFontSize();
        }
        return 0.0;
    }

    public boolean initgraphics(Env env) {
        env.stub("initgraphics");
        return false;
    }

    public PDFFont load_font(String name, String encoding, String opt) throws IOException {
        Font face = this.loadFont(name);
        PDFFont font = new PDFFont(face, encoding, opt);
        PDFFont oldFont = this._fontMap.get(font);
        if (oldFont != null) {
            return oldFont;
        }
        font.setId(this._out.allocateId(1));
        this._fontMap.put(font, font);
        this._out.addPendingObject(font);
        return font;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Font loadFont(String name) throws IOException {
        HashMap<String, Font> hashMap = _faceMap;
        synchronized (hashMap) {
            Font face = _faceMap.get(name);
            if (face == null) {
                Path p = this._env.getQuercus().getPwd().lookup("WEB-INF/lib/");
                face = new AfmParser().parse(String.valueOf(p), name);
                _faceMap.put(name, face);
            }
            return face;
        }
    }

    public boolean setdash(double b, double w) {
        this._stream.setDash(b, w);
        return true;
    }

    public boolean setdashpattern(Env env, @Optional String optlist) {
        env.stub("setdashpattern");
        return false;
    }

    public boolean setflat(Env env, double flatness) {
        env.stub("setflat");
        return false;
    }

    public boolean setlinecap(Env env, int cap) {
        env.stub("setlinecap");
        return false;
    }

    public boolean setlinejoin(Env env, int linejoin) {
        env.stub("setlinejoin");
        return false;
    }

    public boolean setfont(@NotNull PDFFont font, double size) throws IOException {
        if (font == null) {
            return false;
        }
        this._stream.setFont(font, size);
        this._page.addResource(font.getResource());
        return true;
    }

    public boolean setmatrix(Env env, double a, double b, double c, double d, double e, double f) {
        env.stub("setmatrix");
        return false;
    }

    public boolean setmiterlimit(Env env, double v) {
        env.stub("setmiterlimit");
        return false;
    }

    public boolean shading_pattern(Env env, int shading, @Optional String optlist) {
        env.stub("shading_pattern");
        return false;
    }

    public int shading(Env env, String type, double x1, double y1, double x2, double y2, double c1, double c2, double c3, double c4, @Optional String optlist) {
        env.stub("shading");
        return 0;
    }

    public boolean shfill(Env env, int shading) {
        env.stub("shfill");
        return false;
    }

    public double stringwidth(String string, @NotNull PDFFont font, double size) {
        if (font == null) {
            return 0.0;
        }
        return size * font.stringWidth(string) / 1000.0;
    }

    public boolean set_text_pos(double x, double y) {
        this._stream.setTextPos(x, y);
        return true;
    }

    public boolean fill() {
        this._stream.fill();
        return true;
    }

    public boolean closepath() {
        this._stream.closepath();
        return true;
    }

    public boolean clip() {
        this._stream.clip();
        return true;
    }

    public boolean closepath_stroke() {
        this._stream.closepathStroke();
        return true;
    }

    public boolean closepath_fill_stroke() {
        this._stream.closepathFillStroke();
        return true;
    }

    public boolean fill_stroke() {
        this._stream.fillStroke();
        return true;
    }

    public boolean endpath() {
        this._stream.endpath();
        return true;
    }

    public boolean curveto(double x1, double y1, double x2, double y2, double x3, double y3) {
        this._stream.curveTo(x1, y1, x2, y2, x3, y3);
        return true;
    }

    public boolean curveto_b(double x1, double y1, double x2, double y2) {
        this._stream.curveTo(x1, y1, x1, y1, x2, y2);
        return true;
    }

    public boolean curveto_e(double x1, double y1, double x2, double y2) {
        this._stream.curveTo(x1, y1, x2, y2, x2, y2);
        return true;
    }

    public boolean arc(double x1, double y1, double r, double a, double b) {
        int bQuarter;
        int aQuarter;
        if ((a %= 360.0) < 0.0) {
            a += 360.0;
        }
        if ((b %= 360.0) < 0.0) {
            b += 360.0;
        }
        if (b < a) {
            b += 360.0;
        }
        if ((aQuarter = (int)(a / 90.0)) == (bQuarter = (int)(b / 90.0))) {
            this.clockwiseArc(x1, y1, r, a, b);
        } else {
            this.clockwiseArc(x1, y1, r, a, (aQuarter + 1) * 90);
            for (int q = aQuarter + 1; q < bQuarter; ++q) {
                this.clockwiseArc(x1, y1, r, q * 90, (q + 1) * 90);
            }
            this.clockwiseArc(x1, y1, r, bQuarter * 90, b);
        }
        return true;
    }

    public boolean arcn(double x1, double y1, double r, double a, double b) {
        int bQuarter;
        int aQuarter;
        if ((a %= 360.0) < 0.0) {
            a += 360.0;
        }
        if ((b %= 360.0) < 0.0) {
            b += 360.0;
        }
        if (a < b) {
            a += 360.0;
        }
        if ((aQuarter = (int)(a / 90.0)) == (bQuarter = (int)(b / 90.0))) {
            this.counterClockwiseArc(x1, y1, r, a, b);
        } else {
            this.counterClockwiseArc(x1, y1, r, a, aQuarter * 90);
            for (int q = aQuarter - 1; bQuarter < q; --q) {
                this.counterClockwiseArc(x1, y1, r, (q + 1) * 90, q * 90);
            }
            this.counterClockwiseArc(x1, y1, r, (bQuarter + 1) * 90, b);
        }
        return true;
    }

    private boolean clockwiseArc(double x, double y, double r, double aDeg, double bDeg) {
        double a = aDeg * Math.PI / 180.0;
        double b = bDeg * Math.PI / 180.0;
        double cos_a = Math.cos(a);
        double sin_a = Math.sin(a);
        double x1 = x + r * cos_a;
        double y1 = y + r * sin_a;
        double cos_b = Math.cos(b);
        double sin_b = Math.sin(b);
        double x2 = x + r * cos_b;
        double y2 = y + r * sin_b;
        double l = 0.5522847498 * r * 2.0 * (b - a) / Math.PI;
        this.lineto(x1, y1);
        this.curveto(x1 - l * sin_a, y1 + l * cos_a, x2 + l * sin_b, y2 - l * cos_b, x2, y2);
        return true;
    }

    private boolean counterClockwiseArc(double x, double y, double r, double aDeg, double bDeg) {
        double a = aDeg * Math.PI / 180.0;
        double b = bDeg * Math.PI / 180.0;
        double cos_a = Math.cos(a);
        double sin_a = Math.sin(a);
        double x1 = x + r * cos_a;
        double y1 = y + r * sin_a;
        double cos_b = Math.cos(b);
        double sin_b = Math.sin(b);
        double x2 = x + r * cos_b;
        double y2 = y + r * sin_b;
        double l = 0.5522847498 * r * 2.0 * (a - b) / Math.PI;
        this.lineto(x1, y1);
        this.curveto(x1 + l * sin_a, y1 - l * cos_a, x2 - l * sin_b, y2 + l * cos_b, x2, y2);
        return true;
    }

    public boolean circle(double x1, double y1, double r) {
        double l = r * 0.5522847498;
        this.moveto(x1, y1 + r);
        this.curveto(x1 - l, y1 + r, x1 - r, y1 + l, x1 - r, y1);
        this.curveto(x1 - r, y1 - l, x1 - l, y1 - r, x1, y1 - r);
        this.curveto(x1 + l, y1 - r, x1 + r, y1 - l, x1 + r, y1);
        this.curveto(x1 + r, y1 + l, x1 + l, y1 + r, x1, y1 + r);
        return true;
    }

    public boolean lineto(double x, double y) {
        this._stream.lineTo(x, y);
        return true;
    }

    public boolean moveto(double x, double y) {
        this._stream.moveTo(x, y);
        return true;
    }

    public boolean rect(double x, double y, double width, double height) {
        this._stream.rect(x, y, width, height);
        return true;
    }

    public boolean setgray_stroke(double g) {
        return this._stream.setcolor("stroke", "gray", g, 0.0, 0.0, 0.0);
    }

    public boolean setgray_fill(double g) {
        return this._stream.setcolor("fill", "gray", g, 0.0, 0.0, 0.0);
    }

    public boolean setgray(double g) {
        return this._stream.setcolor("both", "gray", g, 0.0, 0.0, 0.0);
    }

    public boolean setrgbcolor_stroke(double r, double g, double b) {
        return this._stream.setcolor("stroke", "rgb", r, g, b, 0.0);
    }

    public boolean setrgbcolor_fill(double r, double g, double b) {
        return this._stream.setcolor("fill", "rgb", r, g, b, 0.0);
    }

    public boolean setrgbcolor(double r, double g, double b) {
        return this._stream.setcolor("both", "rgb", r, g, b, 0.0);
    }

    public boolean setcolor(String fstype, String colorspace, double c1, @Optional double c2, @Optional double c3, @Optional double c4) {
        return this._stream.setcolor(fstype, colorspace, c1, c2, c3, c4);
    }

    public boolean setlinewidth(double w) {
        return this._stream.setlinewidth(w);
    }

    public boolean concat(double a, double b, double c, double d, double e, double f) {
        return this._stream.concat(a, b, c, d, e, f);
    }

    public PDFImage open_image_file(String type, Path file, @Optional String stringParam, @Optional int intParam) throws IOException {
        PDFImage img = new PDFImage(file);
        img.setId(this._out.allocateId(1));
        this._out.addPendingObject(img);
        return img;
    }

    public PDFImage load_image(String type, Path file, @Optional String optlist) throws IOException {
        PDFImage img = new PDFImage(file);
        img.setId(this._out.allocateId(1));
        this._out.addPendingObject(img);
        return img;
    }

    public boolean fit_image(PDFImage img, double x, double y, @Optional String opt) {
        this._page.addResource(img.getResource());
        this._stream.save();
        this.concat(img.get_width(), 0.0, 0.0, img.get_height(), x, y);
        this._stream.fit_image(img);
        this._stream.restore();
        return true;
    }

    public boolean skew(double aDeg, double bDeg) {
        double a = aDeg * Math.PI / 180.0;
        double b = bDeg * Math.PI / 180.0;
        return this._stream.concat(1.0, Math.tan(a), Math.tan(b), 1.0, 0.0, 0.0);
    }

    public boolean scale(double sx, double sy) {
        return this._stream.concat(sx, 0.0, 0.0, sy, 0.0, 0.0);
    }

    public boolean translate(double tx, double ty) {
        return this._stream.concat(1.0, 0.0, 0.0, 1.0, tx, ty);
    }

    public boolean rotate(double pDeg) {
        double p = pDeg * Math.PI / 180.0;
        return this._stream.concat(Math.cos(p), Math.sin(p), -Math.sin(p), Math.cos(p), 0.0, 0.0);
    }

    public boolean save() {
        return this._stream.save();
    }

    public boolean restore() {
        return this._stream.restore();
    }

    public boolean show(String text) {
        this._stream.show(text);
        return true;
    }

    public boolean show_boxed(String text, double x, double y, double width, double height, String mode, @Optional String feature) {
        this.set_text_pos(x, y);
        this._stream.show(text);
        return true;
    }

    public boolean show_xy(String text, double x, double y) {
        this.set_text_pos(x, y);
        this._stream.show(text);
        return true;
    }

    public boolean stroke() {
        this._stream.stroke();
        return true;
    }

    public boolean continue_text(String text) {
        this._stream.continue_text(text);
        return true;
    }

    public boolean end_page() {
        this._stream.flush();
        PDFProcSet procSet = this._stream.getProcSet();
        this._page.addResource(procSet.getResource());
        this._page = null;
        this._stream = null;
        return true;
    }

    public boolean end_page_ext(String optlist) {
        return this.end_page();
    }

    public boolean end_document(@Optional String optList) throws IOException {
        if (null == this._out) {
            return false;
        }
        if (this._pageGroup.size() > 0) {
            this._out.writePageGroup(this._pageParentId, this._pageGroup);
            this._pageGroup.clear();
            if (this._pagesGroupList.size() > 0) {
                this._pagesGroupList.add(this._pageParentId);
            }
        }
        this._out.writeCatalog(this._catalogId, this._pageParentId, this._pagesGroupList, this._pageCount);
        this._out.endDocument();
        this._os.close();
        this._out = null;
        return true;
    }

    public boolean close() throws IOException {
        return this.end_document("");
    }

    public boolean delete() throws IOException {
        return true;
    }

    public String toString() {
        return "PDF[]";
    }
}

