/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.pdf;

import com.caucho.quercus.lib.pdf.PDFStream;
import com.caucho.quercus.lib.pdf.PDFWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

public class PDFPage {
    private static final Logger log = Logger.getLogger(PDFStream.class.getName());
    private static final L10N L = new L10N(PDFStream.class);
    private int _parent;
    private int _id;
    private PDFStream _stream;
    private double _width;
    private double _height;
    private ArrayList<String> _resources = new ArrayList();

    PDFPage(PDFWriter out, int parent, double width, double height) {
        this._parent = parent;
        this._id = out.allocateId(1);
        this._width = width;
        this._height = height;
        this._stream = new PDFStream(out.allocateId(1));
    }

    public int getId() {
        return this._id;
    }

    public PDFStream getStream() {
        return this._stream;
    }

    void addResource(String resource) {
        if (!this._resources.contains(resource)) {
            this._resources.add(resource);
        }
    }

    void write(PDFWriter out) throws IOException {
        out.beginObject(this._id);
        out.println("  << /Type /Page");
        out.println("     /Parent " + this._parent + " 0 R");
        out.println("     /MediaBox [0 0 " + this._width + " " + this._height + "]");
        out.println("     /Contents " + this._stream.getId() + " 0 R");
        out.println("     /Resources <<");
        for (int i = 0; i < this._resources.size(); ++i) {
            out.println("      " + this._resources.get(i));
        }
        out.println("     >>");
        out.println("  >>");
        out.endObject();
        this._stream.write(out);
    }
}

