/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.regexp;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.lib.regexp.Regexp;
import com.caucho.quercus.lib.regexp.RegexpModule;

public class RegexpCache {
    private final Regexp[] _cache = new Regexp[4];
    private int _head;
    private static final int MAX_SIZE = 4;

    public Regexp get(Env env, StringValue str) {
        Regexp regexp;
        int head = this._head;
        for (int i = 0; i < 4 && (regexp = this._cache[(head + i) % 4]) != null; ++i) {
            StringValue rawRegexp = regexp.getRawRegexp();
            if (rawRegexp != str && !rawRegexp.equals(str)) continue;
            return regexp;
        }
        Regexp regexp2 = RegexpModule.createRegexp(env, str);
        if (--head < 0) {
            head = 3;
        }
        this._cache[head] = regexp2;
        this._head = head;
        return regexp2;
    }
}

