/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.spl;

import com.caucho.quercus.annotation.Name;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.This;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.Callback;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.MethodIntern;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.ArrayModule;
import com.caucho.quercus.lib.spl.ArrayAccess;
import com.caucho.quercus.lib.spl.Countable;
import com.caucho.quercus.lib.spl.SeekableIterator;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayIterator
implements SeekableIterator,
ArrayAccess,
Countable {
    public static final int STD_PROP_LIST = 1;
    public static final int ARRAY_AS_PROPS = 2;
    private static final StringValue _rewind = MethodIntern.intern("rewind");
    private Env _env;
    private Value _qThis;
    private Value _value = NullValue.NULL;
    private int _flags;
    private Iterator<Map.Entry<Value, Value>> _iterator;
    private Map.Entry<Value, Value> _current;

    @Name(value="__construct")
    public Value __construct(Env env, @This Value qThis, @Optional Value value, @Optional int flags) {
        this._env = env;
        this._qThis = qThis;
        if (value == null) {
            value = NullValue.NULL;
        }
        this._value = value;
        this._flags = flags;
        return qThis;
    }

    public void append(Value value) {
        this._value.put(value);
    }

    public void asort(ArrayValue array, @Optional long sortFlag) {
        sortFlag = 0L;
        if (this._value instanceof ArrayValue) {
            ArrayModule.asort(this._env, (ArrayValue)this._value, sortFlag);
        }
    }

    @Override
    public int count() {
        return this._value.getCount(this._env);
    }

    @Override
    public Value current(Env env) {
        if (this._iterator == null) {
            this.rewindJava(env);
        }
        return this._current == null ? UnsetValue.UNSET : this._current.getValue();
    }

    public Value getArrayCopy() {
        return this._value.copy();
    }

    public int getFlags() {
        return this._flags;
    }

    @Override
    public Value key(Env env) {
        if (this._iterator == null) {
            this.rewindJava(env);
        }
        return this._current == null ? UnsetValue.UNSET : this._current.getKey();
    }

    public void ksort(@Optional long sortFlag) {
        if (this._value instanceof ArrayValue) {
            ArrayModule.ksort(this._env, (ArrayValue)this._value, sortFlag);
        }
    }

    public void natcasesort() {
        if (this._value instanceof ArrayValue) {
            ArrayModule.natcasesort(this._env, this._value);
        }
    }

    public void natsort() {
        if (this._value instanceof ArrayValue) {
            ArrayModule.natsort(this._env, this._value);
        }
    }

    @Override
    public void next(Env env) {
        if (this._iterator == null) {
            this.rewind();
        }
        this._current = this._iterator.hasNext() ? this._iterator.next() : null;
    }

    @Override
    public boolean offsetExists(Value offset) {
        return this._value.get(offset).isset();
    }

    @Override
    public Value offsetGet(Value offset) {
        return this._value.get(offset);
    }

    @Override
    public Value offsetSet(Value offset, Value value) {
        return this._value.put(offset, value);
    }

    @Override
    public Value offsetUnset(Value offset) {
        return this._value.remove(offset);
    }

    public void rewindJava(Env env) {
        if (this._qThis != null) {
            this._qThis.callMethod(env, _rewind);
        } else {
            this.rewind();
        }
    }

    @Override
    public void rewind() {
        this._iterator = this._value.getIterator(this._env);
        this._current = this._iterator.hasNext() ? this._iterator.next() : null;
    }

    public void setFlags(Value flags) {
        this._flags = flags.toInt();
    }

    @Override
    public void seek(Env env, int index) {
        this.rewindJava(env);
        for (int i = 0; i < index; ++i) {
            if (!this._iterator.hasNext()) {
                this._current = null;
                break;
            }
            this._current = this._iterator.next();
        }
    }

    public void uasort(Callback func, @Optional long sortFlag) {
        if (this._value instanceof ArrayValue) {
            ArrayModule.uasort(this._env, (ArrayValue)this._value, func, sortFlag);
        }
    }

    public void uksort(Callback func, @Optional long sortFlag) {
        if (this._value instanceof ArrayValue) {
            ArrayModule.uksort(this._env, (ArrayValue)this._value, func, sortFlag);
        }
    }

    @Override
    public boolean valid() {
        if (this._iterator == null) {
            this.rewind();
        }
        return this._current != null;
    }

    private static void printDepth(WriteStream out, int depth) throws IOException {
        for (int i = depth; i > 0; --i) {
            out.print(' ');
        }
    }

    public void varDumpImpl(Env env, Value obj, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        String name = "ArrayIterator";
        if (obj != null) {
            name = obj.getClassName();
        }
        if ((this._flags & 1) == 0) {
            Value arrayValue = this._value;
            out.println("object(" + name + ") (" + arrayValue.getCount(env) + ") {");
            ++depth;
            Iterator<Map.Entry<Value, Value>> iterator = arrayValue.getIterator(env);
            while (iterator.hasNext()) {
                Map.Entry<Value, Value> entry = iterator.next();
                Value key = entry.getKey();
                Value value = entry.getValue();
                ArrayIterator.printDepth(out, 2 * depth);
                out.print("[");
                if (key.isString()) {
                    out.print("\"" + key + "\"");
                } else {
                    out.print(key);
                }
                out.println("]=>");
                ArrayIterator.printDepth(out, 2 * depth);
                value.varDump(env, out, depth, valueSet);
                out.println();
            }
            ArrayIterator.printDepth(out, 2 * --depth);
            out.print("}");
        }
    }
}

