/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.xml;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.Reference;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.xml.Xml;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;

public class XmlModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(XmlModule.class);
    public static final int XML_OPTION_CASE_FOLDING = 0;
    public static final int XML_OPTION_SKIP_TAGSTART = 1;
    public static final int XML_OPTION_SKIP_WHITE = 2;
    public static final int XML_OPTION_TARGET_ENCODING = 3;
    public static final int XML_ERROR_NONE = 0;
    public static final int XML_ERROR_NO_MEMORY = 1;
    public static final int XML_ERROR_SYNTAX = 2;
    public static final int XML_ERROR_NO_ELEMENTS = 3;
    public static final int XML_ERROR_INVALID_TOKEN = 4;
    public static final int XML_ERROR_UNCLOSED_TOKEN = 5;
    public static final int XML_ERROR_PARTIAL_CHAR = 6;
    public static final int XML_ERROR_TAG_MISMATCH = 7;
    public static final int XML_ERROR_DUPLICATE_ATTRIBUTE = 8;
    public static final int XML_ERROR_JUNK_AFTER_DOC_ELEMENT = 9;
    public static final int XML_ERROR_PARAM_ENTITY_REF = 10;
    public static final int XML_ERROR_UNDEFINED_ENTITY = 11;
    public static final int XML_ERROR_RECURSIVE_ENTITY_REF = 12;
    public static final int XML_ERROR_ASYNC_ENTITY = 13;
    public static final int XML_ERROR_BAD_CHAR_REF = 14;
    public static final int XML_ERROR_BINARY_ENTITY_REF = 15;
    public static final int XML_ERROR_ATTRIBUTE_EXTERNAL_ENTITY_REF = 16;
    public static final int XML_ERROR_MISPLACED_XML_PI = 17;
    public static final int XML_ERROR_UNKNOWN_ENCODING = 18;
    public static final int XML_ERROR_INCORRECT_ENCODING = 19;
    public static final int XML_ERROR_UNCLOSED_CDATA_SECTION = 20;
    public static final int XML_ERROR_EXTERNAL_ENTITY_HANDLING = 21;
    public static final int XML_ERROR_NOT_STANDALONE = 22;
    public static final int XML_ERROR_UNEXPECTED_STATE = 23;
    public static final int XML_ERROR_ENTITY_DECLARED_IN_PE = 24;
    public static final int XML_ERROR_FEATURE_REQUIRES_XML_DTD = 25;
    public static final int XML_ERROR_CANT_CHANGE_FEATURE_ONCE_PARSING = 26;
    public static final int XML_ERROR_UNBOUND_PREFIX = 27;
    public static final int XML_ERROR_UNDECLARING_PREFIX = 28;
    public static final int XML_ERROR_INCOMPLETE_PE = 29;
    public static final int XML_ERROR_XML_DECL = 30;
    public static final int XML_ERROR_TEXT_DECL = 31;
    public static final int XML_ERROR_PUBLICID = 32;
    public static final int XML_ERROR_SUSPENDED = 33;
    public static final int XML_ERROR_NOT_SUSPENDED = 34;
    public static final int XML_ERROR_ABORTED = 35;
    public static final int XML_ERROR_FINISHED = 36;
    public static final int XML_ERROR_SUSPEND_PE = 37;

    public String[] getLoadedExtensions() {
        return new String[]{"xml"};
    }

    public static Value utf8_encode(Env env, StringValue str) {
        StringValue sb = str.createStringBuilder();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch < '\u0080') {
                sb.append(ch);
                continue;
            }
            if (ch < '\u0800') {
                sb.append((char)(192 + (ch >> 6)));
                sb.append((char)(128 + (ch & 0x3F)));
                continue;
            }
            sb.append((char)(224 + (ch >> 12)));
            sb.append((char)(128 + (ch >> 6 & 0x3F)));
            sb.append((char)(128 + (ch & 0x3F)));
        }
        return sb;
    }

    public static Value utf8_decode(Env env, StringValue str) {
        StringValue sb = env.createUnicodeBuilder();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            int d2;
            int d1;
            int ch = str.charAt(i) & 0xFF;
            if (ch < 128) {
                sb.append((char)ch);
                continue;
            }
            if ((ch & 0xE0) == 192) {
                d1 = (ch & 0x1F) << 6;
                d2 = str.charAt(++i) & 0x3F;
                sb.append((char)(d1 + d2));
                continue;
            }
            d1 = (ch & 0xF) << 12;
            d2 = (str.charAt(++i) & 0x3F) << 6;
            int d3 = str.charAt(++i) & 0x3F;
            sb.append((char)(d1 + d2 + d3));
        }
        return sb;
    }

    public Value xml_get_current_byte_index(Xml parser) {
        if (parser == null) {
            return BooleanValue.FALSE;
        }
        return LongValue.create(parser.getByteIndex());
    }

    public Value xml_get_current_line_number(Xml parser) {
        if (parser == null) {
            return BooleanValue.FALSE;
        }
        return LongValue.create(parser.getLine());
    }

    public Value xml_get_current_column_number(Xml parser) {
        if (parser == null) {
            return BooleanValue.FALSE;
        }
        return LongValue.create(parser.getColumn());
    }

    public Value xml_get_error_code(Xml parser) {
        if (parser == null) {
            return BooleanValue.FALSE;
        }
        return LongValue.create(parser.getErrorCode());
    }

    public Value xml_error_string(int code) {
        switch (code) {
            case 0: {
                return StringValue.create("No error");
            }
            case 2: {
                return StringValue.create("syntax error");
            }
        }
        return BooleanValue.FALSE;
    }

    public int xml_parse(Env env, @NotNull Xml parser, StringValue data, @Optional(value="true") boolean isFinal) {
        if (parser == null) {
            return 0;
        }
        if (data.length() == 0) {
            return 0;
        }
        try {
            return parser.xml_parse(env, data, isFinal);
        }
        catch (Exception e) {
            throw QuercusModuleException.create(e);
        }
    }

    public Xml xml_parser_create(Env env, @Optional(value="'UTF-8'") String outputEncoding) {
        if (outputEncoding == null) {
            outputEncoding = "UTF-8";
        }
        return new Xml(env, outputEncoding, null);
    }

    public Xml xml_parser_create_ns(Env env, @Optional(value="'UTF-8'") String outputEncoding, @Optional(value="':'") String separator) {
        if (outputEncoding == null) {
            outputEncoding = "UTF-8";
        }
        return new Xml(env, outputEncoding, separator);
    }

    public boolean xml_parser_set_option(@NotNull Xml parser, @NotNull int option, @NotNull Value value) {
        if (parser == null) {
            return false;
        }
        return parser.xml_parser_set_option(option, value);
    }

    public Value xml_parser_get_option(Env env, @NotNull Xml parser, @NotNull int option) {
        if (parser == null) {
            return BooleanValue.FALSE;
        }
        return parser.xml_parser_get_option(env, option);
    }

    public boolean xml_set_element_handler(Env env, @NotNull Xml parser, @NotNull Value startElementHandler, @NotNull Value endElementHandler) {
        if (parser == null) {
            return false;
        }
        return parser.xml_set_element_handler(env, startElementHandler, endElementHandler);
    }

    public boolean xml_set_character_data_handler(Env env, @NotNull Xml parser, @NotNull Value handler) {
        if (parser == null) {
            return false;
        }
        return parser.xml_set_character_data_handler(env, handler);
    }

    public boolean xml_set_start_namespace_decl_handler(Env env, @NotNull Xml parser, @NotNull Value startNamespaceDeclHandler) {
        if (parser == null) {
            return false;
        }
        return parser.xml_set_start_namespace_decl_handler(env, startNamespaceDeclHandler);
    }

    public boolean xml_set_object(@NotNull Xml parser, @NotNull Value obj) {
        if (parser == null) {
            return false;
        }
        return parser.xml_set_object(obj);
    }

    public boolean xml_set_processing_instruction_handler(Env env, @NotNull Xml parser, @NotNull Value handler) {
        if (parser == null) {
            return false;
        }
        return parser.xml_set_processing_instruction_handler(env, handler);
    }

    public boolean xml_set_default_handler(Env env, @NotNull Xml parser, @NotNull Value handler) {
        if (parser == null) {
            return false;
        }
        return parser.xml_set_default_handler(env, handler);
    }

    public boolean xml_set_notation_decl_handler(Env env, @NotNull Xml parser, @NotNull Value handler) {
        if (parser == null) {
            return false;
        }
        return parser.xml_set_notation_decl_handler(env, handler);
    }

    public boolean xml_set_end_namespace_decl_handler(Env env, @NotNull Xml parser, @NotNull Value handler) {
        if (parser == null) {
            return false;
        }
        return parser.xml_set_end_namespace_decl_handler(env, handler);
    }

    public int xml_parse_into_struct(Env env, @NotNull Xml parser, StringValue data, @Reference Value valueArray, @Optional @Reference Value indexArray) {
        try {
            if (parser == null) {
                return 0;
            }
            return parser.xml_parse_into_struct(env, data, valueArray, indexArray);
        }
        catch (Exception e) {
            throw QuercusModuleException.create(e);
        }
    }

    public boolean xml_parser_free(@NotNull Xml parser) {
        return parser != null;
    }

    public boolean xml_set_unparsed_entity_decl_handler(Env env, @NotNull Xml parser, @NotNull Value handler) {
        if (parser == null) {
            return false;
        }
        return parser.xml_set_unparsed_entity_decl_handler(env, handler);
    }
}

