/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.zlib;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class GZInputStream
extends InputStream {
    private PushbackInputStream _in;
    private Inflater _inflater;
    private CRC32 _crc;
    private boolean _eof;
    private boolean _isGzip;
    private byte[] _readBuffer;
    private byte[] _tbuffer;
    private int _readBufferSize;
    private int _inputSize;
    private long _totalInputSize;

    public GZInputStream(InputStream in) throws IOException {
        this(in, 512);
    }

    public GZInputStream(InputStream in, int size) throws IOException {
        this._in = new PushbackInputStream(in, size);
        this._inflater = new Inflater(true);
        this._crc = new CRC32();
        this._eof = false;
        this._readBuffer = new byte[size];
        this._tbuffer = new byte[128];
        this._totalInputSize = 0L;
        this.init();
    }

    public int available() throws IOException {
        if (!this._isGzip) {
            return this._in.available();
        }
        if (this._eof) {
            return 0;
        }
        return 1;
    }

    public void close() throws IOException {
        this._inflater.end();
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        int n = this.read(b);
        if (n < 0) {
            return -1;
        }
        return b[0];
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (len <= 0 || off < 0 || off + len > b.length) {
            return 0;
        }
        if (this._eof) {
            return -1;
        }
        if (!this._isGzip) {
            return this._in.read(b, off, len);
        }
        try {
            int length;
            int sublen;
            for (length = 0; length < len; length += sublen) {
                if (this._inflater.needsInput()) {
                    this._readBufferSize = this._in.read(this._readBuffer, 0, this._readBuffer.length);
                    if (this._readBufferSize < 0) break;
                    this._inflater.setInput(this._readBuffer, 0, this._readBufferSize);
                }
                sublen = this._inflater.inflate(b, off + length, len - length);
                this._crc.update(b, off + length, sublen);
                this._inputSize += sublen;
                this._totalInputSize += (long)sublen;
                if (!this._inflater.finished()) continue;
                int remaining = this._inflater.getRemaining();
                this._in.unread(this._readBuffer, this._readBufferSize - remaining, remaining);
                this.readTrailer();
                int secondPart = this.read(b, off + length, len - length);
                return secondPart > 0 ? length + secondPart : length;
            }
            return length;
        }
        catch (DataFormatException e) {
            throw new IOException(e.getMessage());
        }
    }

    public long skip(long n) throws IOException {
        int length;
        long remaining;
        int sublen;
        if (this._eof || n <= 0L) {
            return 0L;
        }
        for (remaining = n; remaining > 0L && (sublen = this.read(this._tbuffer, 0, length = (int)Math.min((long)this._tbuffer.length, remaining))) >= 0; remaining -= (long)sublen) {
        }
        return n - remaining;
    }

    private void init() throws IOException {
        int c;
        this._inflater.reset();
        this._crc.reset();
        this._inputSize = 0;
        this._readBufferSize = 0;
        int length = this._in.read(this._tbuffer, 0, 10);
        if (length < 0) {
            this._isGzip = false;
            return;
        }
        if (length != 10) {
            this._isGzip = false;
            this._in.unread(this._tbuffer, 0, length);
            return;
        }
        if (this._tbuffer[0] != 31 || this._tbuffer[1] != -117) {
            this._isGzip = false;
            this._in.unread(this._tbuffer, 0, length);
            return;
        }
        byte flg = this._tbuffer[3];
        if ((flg & 4) > 0) {
            length = this._in.read(this._tbuffer, 0, 2);
            if (length != 2) {
                throw new IOException("Bad GZIP (FEXTRA) header.");
            }
            length = this._tbuffer[1] << 4 | this._tbuffer[0];
            this._in.skip(length);
        }
        if ((flg & 8) > 0) {
            c = this._in.read();
            while (c != 0) {
                if (c < 0) {
                    throw new IOException("Bad GZIP (FNAME) header.");
                }
                c = this._in.read();
            }
        }
        if ((flg & 0x10) > 0) {
            c = this._in.read();
            while (c != 0) {
                if (c < 0) {
                    throw new IOException("Bad GZIP (FCOMMENT) header.");
                }
                c = this._in.read();
            }
        }
        if ((flg & 2) > 0 && (length = this._in.read(this._tbuffer, 0, 2)) != 2) {
            throw new IOException("Bad GZIP (FHCRC) header.");
        }
        this._isGzip = true;
    }

    private void readTrailer() throws IOException {
        int length = this._in.read(this._tbuffer, 0, 8);
        if (length != 8) {
            throw new IOException("Bad GZIP trailer.");
        }
        int refValue = this._tbuffer[3] & 0xFF;
        refValue <<= 8;
        refValue |= this._tbuffer[2] & 0xFF;
        refValue <<= 8;
        refValue |= this._tbuffer[1] & 0xFF;
        refValue <<= 8;
        int value = (int)this._crc.getValue();
        if ((refValue |= this._tbuffer[0] & 0xFF) != value) {
            throw new IOException("Bad GZIP trailer (CRC32).");
        }
        refValue = this._tbuffer[7] & 0xFF;
        refValue <<= 8;
        refValue |= this._tbuffer[6] & 0xFF;
        refValue <<= 8;
        refValue |= this._tbuffer[5] & 0xFF;
        refValue <<= 8;
        if ((refValue |= this._tbuffer[4] & 0xFF) != this._inputSize) {
            throw new IOException("Bad GZIP trailer (LENGTH).");
        }
        int c = this._in.read();
        if (c < 0) {
            this._eof = true;
        } else {
            this._in.unread(c);
            this.init();
            if (!this._isGzip) {
                this._eof = true;
            }
        }
    }

    public boolean isGzip() {
        return this._isGzip;
    }
}

