/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.zlib;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.file.FileValue;
import com.caucho.quercus.lib.string.StringModule;
import com.caucho.quercus.lib.zlib.GZIPInputStream;
import com.caucho.quercus.lib.zlib.ZlibOutputStream;
import com.caucho.util.L10N;
import com.caucho.vfs.TempBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Zlib {
    private static final Logger log = Logger.getLogger(Zlib.class.getName());
    private static final L10N L = new L10N(Zlib.class);
    private InputStream _in;
    private ZlibOutputStream _gzout;
    private FileValue _fileValue;
    private boolean _isGZIPInputStream;

    public Zlib(Env env, String filename, String mode, boolean useIncludePath) {
        String filemode = this.getFileMode(mode);
        int compressionLevel = this.getCompressionLevel(mode);
        int compressionStrategy = this.getCompressionStrategy(mode);
        Object val = null;
        if (val != BooleanValue.FALSE) {
            this._fileValue = val;
        }
    }

    public int gzwrite(Env env, InputStream is, @Optional(value="-1") int length) {
        if (this._fileValue == null) {
            env.warning(L.l("file could not be open for writing"));
            return -1;
        }
        TempBuffer tb = TempBuffer.allocate();
        byte[] buffer = tb.getBuffer();
        int inputSize = 0;
        if (length < 0) {
            length = Integer.MAX_VALUE;
        }
        try {
            while (length > 0) {
                int sublen = buffer.length < length ? buffer.length : length;
                if ((sublen = is.read(buffer, 0, sublen)) > 0) {
                    this._gzout.write(buffer, 0, sublen);
                    inputSize += sublen;
                    length -= sublen;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(L.l(e.getMessage()));
        }
        TempBuffer.free(tb);
        return inputSize;
    }

    public boolean gzclose() {
        if (this._fileValue == null) {
            return false;
        }
        try {
            if (this._gzout != null) {
                this._gzout.close();
                this._gzout = null;
            }
            if (this._in != null) {
                this._in.close();
                this._in = null;
            }
        }
        catch (Exception e) {
            throw QuercusModuleException.create(e);
        }
        return true;
    }

    public int gzputs(Env env, @NotNull InputStream is, @Optional(value="-1") int length) {
        return this.gzwrite(env, is, length);
    }

    public Value gzgetc(Env env) {
        try {
            int ch = this._in.read();
            if (ch >= 0) {
                return env.createString(Character.toString((char)ch));
            }
            return BooleanValue.FALSE;
        }
        catch (IOException e) {
            throw QuercusModuleException.create(e);
        }
    }

    @ReturnNullAsFalse
    public StringValue gzgets(int length) {
        if (this._in == null) {
            return null;
        }
        UnicodeBuilderValue sbv = new UnicodeBuilderValue();
        try {
            int readChar;
            for (int i = 0; i < length - 1 && (readChar = this._in.read()) >= 0; ++i) {
                sbv.append((char)readChar);
                if (readChar != 10 && readChar != 13) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw QuercusModuleException.create(e);
        }
        if (sbv.length() > 0) {
            return sbv;
        }
        return null;
    }

    public ArrayValue gzfile() {
        boolean oldLength = false;
        ArrayValueImpl array = new ArrayValueImpl();
        try {
            StringValue line;
            while ((line = this.gzgets(Integer.MAX_VALUE)) != BooleanValue.FALSE) {
                ((ArrayValue)array).put(line);
            }
            return array;
        }
        catch (Exception e) {
            throw QuercusModuleException.create(e);
        }
    }

    public StringValue gzread(Env env, int length) {
        StringValue sb = env.createBinaryBuilder();
        if (this._in == null) {
            return sb;
        }
        sb.appendReadAll(this._in, (long)length);
        return sb;
    }

    public boolean gzeof() {
        if (this._isGZIPInputStream) {
            return ((GZIPInputStream)this._in).isEOS();
        }
        try {
            this._in.mark(1);
            int ch = this._in.read();
            this._in.reset();
            return ch == -1;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    @ReturnNullAsFalse
    public StringValue gzgetss(int length, @Optional StringValue allowedTags) {
        try {
            int readChar;
            if (this._in == null) {
                return null;
            }
            UnicodeBuilderValue sbv = new UnicodeBuilderValue();
            for (int i = 0; i < length && (readChar = this._in.read()) >= 0; ++i) {
                sbv.append((char)readChar);
                if (readChar == 10 || readChar == 13) break;
            }
            if (sbv.length() > 0) {
                return StringModule.strip_tags(sbv, allowedTags);
            }
            return null;
        }
        catch (Exception e) {
            throw QuercusModuleException.create(e);
        }
    }

    public boolean gzrewind() {
        try {
            if (this._in != null) {
                this._in.close();
            }
            this._in = this.getGZIPInputStream();
        }
        catch (IOException e) {
            throw QuercusModuleException.create(e);
        }
        return true;
    }

    protected InputStream getGZIPInputStream() throws IOException {
        try {
            this._isGZIPInputStream = true;
            return new GZIPInputStream(this._fileValue.getPath().openRead());
        }
        catch (IOException e) {
            this._isGZIPInputStream = false;
            return this._fileValue.getPath().openRead();
        }
    }

    private String getFileMode(String input) {
        String modifier = "";
        String filemode = input.substring(0, 1);
        block7: for (int i = 1; i < input.length(); ++i) {
            char ch = input.charAt(i);
            switch (ch) {
                case 'r': {
                    filemode = "r";
                    continue block7;
                }
                case 'w': {
                    filemode = "w";
                    continue block7;
                }
                case 'a': {
                    filemode = "a";
                    continue block7;
                }
                case 'b': {
                    modifier = "b";
                    continue block7;
                }
                case 't': {
                    modifier = "t";
                }
            }
        }
        return filemode + modifier;
    }

    private int getCompressionLevel(String input) {
        for (int i = input.length() - 1; i >= 0; --i) {
            char ch = input.charAt(i);
            if (ch < '0' || ch > '9') continue;
            return ch - 48;
        }
        return -1;
    }

    private int getCompressionStrategy(String input) {
        for (int i = input.length() - 1; i >= 0; --i) {
            char ch = input.charAt(i);
            switch (ch) {
                case 'f': {
                    return 1;
                }
                case 'h': {
                    return 2;
                }
            }
        }
        return 0;
    }

    public String toString() {
        return "Zlib[]";
    }
}

