/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.mysql;

import com.caucho.quercus.lib.db.QuercusConnection;
import com.caucho.quercus.mysql.MysqlColumn;
import com.caucho.quercus.mysql.MysqlDatabaseMetaData;
import com.caucho.quercus.mysql.MysqlReader;
import com.caucho.quercus.mysql.MysqlResultImpl;
import com.caucho.quercus.mysql.MysqlStatementImpl;
import com.caucho.quercus.mysql.MysqlWriter;
import com.caucho.quercus.mysql.QuercusMysqlDriver;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempOutputStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLTransientConnectionException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MysqlConnectionImpl
implements QuercusConnection {
    private static final Logger log = Logger.getLogger(MysqlConnectionImpl.class.getName());
    private static final L10N L = new L10N(MysqlConnectionImpl.class);
    private static final int CLIENT_LONG_PASSWORD = 1;
    private static final int CLIENT_FOUND_ROWS = 2;
    private static final int CLIENT_LONG_FLAG = 4;
    private static final int CLIENT_CONNECT_WITH_DB = 8;
    private static final int CLIENT_COMPRESS = 32;
    private static final int CLIENT_PROTOCOL_41 = 512;
    private static final int CLIENT_SSL = 2048;
    private static final int CLIENT_SECURE_CONNECTION = 32768;
    private static final int CLIENT_MULTI_STATEMENTS = 65536;
    private static final int CLIENT_MULTI_RESULTS = 131072;
    private static final int UTF8_MB3 = 33;
    private static final int COM_QUERY = 3;
    private QuercusMysqlDriver _driver;
    private String _host;
    private int _port;
    private String _database;
    private Socket _s;
    private MysqlReader _in;
    private MysqlWriter _out;
    private int _serverCapabilities;
    private int _serverLanguage;
    private byte[] _scrambleBuf = new byte[21];
    private byte[] _errorState = new byte[5];
    private String _catalog;
    private State _state = State.IDLE;

    MysqlConnectionImpl(QuercusMysqlDriver driver, String url, Properties info) throws SQLException {
        if (driver == null) {
            throw new NullPointerException();
        }
        this._driver = driver;
        this._host = driver.getHost();
        this._port = driver.getPort();
        this._catalog = this._database = driver.getDatabase();
        this.connect();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void connect() throws SQLException {
        Socket s = null;
        try {
            try {
                s = new Socket(this._host, this._port);
                InputStream is = s.getInputStream();
                OutputStream os = s.getOutputStream();
                ReadStream in = Vfs.openRead(is);
                WriteStream out = Vfs.openWrite(os);
                MysqlReader reader = new MysqlReader(this, in);
                MysqlWriter writer = new MysqlWriter(this, out);
                this.readHandshakeInit(reader);
                String user = "ferg";
                String password = "";
                this.writeClientAuth(writer, user, password, this._database);
                this.readOk(reader);
                this._s = s;
                this._in = reader;
                this._out = writer;
                return;
            }
            catch (IOException e) {
                throw new SQLTransientConnectionException(L.l("{0}:{1} is not an accessible host", (Object)this._host, this._port));
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (s == null) throw throwable;
            try {
                s.close();
                throw throwable;
            }
            catch (Exception e) {
                log.log(Level.FINEST, e.toString(), e);
            }
            throw throwable;
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new MysqlStatementImpl(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement();
    }

    @Override
    public String getCatalog() throws SQLException {
        return this._catalog;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        if (this._catalog == catalog || this._catalog != null && this._catalog.equals(catalog)) {
            return;
        }
        this._catalog = catalog;
        if (catalog == null) {
            return;
        }
        try {
            this.writeQuery("use " + catalog);
            this.readOk(this._in);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new MysqlDatabaseMetaData(this);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return false;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
    }

    @Override
    public void commit() throws SQLException {
    }

    @Override
    public void rollback() throws SQLException {
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public void close() throws SQLException {
        Socket s = this._s;
        this._s = null;
        MysqlWriter out = this._out;
        this._out = null;
        MysqlReader in = this._in;
        this._in = null;
    }

    private void readHandshakeInit(MysqlReader in) throws IOException, SQLException {
        in.readPacket();
        int protocolVersion = in.readByte();
        String serverVersion = in.readNullTermString();
        int threadId = in.readInt();
        in.readAll(this._scrambleBuf, 0, 8);
        in.skip(1);
        this._serverCapabilities = in.readShort();
        this._serverLanguage = in.readByte();
        int serverStatus = in.readShort();
        in.readAll(this._scrambleBuf, 8, 13);
        in.readAll(this._scrambleBuf, 8, 13);
    }

    private String readOk(MysqlReader in) throws IOException, SQLException {
        in.readPacket();
        int fieldCount = in.readByte();
        if (fieldCount == 255) {
            return this.readError(in);
        }
        if (fieldCount == 0) {
            long rows = in.readLengthCodedBinary();
            long insertId = in.readLengthCodedBinary();
            int status = in.readShort();
            int warningCount = in.readShort();
            String message = in.readTailString();
            in.endPacket();
            return message;
        }
        throw new SQLException("unexpected field");
    }

    String readResult(MysqlResultImpl result) throws SQLException {
        try {
            MysqlReader in = this._in;
            in.readPacket();
            int fieldCount = in.readByte();
            if (fieldCount == 255) {
                return this.readError(in);
            }
            if (fieldCount == 0) {
                result.setResultSet(false);
                result.setUpdateCount((int)in.readLengthCodedBinary());
                result.setInsertId(in.readLengthCodedBinary());
                int status = in.readShort();
                int warningCount = in.readShort();
                String message = in.readTailString();
            } else if (fieldCount == 254) {
                result.setResultSet(false);
            } else {
                result.setResultSet(true);
                fieldCount = (int)in.readLengthCodedBinary(fieldCount);
                this.readResultFields(result, fieldCount);
            }
            return null;
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    private void readResultFields(MysqlResultImpl result, int fieldCount) throws IOException, SQLException {
        MysqlReader in = this._in;
        result.setColumnCount(fieldCount);
        int index = 0;
        while (true) {
            in.readPacket();
            int count = in.readByte();
            if (count == 254 || count < 0) break;
            MysqlColumn column = result.getColumn(index++);
            if (count == 251) {
                System.out.println("NULL:");
                continue;
            }
            int len = (int)in.readLengthCodedBinary(count);
            char[] buffer = column.startCatalog(len);
            in.readAll(buffer, 0, len);
            len = (int)in.readLengthCodedBinary();
            buffer = column.startDatabase(len);
            in.readAll(buffer, 0, len);
            len = (int)in.readLengthCodedBinary();
            buffer = column.startTable(len);
            in.readAll(buffer, 0, len);
            len = (int)in.readLengthCodedBinary();
            buffer = column.startOrigTable(len);
            in.readAll(buffer, 0, len);
            len = (int)in.readLengthCodedBinary();
            buffer = column.startName(len);
            in.readAll(buffer, 0, len);
            len = (int)in.readLengthCodedBinary();
            buffer = column.startOrigName(len);
            in.readAll(buffer, 0, len);
            in.readByte();
            column.setCharset(in.readShort());
            column.setLength(in.readInt());
            column.setType(in.readByte());
            column.setFlags(in.readShort());
            column.setDecimals(in.readByte());
            int filler = in.readShort();
        }
        int warningCount = in.readShort();
        int statusFlags = in.readShort();
        result.setRowAvailable(true);
        this._state = State.FIELD_DATA;
    }

    private void skipRowData() throws SQLException {
        if (this._state != State.FIELD_DATA) {
            return;
        }
        try {
            int count;
            MysqlReader in = this._in;
            do {
                in.readPacket();
            } while ((count = in.readByte()) != 254 && count >= 0);
            this._state = State.IDLE;
            return;
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    boolean readRow(MysqlResultImpl result) throws SQLException {
        assert (this._state == State.FIELD_DATA);
        try {
            MysqlReader in = this._in;
            in.readPacket();
            int count = in.readByte();
            if (count == 254 || count < 0) {
                this._state = State.IDLE;
                return false;
            }
            int fieldCount = result.getColumnCount();
            TempOutputStream resultStream = result.getResultStream();
            if (resultStream == null) {
                throw new NullPointerException();
            }
            int offset = 0;
            int length = 0;
            int index = 0;
            MysqlColumn column = result.getColumn(index++);
            length = (int)in.readLengthCodedBinary(count);
            column.setRowOffset(offset);
            column.setRowLength(length);
            in.readData(resultStream, length);
            offset += length;
            --fieldCount;
            while (fieldCount > 0) {
                length = (int)in.readLengthCodedBinary();
                column = result.getColumn(index++);
                column.setRowOffset(offset);
                column.setRowLength(length);
                in.readData(resultStream, length);
                offset += length;
                --fieldCount;
            }
            return true;
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    private String readError(MysqlReader in) throws IOException, SQLException {
        int errno = in.readShort();
        int marker = in.readByte();
        StringBuilder sb = new StringBuilder();
        if (marker == 35) {
            in.readAll(this._errorState, 0, 5);
        } else {
            sb.append((char)marker);
        }
        int len = in.getPacketLength() - in.getPacketOffset();
        for (int i = 0; i < len; ++i) {
            int ch = in.readByte();
            if (ch <= 0) continue;
            sb.append((char)ch);
        }
        System.out.println("ERROR: errno=" + errno + " stat:" + new String(this._errorState) + " " + sb);
        throw new SQLException(sb.toString());
    }

    private void writeClientAuth(MysqlWriter out, String user, String password, String database) throws IOException, SQLException {
        out.startVariablePacket();
        int clientFlags = 0;
        clientFlags |= 0x200;
        clientFlags |= 1;
        clientFlags |= 4;
        clientFlags = 239237;
        clientFlags &= 0xFFFFFFDF;
        clientFlags &= 0xFFFFF7FF;
        if (this._database != null) {
            clientFlags |= 8;
        }
        out.writeInt(clientFlags);
        int maxPacketSize = 0x1000000;
        out.writeInt(maxPacketSize);
        int charsetNumber = 8;
        out.writeByte(charsetNumber);
        out.writeZero(23);
        out.writeNullTermString(user);
        byte[] hash = new byte[]{};
        out.writeByte(0);
        if (this._database != null) {
            out.writeNullTermString(this._database);
        }
        out.endVariablePacket();
        out.flush();
    }

    void writeQuery(String query) throws SQLException {
        if (this._state != State.IDLE) {
            this.skipRowData();
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " query '" + query + "'");
        }
        try {
            MysqlWriter out = this._out;
            int len = query.length() + 1;
            out.writeByte(len);
            out.writeByte(len >> 8);
            out.writeByte(len >> 16);
            out.writeByte(0);
            out.writeByte(3);
            out.write(query);
            out.flush();
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public Map getTypeMap() throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void setTransactionIsolation(int isolation) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void setHoldability(int hold) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._host + ":" + this._port + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        IDLE,
        FIELD_HEADER,
        FIELD_DATA;

    }
}

